/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockDispenseHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;

public class BlockPlacer
extends SimpleSlimefunItem<BlockDispenseHandler> {
    private String[] blacklist;

    public BlockPlacer(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, String[] keys, Object[] values) {
        super(category, item, recipeType, recipe, keys, values);
    }

    @Override
    public BlockDispenseHandler getItemHandler() {
        return (e, dispenser, facedBlock, machine) -> {
            e.setCancelled(true);
            if ((facedBlock.getType() == null || facedBlock.getType() == Material.AIR) && e.getItem().getType().isBlock() && !this.isBlacklisted(e.getItem().getType())) {
                SlimefunItem sfItem = SlimefunItem.getByItem(e.getItem());
                if (sfItem != null) {
                    if (!SlimefunPlugin.getRegistry().getBlockHandlers().containsKey(sfItem.getID())) {
                        this.placeSlimefunBlock(sfItem, e.getItem(), facedBlock, dispenser);
                    }
                } else {
                    this.placeBlock(e.getItem(), facedBlock, dispenser);
                }
            }
        };
    }

    private boolean isBlacklisted(Material type) {
        for (String blockType : this.blacklist) {
            if (!type.toString().equals(blockType)) continue;
            return true;
        }
        return false;
    }

    private void placeSlimefunBlock(SlimefunItem sfItem, ItemStack item, Block facedBlock, Dispenser dispenser) {
        facedBlock.setType(item.getType());
        BlockStorage.store(facedBlock, sfItem.getID());
        facedBlock.getWorld().playEffect(facedBlock.getLocation(), Effect.STEP_SOUND, (Object)item.getType());
        if (dispenser.getInventory().containsAtLeast(item, 2)) {
            dispenser.getInventory().removeItem(new ItemStack[]{new CustomItem(item, 1)});
        } else {
            Slimefun.runSync(() -> dispenser.getInventory().removeItem(new ItemStack[]{item}), 2L);
        }
    }

    private void placeBlock(ItemStack item, Block facedBlock, Dispenser dispenser) {
        facedBlock.setType(item.getType());
        if (item.hasItemMeta() && item.getItemMeta() instanceof BlockStateMeta) {
            BlockState itemBlockState = ((BlockStateMeta)item.getItemMeta()).getBlockState();
            BlockState blockState = facedBlock.getState();
            if (blockState instanceof Nameable && item.getItemMeta().hasDisplayName()) {
                ((Nameable)blockState).setCustomName(item.getItemMeta().getDisplayName());
            }
            blockState.update();
            if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14) && blockState instanceof BlockInventoryHolder) {
                ((BlockInventoryHolder)blockState).getInventory().setContents(((BlockInventoryHolder)itemBlockState).getInventory().getContents());
            }
        }
        facedBlock.getWorld().playEffect(facedBlock.getLocation(), Effect.STEP_SOUND, (Object)item.getType());
        if (dispenser.getInventory().containsAtLeast(item, 2)) {
            dispenser.getInventory().removeItem(new ItemStack[]{new CustomItem(item, 1)});
        } else {
            Slimefun.runSync(() -> dispenser.getInventory().removeItem(new ItemStack[]{item}), 2L);
        }
    }

    @Override
    public void postRegister() {
        List list = (List)Slimefun.getItemValue(this.getID(), "unplaceable-blocks");
        this.blacklist = list.toArray(new String[0]);
    }
}

