/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

final class CargoUtils {
    private static final int[] SLOTS = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};

    private CargoUtils() {
    }

    public static ItemStack withdraw(Block node, Block target, ItemStack template) {
        DirtyChestMenu menu = CargoUtils.getChestMenu(target);
        if (menu != null) {
            for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                ItemStack is = menu.getItemInSlot(slot);
                if (!SlimefunUtils.isItemSimilar(is, template, true) || !CargoUtils.matchesFilter(node, is, -1)) continue;
                if (is.getAmount() > template.getAmount()) {
                    menu.replaceExistingItem(slot, new CustomItem(is, is.getAmount() - template.getAmount()));
                    return template;
                }
                menu.replaceExistingItem(slot, null);
                return is.clone();
            }
        } else {
            BlockState state = target.getState();
            if (state instanceof InventoryHolder) {
                return CargoUtils.withdrawFromVanillaInventory(node, template, ((InventoryHolder)state).getInventory());
            }
        }
        return null;
    }

    private static ItemStack withdrawFromVanillaInventory(Block node, ItemStack template, Inventory inv) {
        int minSlot = 0;
        int maxSlot = inv.getContents().length;
        if (inv instanceof FurnaceInventory) {
            minSlot = 2;
            maxSlot = 3;
        } else if (inv instanceof BrewerInventory) {
            maxSlot = 3;
        }
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack is = inv.getContents()[slot];
            if (!SlimefunUtils.isItemSimilar(is, template, true) || !CargoUtils.matchesFilter(node, is, -1)) continue;
            if (is.getAmount() > template.getAmount()) {
                inv.setItem(slot, (ItemStack)new CustomItem(is, is.getAmount() - template.getAmount()));
                return template;
            }
            inv.setItem(slot, (ItemStack)new CustomItem(is, is.getAmount() - template.getAmount()));
            return is.clone();
        }
        return null;
    }

    public static ItemStackAndInteger withdraw(Block node, Block target, int index) {
        block6: {
            block5: {
                DirtyChestMenu menu = CargoUtils.getChestMenu(target);
                if (menu == null) break block5;
                for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                    ItemStack is = menu.getItemInSlot(slot);
                    if (!CargoUtils.matchesFilter(node, is, index)) continue;
                    menu.replaceExistingItem(slot, null);
                    return new ItemStackAndInteger(is.clone(), slot);
                }
                break block6;
            }
            BlockState state = target.getState();
            if (!(state instanceof InventoryHolder)) break block6;
            Inventory inv = ((InventoryHolder)state).getInventory();
            int minSlot = 0;
            int maxSlot = inv.getContents().length;
            if (inv instanceof FurnaceInventory) {
                minSlot = 2;
                maxSlot = 3;
            } else if (inv instanceof BrewerInventory) {
                maxSlot = 3;
            }
            for (int slot = minSlot; slot < maxSlot; ++slot) {
                ItemStack is = inv.getContents()[slot];
                if (!CargoUtils.matchesFilter(node, is, index)) continue;
                inv.setItem(slot, null);
                return new ItemStackAndInteger(is.clone(), slot);
            }
        }
        return null;
    }

    public static ItemStack insert(Block node, Block target, ItemStack stack, int index) {
        if (!CargoUtils.matchesFilter(node, stack, index)) {
            return stack;
        }
        DirtyChestMenu menu = CargoUtils.getChestMenu(target);
        if (menu != null) {
            for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.INSERT, stack)) {
                ItemStack is;
                ItemStack itemStack = is = menu.getItemInSlot(slot) == null ? null : menu.getItemInSlot(slot).clone();
                if (is == null) {
                    menu.replaceExistingItem(slot, stack.clone());
                    return null;
                }
                if (!SlimefunUtils.isItemSimilar(new CustomItem(is, 1), new CustomItem(stack, 1), true) || is.getAmount() >= is.getType().getMaxStackSize()) continue;
                int amount = is.getAmount() + stack.getAmount();
                if (amount > is.getType().getMaxStackSize()) {
                    is.setAmount(is.getType().getMaxStackSize());
                    stack.setAmount(amount - is.getType().getMaxStackSize());
                } else {
                    is.setAmount(amount);
                    stack = null;
                }
                menu.replaceExistingItem(slot, is);
                return stack;
            }
        } else {
            BlockState state = target.getState();
            if (state instanceof InventoryHolder) {
                return CargoUtils.insertIntoVanillaInventory(stack, ((InventoryHolder)state).getInventory());
            }
        }
        return stack;
    }

    private static ItemStack insertIntoVanillaInventory(ItemStack stack, Inventory inv) {
        int minSlot = 0;
        int maxSlot = inv.getContents().length;
        if (inv instanceof FurnaceInventory) {
            if (stack.getType().isFuel()) {
                minSlot = 1;
                maxSlot = 2;
            } else {
                maxSlot = 1;
            }
        } else if (inv instanceof BrewerInventory) {
            if (stack.getType() == Material.POTION || stack.getType() == Material.LINGERING_POTION || stack.getType() == Material.SPLASH_POTION) {
                maxSlot = 3;
            } else if (stack.getType() == Material.BLAZE_POWDER) {
                minSlot = 4;
                maxSlot = 5;
            } else {
                minSlot = 3;
                maxSlot = 4;
            }
        }
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack is = inv.getContents()[slot];
            if (is == null) {
                inv.setItem(slot, stack.clone());
                return null;
            }
            if (!SlimefunUtils.isItemSimilar(new CustomItem(is, 1), new CustomItem(stack, 1), true) || is.getAmount() >= is.getType().getMaxStackSize()) continue;
            int amount = is.getAmount() + stack.getAmount();
            if (amount > is.getType().getMaxStackSize()) {
                is.setAmount(is.getType().getMaxStackSize());
                stack.setAmount(amount - is.getType().getMaxStackSize());
            } else {
                is.setAmount(amount);
                stack = null;
            }
            inv.setItem(slot, is);
            return stack;
        }
        return stack;
    }

    public static DirtyChestMenu getChestMenu(Block block) {
        if (BlockStorage.hasInventory(block)) {
            return BlockStorage.getInventory(block);
        }
        return BlockStorage.getUniversalInventory(block);
    }

    public static boolean matchesFilter(Block block, ItemStack item, int index) {
        if (item == null) {
            return false;
        }
        Config blockInfo = BlockStorage.getLocationInfo(block.getLocation());
        if (blockInfo.getString("id").equals("CARGO_NODE_OUTPUT")) {
            return true;
        }
        BlockMenu menu = BlockStorage.getInventory(block.getLocation());
        boolean lore = "true".equals(blockInfo.getString("filter-lore"));
        if ("whitelist".equals(blockInfo.getString("filter-type"))) {
            ArrayList<CustomItem> items = new ArrayList<CustomItem>();
            for (int slot : SLOTS) {
                ItemStack template = menu.getItemInSlot(slot);
                if (template == null) continue;
                items.add(new CustomItem(template, 1));
            }
            if (items.isEmpty()) {
                return false;
            }
            if (index >= 0) {
                if (++index > items.size() - 1) {
                    index = 0;
                }
                BlockStorage.addBlockInfo(block, "index", String.valueOf(index));
                return SlimefunUtils.isItemSimilar(item, (ItemStack)items.get(index), lore);
            }
            Object object = items.iterator();
            while (object.hasNext()) {
                ItemStack stack = (ItemStack)object.next();
                if (!SlimefunUtils.isItemSimilar(item, stack, lore)) continue;
                return true;
            }
            return false;
        }
        for (int slot : SLOTS) {
            if (menu.getItemInSlot(slot) == null || !SlimefunUtils.isItemSimilar(item, new CustomItem(menu.getItemInSlot(slot), 1), lore)) continue;
            return false;
        }
        return true;
    }
}

