/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.gps.GPSNetwork;
import io.github.thebusybiscuit.slimefun4.api.network.NetworkManager;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.SlimefunRegistry;
import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.core.services.AutoSavingService;
import io.github.thebusybiscuit.slimefun4.core.services.BackupService;
import io.github.thebusybiscuit.slimefun4.core.services.BlockDataService;
import io.github.thebusybiscuit.slimefun4.core.services.CustomItemDataService;
import io.github.thebusybiscuit.slimefun4.core.services.CustomTextureService;
import io.github.thebusybiscuit.slimefun4.core.services.LocalizationService;
import io.github.thebusybiscuit.slimefun4.core.services.MinecraftRecipeService;
import io.github.thebusybiscuit.slimefun4.core.services.PermissionsService;
import io.github.thebusybiscuit.slimefun4.core.services.UpdaterService;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.core.services.metrics.MetricsService;
import io.github.thebusybiscuit.slimefun4.core.services.plugins.ThirdPartyPluginService;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.AncientAltarListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BackpackListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BlockListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BlockPhysicsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DeathpointListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DebugFishListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DispenserListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.EnhancedFurnaceListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.EntityKillListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ExplosionsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.FireworksListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.GadgetsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.GrapplingHookListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.IronGolemListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ItemPickupListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.MultiBlockListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.PlayerProfileListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunBootsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunBowListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunGuideListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunItemConsumeListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunItemListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SoulboundListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.TalismanListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.VanillaMachinesListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.WitherListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.WorldListener;
import io.github.thebusybiscuit.slimefun4.implementation.resources.GEOResourcesSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.PostSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.ResearchSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.SlimefunItemSetup;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.ArmorTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.SlimefunStartupTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.TickerTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AGenerator;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AReactor;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionManager;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SlimefunPlugin
extends JavaPlugin
implements SlimefunAddon {
    public static SlimefunPlugin instance;
    private MinecraftVersion minecraftVersion = MinecraftVersion.UNKNOWN;
    private final SlimefunRegistry registry = new SlimefunRegistry();
    private final TickerTask ticker = new TickerTask();
    private final SlimefunCommand command = new SlimefunCommand(this);
    private final CustomItemDataService itemDataService = new CustomItemDataService((Plugin)this, "slimefun_item");
    private final BlockDataService blockDataService = new BlockDataService((Plugin)this, "slimefun_block");
    private final CustomTextureService textureService = new CustomTextureService((Plugin)this);
    private final GitHubService gitHubService = new GitHubService("TheBusyBiscuit/Slimefun4");
    private final UpdaterService updaterService = new UpdaterService((Plugin)this, this.getFile());
    private final MetricsService metricsService = new MetricsService(this);
    private final AutoSavingService autoSavingService = new AutoSavingService();
    private final BackupService backupService = new BackupService();
    private final PermissionsService permissionsService = new PermissionsService(this);
    private final ThirdPartyPluginService thirdPartySupportService = new ThirdPartyPluginService(this);
    private final MinecraftRecipeService recipeService = new MinecraftRecipeService((Plugin)this);
    private LocalizationService local;
    private GPSNetwork gpsNetwork;
    private NetworkManager networkManager;
    private ProtectionManager protections;
    private Config researches;
    private Config items;
    private Config whitelist;
    private Config config;
    private AncientAltarListener ancientAltarListener;
    private BackpackListener backpackListener;
    private GrapplingHookListener grapplingHookListener;
    private SlimefunBowListener bowListener;

    public void onEnable() {
        if (this.getServer().getPluginManager().isPluginEnabled("CS-CoreLib")) {
            long timestamp = System.nanoTime();
            if (this.isVersionUnsupported()) {
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            instance = this;
            this.getLogger().log(Level.INFO, "Loading Files...");
            this.createDirectories();
            this.getLogger().log(Level.INFO, "Loading Config...");
            this.config = new Config((Plugin)this);
            this.registry.load(this.config);
            this.researches = new Config((Plugin)this, "Researches.yml");
            this.items = new Config((Plugin)this, "Items.yml");
            this.whitelist = new Config((Plugin)this, "whitelist.yml");
            this.textureService.load();
            this.permissionsService.load();
            this.local = new LocalizationService(this, this.config.getString("options.language"));
            this.gpsNetwork = new GPSNetwork();
            this.networkManager = new NetworkManager(this.config.getInt("options.max-network-size"));
            this.metricsService.start();
            if (this.config.getBoolean("options.auto-update")) {
                this.getLogger().log(Level.INFO, "Starting Auto-Updater...");
                this.updaterService.start();
            } else {
                this.updaterService.disable();
            }
            this.getLogger().log(Level.INFO, "Loading GEO-Resources...");
            GEOResourcesSetup.setup();
            this.getLogger().log(Level.INFO, "Loading Items...");
            PostSetup.setupItemSettings();
            try {
                SlimefunItemSetup.setup(this);
            }
            catch (Throwable x) {
                this.getLogger().log(Level.SEVERE, x, () -> "An Error occured while initializing SlimefunItems for Slimefun " + SlimefunPlugin.getVersion());
            }
            this.getLogger().log(Level.INFO, "Loading Researches...");
            try {
                ResearchSetup.setupResearches();
            }
            catch (Throwable x) {
                this.getLogger().log(Level.SEVERE, x, () -> "An Error occured while initializing Slimefun Researches for Slimefun " + SlimefunPlugin.getVersion());
            }
            this.registry.setResearchingEnabled(SlimefunPlugin.getResearchCfg().getBoolean("enable-researching"));
            PostSetup.setupWiki();
            this.gitHubService.connect(false);
            new SlimefunBootsListener(this);
            new SlimefunItemListener(this);
            new SlimefunItemConsumeListener(this);
            new BlockPhysicsListener(this);
            new MultiBlockListener(this);
            new GadgetsListener(this);
            new DispenserListener(this);
            new EntityKillListener(this);
            new BlockListener(this);
            new EnhancedFurnaceListener(this);
            new ItemPickupListener(this);
            new DeathpointListener(this);
            new ExplosionsListener(this);
            new DebugFishListener(this);
            new VanillaMachinesListener(this);
            new FireworksListener(this);
            new WitherListener(this);
            new IronGolemListener(this);
            this.bowListener = new SlimefunBowListener(this);
            this.ancientAltarListener = new AncientAltarListener();
            this.grapplingHookListener = new GrapplingHookListener();
            if (this.config.getBoolean("items.talismans")) {
                new TalismanListener(this);
            }
            if (this.config.getBoolean("items.soulbound")) {
                new SoulboundListener(this);
            }
            if (this.config.getBoolean("items.backpacks")) {
                this.backpackListener = new BackpackListener(this);
            }
            new SlimefunGuideListener(this, this.config.getBoolean("options.give-guide-on-first-join"));
            new WorldListener(this);
            new PlayerProfileListener(this);
            Slimefun.runSync(new SlimefunStartupTask(this, () -> {
                this.protections = new ProtectionManager(this.getServer());
                this.textureService.register(this.registry.getAllSlimefunItems());
                this.permissionsService.register(this.registry.getAllSlimefunItems());
                this.recipeService.load();
            }), 0L);
            this.command.register();
            if (this.config.getBoolean("options.enable-armor-effects")) {
                this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new ArmorTask(), 0L, (long)this.config.getInt("options.armor-update-interval") * 20L);
            }
            this.autoSavingService.start((Plugin)this, this.config.getInt("options.auto-save-delay-in-minutes"));
            this.ticker.start(this);
            this.thirdPartySupportService.start();
            this.gitHubService.start((Plugin)this);
            CSCoreLib.getLib().filterLog("([A-Za-z0-9_]{3,16}) issued server command: /sf elevator (.{0,})");
            this.getLogger().log(Level.INFO, "Slimefun has finished loading in {0}ms", DoubleHandler.fixDouble((double)(System.nanoTime() - timestamp) / 1000000.0));
        } else {
            this.getLogger().log(Level.INFO, "#################### - INFO - ####################");
            this.getLogger().log(Level.INFO, " ");
            this.getLogger().log(Level.INFO, "Slimefun could not be loaded (yet).");
            this.getLogger().log(Level.INFO, "It appears that you have not installed CS-CoreLib.");
            this.getLogger().log(Level.INFO, "Please download and install CS-CoreLib manually:");
            this.getLogger().log(Level.INFO, "https://thebusybiscuit.github.io/builds/TheBusyBiscuit/CS-CoreLib/master/");
            this.getCommand("slimefun").setExecutor((sender, cmd, label, args) -> {
                sender.sendMessage("You have forgotten to install CS-CoreLib! Slimefun is disabled.");
                sender.sendMessage("https://thebusybiscuit.github.io/builds/TheBusyBiscuit/CS-CoreLib/master/");
                return true;
            });
        }
    }

    private boolean isVersionUnsupported() {
        String currentVersion = ReflectionUtils.getVersion();
        if (currentVersion.startsWith("v")) {
            for (MinecraftVersion version : MinecraftVersion.values()) {
                if (!version.matches(currentVersion)) continue;
                this.minecraftVersion = version;
                return false;
            }
            this.getLogger().log(Level.SEVERE, "### Slimefun was not installed correctly!");
            this.getLogger().log(Level.SEVERE, "### You are using the wrong version of Minecraft!");
            this.getLogger().log(Level.SEVERE, "###");
            this.getLogger().log(Level.SEVERE, "### You are using Minecraft {0}", ReflectionUtils.getVersion());
            this.getLogger().log(Level.SEVERE, "### but Slimefun v{0} requires you to be using", this.getDescription().getVersion());
            this.getLogger().log(Level.SEVERE, "### Minecraft {0}", String.join((CharSequence)" / ", this.getSupportedVersions()));
            return true;
        }
        this.getLogger().log(Level.WARNING, "We could not determine the version of Minecraft you were using ({0})", currentVersion);
        return false;
    }

    private Collection<String> getSupportedVersions() {
        ArrayList<String> list = new ArrayList<String>();
        for (MinecraftVersion version : MinecraftVersion.values()) {
            if (version == MinecraftVersion.UNKNOWN) continue;
            list.add(version.getName());
        }
        return list;
    }

    public void onDisable() {
        if (instance == null) {
            return;
        }
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.ticker != null) {
            this.ticker.halt();
            this.ticker.run();
        }
        PlayerProfile.iterator().forEachRemaining(profile -> {
            if (profile.isDirty()) {
                profile.save();
            }
        });
        for (World world : Bukkit.getWorlds()) {
            try {
                BlockStorage storage = BlockStorage.getStorage(world);
                if (storage != null) {
                    storage.save(true);
                    continue;
                }
                this.getLogger().log(Level.SEVERE, "Could not save Slimefun Blocks for World \"{0}\"", world.getName());
            }
            catch (Exception x) {
                this.getLogger().log(Level.SEVERE, x, () -> "An Error occured while saving Slimefun-Blocks in World '" + world.getName() + "' for Slimefun " + SlimefunPlugin.getVersion());
            }
        }
        for (UniversalBlockMenu menu : this.registry.getUniversalInventories().values()) {
            menu.save();
        }
        this.backupService.run();
        AContainer.processing = null;
        AContainer.progress = null;
        AGenerator.processing = null;
        AGenerator.progress = null;
        AReactor.processing = null;
        AReactor.progress = null;
        instance = null;
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.closeInventory();
        }
    }

    private void createDirectories() {
        String[] storage = new String[]{"Players", "blocks", "stored-blocks", "stored-inventories", "stored-chunks", "universal-inventories", "waypoints", "block-backups"};
        String[] general = new String[]{"scripts", "generators", "error-reports", "cache/github"};
        for (String file : storage) {
            this.createDir("data-storage/Slimefun/" + file);
        }
        for (String file : general) {
            this.createDir("plugins/Slimefun/" + file);
        }
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static Config getCfg() {
        return SlimefunPlugin.instance.config;
    }

    public static Config getResearchCfg() {
        return SlimefunPlugin.instance.researches;
    }

    public static Config getItemCfg() {
        return SlimefunPlugin.instance.items;
    }

    public static Config getWhitelist() {
        return SlimefunPlugin.instance.whitelist;
    }

    public static GPSNetwork getGPSNetwork() {
        return SlimefunPlugin.instance.gpsNetwork;
    }

    public static TickerTask getTicker() {
        return SlimefunPlugin.instance.ticker;
    }

    public static String getVersion() {
        return instance.getDescription().getVersion();
    }

    public static ProtectionManager getProtectionManager() {
        return SlimefunPlugin.instance.protections;
    }

    public static LocalizationService getLocal() {
        return SlimefunPlugin.instance.local;
    }

    public static MinecraftRecipeService getMinecraftRecipes() {
        return SlimefunPlugin.instance.recipeService;
    }

    public static CustomItemDataService getItemDataService() {
        return SlimefunPlugin.instance.itemDataService;
    }

    public static CustomTextureService getItemTextureService() {
        return SlimefunPlugin.instance.textureService;
    }

    public static PermissionsService getPermissionsService() {
        return SlimefunPlugin.instance.permissionsService;
    }

    public static BlockDataService getBlockDataService() {
        return SlimefunPlugin.instance.blockDataService;
    }

    public static ThirdPartyPluginService getThirdPartySupportService() {
        return SlimefunPlugin.instance.thirdPartySupportService;
    }

    public static UpdaterService getUpdater() {
        return SlimefunPlugin.instance.updaterService;
    }

    public static GitHubService getGitHubService() {
        return SlimefunPlugin.instance.gitHubService;
    }

    public static SlimefunRegistry getRegistry() {
        return SlimefunPlugin.instance.registry;
    }

    public static NetworkManager getNetworkManager() {
        return SlimefunPlugin.instance.networkManager;
    }

    public static AncientAltarListener getAncientAltarListener() {
        return SlimefunPlugin.instance.ancientAltarListener;
    }

    public static GrapplingHookListener getGrapplingHookListener() {
        return SlimefunPlugin.instance.grapplingHookListener;
    }

    public static BackpackListener getBackpackListener() {
        return SlimefunPlugin.instance.backpackListener;
    }

    public static SlimefunBowListener getBowListener() {
        return SlimefunPlugin.instance.bowListener;
    }

    public static Set<Plugin> getInstalledAddons() {
        return Arrays.stream(instance.getServer().getPluginManager().getPlugins()).filter(plugin -> plugin.getDescription().getDepend().contains(instance.getName()) || plugin.getDescription().getSoftDepend().contains(instance.getName())).collect(Collectors.toSet());
    }

    public static SlimefunCommand getCommand() {
        return SlimefunPlugin.instance.command;
    }

    public static MinecraftVersion getMinecraftVersion() {
        return SlimefunPlugin.instance.minecraftVersion;
    }

    @Override
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Override
    public String getBugTrackerURL() {
        return "https://github.com/TheBusyBiscuit/Slimefun4/issues";
    }
}

