/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static String formatBigNumber(int i) {
        return NumberFormat.getNumberInstance(Locale.US).format(i);
    }

    public static Date parseGitHubDate(String date) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date.replace('T', ' ').replace("Z", ""));
        }
        catch (ParseException x) {
            Slimefun.getLogger().log(Level.SEVERE, x, () -> "An Error occured while parsing a GitHub-Date for Slimefun " + SlimefunPlugin.getVersion());
            return null;
        }
    }

    public static String timeDelta(Date date) {
        long timestamp = date.getTime();
        int hours = (int)((System.currentTimeMillis() - timestamp) / 3600000L);
        if (hours == 0) {
            return "> 1h";
        }
        if (hours / 24 == 0) {
            return hours % 24 + "h";
        }
        if (hours % 24 == 0) {
            return hours / 24 + "d";
        }
        return hours / 24 + "d " + hours % 24 + "h";
    }

    public static String getTimeLeft(int seconds) {
        String timeleft = "";
        int minutes = (int)((long)seconds / 60L);
        if (minutes > 0) {
            timeleft = timeleft + minutes + "m ";
        }
        return timeleft + (seconds -= minutes * 60) + "s";
    }
}

