/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideEntry;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import java.util.Deque;
import java.util.LinkedList;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.inventory.ItemStack;

public class GuideHistory {
    private final PlayerProfile profile;
    private final Deque<GuideEntry<?>> queue = new LinkedList();

    public GuideHistory(PlayerProfile profile) {
        this.profile = profile;
    }

    public void clear() {
        this.queue.clear();
    }

    public void add(Category category, int page) {
        this.refresh(category, page);
    }

    public void add(ItemStack item, int page) {
        this.refresh(item, page);
    }

    public void add(SlimefunItem item) {
        this.queue.add(new GuideEntry<SlimefunItem>(item, 0));
    }

    public void add(String searchTerm) {
        this.queue.add(new GuideEntry<String>(searchTerm, 0));
    }

    private <T> void refresh(T object, int page) {
        GuideEntry<?> lastEntry = this.getLastEntry(false);
        if (lastEntry != null && lastEntry.getIndexedObject() == object) {
            lastEntry.setPage(page);
        } else {
            this.queue.add(new GuideEntry<T>(object, page));
        }
    }

    public int size() {
        return this.queue.size();
    }

    private GuideEntry<?> getLastEntry(boolean remove) {
        if (remove && !this.queue.isEmpty()) {
            this.queue.removeLast();
        }
        return this.queue.isEmpty() ? null : this.queue.getLast();
    }

    public void openLastEntry(SlimefunGuideImplementation guide, boolean survival) {
        GuideEntry<?> entry = this.getLastEntry(false);
        this.open(guide, entry, survival);
    }

    public void goBack(SlimefunGuideImplementation guide, boolean survival) {
        GuideEntry<?> entry = this.getLastEntry(true);
        this.open(guide, entry, survival);
    }

    private <T> void open(SlimefunGuideImplementation guide, GuideEntry<T> entry, boolean survival) {
        if (entry == null) {
            guide.openMainMenu(this.profile, survival, 1);
        } else if (entry.getIndexedObject() instanceof Category) {
            guide.openCategory(this.profile, (Category)entry.getIndexedObject(), survival, entry.getPage());
        } else if (entry.getIndexedObject() instanceof SlimefunItem) {
            guide.displayItem(this.profile, (SlimefunItem)entry.getIndexedObject(), false);
        } else if (entry.getIndexedObject() instanceof String) {
            guide.openSearch(this.profile, (String)entry.getIndexedObject(), survival, false);
        } else if (entry.getIndexedObject() instanceof ItemStack) {
            guide.displayItem(this.profile, (ItemStack)entry.getIndexedObject(), entry.getPage(), false);
        }
    }
}

