/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockPhysicsListener
implements Listener {
    public BlockPhysicsListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockFall(EntityChangeBlockEvent e) {
        if (e.getEntity().getType() == EntityType.FALLING_BLOCK && BlockStorage.hasBlockInfo(e.getBlock())) {
            e.setCancelled(true);
            FallingBlock block = (FallingBlock)e.getEntity();
            if (block.getDropItem()) {
                block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(block.getBlockData().getMaterial(), 1));
            }
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent e) {
        for (Block b : e.getBlocks()) {
            if (!BlockStorage.hasBlockInfo(b) && (b.getRelative(e.getDirection()).getType() != Material.AIR || !BlockStorage.hasBlockInfo(b.getRelative(e.getDirection())))) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent e) {
        if (e.isSticky()) {
            for (Block b : e.getBlocks()) {
                if (!BlockStorage.hasBlockInfo(b) && (b.getRelative(e.getDirection()).getType() != Material.AIR || !BlockStorage.hasBlockInfo(b.getRelative(e.getDirection())))) continue;
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onLiquidFlow(BlockFromToEvent e) {
        Block block = e.getToBlock();
        String item = BlockStorage.checkID(block);
        if (item != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBucketUse(PlayerBucketEmptyEvent e) {
        Location l = e.getBlockClicked().getRelative(e.getBlockFace()).getLocation();
        if (BlockStorage.hasBlockInfo(l)) {
            e.setCancelled(true);
        }
    }
}

