/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.plugins;

import io.github.thebusybiscuit.slimefun4.core.services.plugins.ClearLagHook;
import io.github.thebusybiscuit.slimefun4.core.services.plugins.PlaceholderAPIHook;
import io.github.thebusybiscuit.slimefun4.core.services.plugins.WorldEditHook;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.plugin.Plugin;

public class ThirdPartyPluginService {
    private final SlimefunPlugin plugin;
    private boolean isExoticGardenInstalled = false;
    private boolean isChestTerminalInstalled = false;
    private boolean isEmeraldEnchantsInstalled = false;
    private boolean isCoreProtectInstalled = false;
    private boolean isPlaceholderAPIInstalled = false;

    public ThirdPartyPluginService(SlimefunPlugin plugin) {
        this.plugin = plugin;
    }

    public void start() {
        if (this.isPluginInstalled("PlaceholderAPI")) {
            this.isPlaceholderAPIInstalled = true;
            new PlaceholderAPIHook().register();
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (this.isPluginInstalled("ClearLag")) {
                new ClearLagHook(this.plugin);
            }
            this.isExoticGardenInstalled = this.isPluginInstalled("ExoticGarden");
            this.isChestTerminalInstalled = this.isPluginInstalled("ChestTerminal");
            this.isEmeraldEnchantsInstalled = this.isPluginInstalled("EmeraldEnchants");
            if (this.isPluginInstalled("WorldEdit")) {
                try {
                    Class.forName("com.sk89q.worldedit.extent.Extent");
                    new WorldEditHook();
                }
                catch (Exception x) {
                    String version = this.plugin.getServer().getPluginManager().getPlugin("WorldEdit").getDescription().getVersion();
                    Slimefun.getLogger().log(Level.WARNING, "Maybe consider updating WorldEdit or Slimefun?");
                    Slimefun.getLogger().log(Level.WARNING, "Failed to hook into WorldEdit v" + version, x);
                }
            }
        });
    }

    private boolean isPluginInstalled(String hook) {
        if (this.plugin.getServer().getPluginManager().isPluginEnabled(hook)) {
            Slimefun.getLogger().log(Level.INFO, "Hooked into Plugin: {0}", hook);
            return true;
        }
        return false;
    }

    public boolean isExoticGardenInstalled() {
        return this.isExoticGardenInstalled;
    }

    public boolean isChestTerminalInstalled() {
        return this.isChestTerminalInstalled;
    }

    public boolean isEmeraldEnchantsInstalled() {
        return this.isEmeraldEnchantsInstalled;
    }

    public boolean isCoreProtectInstalled() {
        return this.isCoreProtectInstalled;
    }

    public boolean isPlaceholderAPIInstalled() {
        return this.isPlaceholderAPIInstalled;
    }
}

