/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.Arrays;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public abstract class Refinery
extends AContainer
implements RecipeDisplayItem {
    public Refinery(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public String getInventoryTitle() {
        return "&cRefinery";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.FLINT_AND_STEEL);
    }

    @Override
    public String getMachineIdentifier() {
        return "REFINERY";
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return Arrays.asList(SlimefunItems.BUCKET_OF_OIL, SlimefunItems.BUCKET_OF_FUEL);
    }

    @Override
    protected void tick(Block b) {
        BlockMenu menu = BlockStorage.getInventory(b);
        if (this.isProcessing(b)) {
            int timeleft = (Integer)progress.get(b);
            if (timeleft > 0) {
                ChestMenuUtils.updateProgressbar(menu, 22, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                if (ChargableBlock.isChargable(b)) {
                    if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                        return;
                    }
                    ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                    progress.put(b, timeleft - 1);
                } else {
                    progress.put(b, timeleft - 1);
                }
            } else {
                menu.replaceExistingItem(22, new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ", new String[0]));
                menu.pushItem(((MachineRecipe)processing.get(b)).getOutput()[0], this.getOutputSlots());
                progress.remove(b);
                processing.remove(b);
            }
        } else {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunManager.isItemSimilar(menu.getItemInSlot(slot), SlimefunItems.BUCKET_OF_OIL, true)) continue;
                MachineRecipe r = new MachineRecipe(40, new ItemStack[0], new ItemStack[]{SlimefunItems.BUCKET_OF_FUEL});
                if (!menu.fits(SlimefunItems.BUCKET_OF_FUEL, this.getOutputSlots())) {
                    return;
                }
                menu.consumeItem(slot);
                processing.put(b, r);
                progress.put(b, r.getTicks());
                break;
            }
        }
    }
}

