/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.gps.GPSNetwork;
import io.github.thebusybiscuit.slimefun4.api.network.NetworkManager;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.SlimefunRegistry;
import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.core.services.AutoSavingService;
import io.github.thebusybiscuit.slimefun4.core.services.BackupService;
import io.github.thebusybiscuit.slimefun4.core.services.BlockDataService;
import io.github.thebusybiscuit.slimefun4.core.services.CustomItemDataService;
import io.github.thebusybiscuit.slimefun4.core.services.CustomTextureService;
import io.github.thebusybiscuit.slimefun4.core.services.LocalizationService;
import io.github.thebusybiscuit.slimefun4.core.services.MinecraftRecipeService;
import io.github.thebusybiscuit.slimefun4.core.services.PermissionsService;
import io.github.thebusybiscuit.slimefun4.core.services.UpdaterService;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.core.services.metrics.MetricsService;
import io.github.thebusybiscuit.slimefun4.core.services.plugins.ThirdPartyPluginService;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.AncientAltarListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BackpackListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BlockListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BlockPhysicsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ButcherAndroidListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.CoolerListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DeathpointListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DebugFishListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DispenserListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.EnhancedFurnaceListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.EntityKillListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ExplosionsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.FireworksListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.GadgetsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.GrapplingHookListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.IronGolemListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ItemPickupListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.MultiBlockListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.NetworkListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.PlayerProfileListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunBootsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunBowListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunGuideListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunItemConsumeListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunItemListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SoulboundListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.TalismanListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.TeleporterListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.VampireBladeListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.VanillaMachinesListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.WitherListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.WorldListener;
import io.github.thebusybiscuit.slimefun4.implementation.resources.GEOResourcesSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.PostSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.ResearchSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.SlimefunItemSetup;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.ArmorTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.TickerTask;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.Slimefun.MinecraftVersion;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AGenerator;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AReactor;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionManager;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SlimefunPlugin
extends JavaPlugin
implements SlimefunAddon {
    public static SlimefunPlugin instance;
    private final SlimefunRegistry registry = new SlimefunRegistry();
    private MinecraftVersion minecraftVersion = MinecraftVersion.UNKNOWN;
    private final CustomItemDataService itemDataService = new CustomItemDataService((Plugin)this, "slimefun_item");
    private final BlockDataService blockDataService = new BlockDataService((Plugin)this, "slimefun_block");
    private final CustomTextureService textureService = new CustomTextureService((Plugin)this);
    private final GitHubService gitHubService = new GitHubService("TheBusyBiscuit/Slimefun4");
    private final UpdaterService updaterService = new UpdaterService((Plugin)this, this.getFile());
    private final MetricsService metricsService = new MetricsService(this);
    private final AutoSavingService autoSavingService = new AutoSavingService();
    private final BackupService backupService = new BackupService();
    private final PermissionsService permissionsService = new PermissionsService(this);
    private final ThirdPartyPluginService thirdPartySupportService = new ThirdPartyPluginService(this);
    private final MinecraftRecipeService recipeService = new MinecraftRecipeService((Plugin)this);
    private LocalizationService local;
    private GPSNetwork gpsNetwork;
    private NetworkManager networkManager;
    private ProtectionManager protections;
    private TickerTask ticker;
    private SlimefunCommand command;
    private Config researches;
    private Config items;
    private Config whitelist;
    private Config config;
    private AncientAltarListener ancientAltarListener;
    private BackpackListener backpackListener;
    private GrapplingHookListener grapplingHookListener;
    private SlimefunBowListener bowListener;

    public void onEnable() {
        if (this.getServer().getPluginManager().isPluginEnabled("CS-CoreLib")) {
            if (this.isVersionUnsupported()) {
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            instance = this;
            this.getLogger().log(Level.INFO, "Loading Files...");
            this.createDirectories();
            this.getLogger().log(Level.INFO, "Loading Config...");
            this.config = new Config((Plugin)this);
            this.registry.load(this.config);
            this.researches = new Config((Plugin)this, "Researches.yml");
            this.items = new Config((Plugin)this, "Items.yml");
            this.whitelist = new Config((Plugin)this, "whitelist.yml");
            this.textureService.load();
            this.permissionsService.load();
            this.local = new LocalizationService(this, this.config.getString("options.language"));
            this.networkManager = new NetworkManager(this.config.getInt("options.max-network-size"));
            this.gpsNetwork = new GPSNetwork();
            this.metricsService.start();
            if (this.config.getBoolean("options.auto-update")) {
                this.getLogger().log(Level.INFO, "Starting Auto-Updater...");
                this.updaterService.start();
            } else {
                this.updaterService.disable();
            }
            this.getLogger().log(Level.INFO, "Loading GEO-Resources...");
            GEOResourcesSetup.setup();
            this.getLogger().log(Level.INFO, "Loading Items...");
            PostSetup.setupItemSettings();
            try {
                SlimefunItemSetup.setup(this);
            }
            catch (Throwable x) {
                this.getLogger().log(Level.SEVERE, "An Error occured while initializing SlimefunItems for Slimefun " + SlimefunPlugin.getVersion(), x);
            }
            this.getLogger().log(Level.INFO, "Loading Researches...");
            try {
                ResearchSetup.setupResearches();
            }
            catch (Throwable x) {
                this.getLogger().log(Level.SEVERE, "An Error occured while initializing Slimefun Researches for Slimefun " + SlimefunPlugin.getVersion(), x);
            }
            this.registry.setResearchingEnabled(SlimefunPlugin.getResearchCfg().getBoolean("enable-researching"));
            PostSetup.setupWiki();
            this.gitHubService.connect(false);
            new SlimefunBootsListener(this);
            new SlimefunItemListener(this);
            new SlimefunItemConsumeListener(this);
            new BlockPhysicsListener(this);
            new MultiBlockListener(this);
            new GadgetsListener(this);
            new DispenserListener(this);
            new EntityKillListener(this);
            new BlockListener(this);
            new EnhancedFurnaceListener(this);
            new ItemPickupListener(this);
            new DeathpointListener(this);
            new ExplosionsListener(this);
            new DebugFishListener(this);
            new VanillaMachinesListener(this);
            new FireworksListener(this);
            new WitherListener(this);
            new IronGolemListener(this);
            this.bowListener = new SlimefunBowListener(this);
            this.ancientAltarListener = new AncientAltarListener();
            this.grapplingHookListener = new GrapplingHookListener();
            if (this.config.getBoolean("items.talismans")) {
                new TalismanListener(this);
            }
            if (this.config.getBoolean("items.soulbound")) {
                new SoulboundListener(this);
            }
            if (this.config.getBoolean("items.backpacks")) {
                this.backpackListener = new BackpackListener(this);
            }
            new SlimefunGuideListener(this, this.config.getBoolean("options.give-guide-on-first-join"));
            new WorldListener(this);
            new PlayerProfileListener(this);
            Slimefun.runSync(() -> {
                this.textureService.register(this.registry.getAllSlimefunItems());
                this.permissionsService.register(this.registry.getAllSlimefunItems());
                this.recipeService.load();
                this.protections = new ProtectionManager(this.getServer());
                PostSetup.loadItems();
                for (World world : Bukkit.getWorlds()) {
                    new BlockStorage(world);
                }
                if (this.isEnabled("ANCIENT_ALTAR")) {
                    this.ancientAltarListener.load(this);
                }
                if (this.isEnabled("GRAPPLING_HOOK")) {
                    this.grapplingHookListener.load(this);
                }
                if (this.isEnabled("BLADE_OF_VAMPIRES")) {
                    new VampireBladeListener(this);
                }
                if (this.isEnabled("COOLER")) {
                    new CoolerListener(this);
                }
                if (this.isEnabled("ELEVATOR_PLATE", "GPS_ACTIVATION_DEVICE_SHARED", "GPS_ACTIVATION_DEVICE_PERSONAL")) {
                    new TeleporterListener(this);
                }
                if (this.isEnabled("PROGRAMMABLE_ANDROID_BUTCHER", "PROGRAMMABLE_ANDROID_2_BUTCHER", "PROGRAMMABLE_ANDROID_3_BUTCHER")) {
                    new ButcherAndroidListener(this);
                }
                if (this.isEnabled("ENERGY_REGULATOR", "CARGO_MANAGER")) {
                    new NetworkListener(this);
                }
            }, 0L);
            this.command = new SlimefunCommand(this);
            if (this.config.getBoolean("options.enable-armor-effects")) {
                this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new ArmorTask(), 0L, (long)this.config.getInt("options.armor-update-interval") * 20L);
            }
            this.ticker = new TickerTask();
            this.autoSavingService.start((Plugin)this, this.config.getInt("options.auto-save-delay-in-minutes"));
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    this.ticker.run();
                }
                catch (Exception x) {
                    this.getLogger().log(Level.SEVERE, "An Exception was caught while ticking the Block Tickers Task for Slimefun v" + SlimefunPlugin.getVersion(), x);
                    this.ticker.abortTick();
                }
            }, 100L, (long)this.config.getInt("URID.custom-ticker-delay"));
            this.gitHubService.start((Plugin)this);
            this.getLogger().log(Level.INFO, "Finished!");
            this.thirdPartySupportService.start();
            CSCoreLib.getLib().filterLog("([A-Za-z0-9_]{3,16}) issued server command: /sf elevator (.{0,})");
        } else {
            this.getLogger().log(Level.INFO, "#################### - INFO - ####################");
            this.getLogger().log(Level.INFO, " ");
            this.getLogger().log(Level.INFO, "Slimefun could not be loaded (yet).");
            this.getLogger().log(Level.INFO, "It appears that you have not installed CS-CoreLib.");
            this.getLogger().log(Level.INFO, "Please download and install CS-CoreLib manually:");
            this.getLogger().log(Level.INFO, "https://thebusybiscuit.github.io/builds/TheBusyBiscuit/CS-CoreLib/master/");
            this.getCommand("slimefun").setExecutor((sender, cmd, label, args) -> {
                sender.sendMessage("You have forgotten to install CS-CoreLib! Slimefun is disabled.");
                sender.sendMessage("https://thebusybiscuit.github.io/builds/TheBusyBiscuit/CS-CoreLib/master/");
                return true;
            });
        }
    }

    private boolean isEnabled(String ... itemIds) {
        for (String id : itemIds) {
            SlimefunItem item = SlimefunItem.getByID(id);
            if (item == null || item.isDisabled()) continue;
            return true;
        }
        return false;
    }

    private boolean isVersionUnsupported() {
        String currentVersion = ReflectionUtils.getVersion();
        if (currentVersion.startsWith("v")) {
            for (MinecraftVersion version : MinecraftVersion.values()) {
                if (!version.matches(currentVersion)) continue;
                this.minecraftVersion = version;
                return false;
            }
            this.getLogger().log(Level.SEVERE, "### Slimefun was not installed correctly!");
            this.getLogger().log(Level.SEVERE, "### You are using the wrong version of Minecraft!");
            this.getLogger().log(Level.SEVERE, "###");
            this.getLogger().log(Level.SEVERE, "### You are using Minecraft " + ReflectionUtils.getVersion());
            this.getLogger().log(Level.SEVERE, "### but Slimefun v" + this.getDescription().getVersion() + " requires you to be using");
            this.getLogger().log(Level.SEVERE, "### Minecraft {0}", String.join((CharSequence)" / ", MinecraftVersion.getSupportedVersions()));
            return true;
        }
        this.getLogger().log(Level.WARNING, "We could not determine the version of Minecraft you were using ({0})", currentVersion);
        return false;
    }

    public void onDisable() {
        if (instance == null) {
            return;
        }
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.ticker != null) {
            this.ticker.halt();
            this.ticker.run();
        }
        PlayerProfile.iterator().forEachRemaining(profile -> {
            if (profile.isDirty()) {
                profile.save();
            }
        });
        for (World world : Bukkit.getWorlds()) {
            try {
                BlockStorage storage = BlockStorage.getStorage(world);
                if (storage != null) {
                    storage.save(true);
                    continue;
                }
                this.getLogger().log(Level.SEVERE, "Could not save Slimefun Blocks for World \"" + world.getName() + "\"");
            }
            catch (Exception x) {
                this.getLogger().log(Level.SEVERE, "An Error occured while saving Slimefun-Blocks in World '" + world.getName() + "' for Slimefun " + SlimefunPlugin.getVersion(), x);
            }
        }
        for (UniversalBlockMenu menu : this.registry.getUniversalInventories().values()) {
            menu.save();
        }
        this.backupService.run();
        AContainer.processing = null;
        AContainer.progress = null;
        AGenerator.processing = null;
        AGenerator.progress = null;
        AReactor.processing = null;
        AReactor.progress = null;
        instance = null;
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.closeInventory();
        }
    }

    private void createDirectories() {
        String[] storage = new String[]{"Players", "blocks", "stored-blocks", "stored-inventories", "stored-chunks", "universal-inventories", "waypoints", "block-backups"};
        String[] general = new String[]{"scripts", "generators", "error-reports", "cache/github"};
        for (String file : storage) {
            this.createDir("data-storage/Slimefun/" + file);
        }
        for (String file : general) {
            this.createDir("plugins/Slimefun/" + file);
        }
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static Config getCfg() {
        return SlimefunPlugin.instance.config;
    }

    public static Config getResearchCfg() {
        return SlimefunPlugin.instance.researches;
    }

    public static Config getItemCfg() {
        return SlimefunPlugin.instance.items;
    }

    public static Config getWhitelist() {
        return SlimefunPlugin.instance.whitelist;
    }

    public static GPSNetwork getGPSNetwork() {
        return SlimefunPlugin.instance.gpsNetwork;
    }

    public static TickerTask getTicker() {
        return SlimefunPlugin.instance.ticker;
    }

    public static String getVersion() {
        return instance.getDescription().getVersion();
    }

    public static ProtectionManager getProtectionManager() {
        return SlimefunPlugin.instance.protections;
    }

    public static LocalizationService getLocal() {
        return SlimefunPlugin.instance.local;
    }

    public static MinecraftRecipeService getMinecraftRecipes() {
        return SlimefunPlugin.instance.recipeService;
    }

    public static CustomItemDataService getItemDataService() {
        return SlimefunPlugin.instance.itemDataService;
    }

    public static CustomTextureService getItemTextureService() {
        return SlimefunPlugin.instance.textureService;
    }

    public static PermissionsService getPermissionsService() {
        return SlimefunPlugin.instance.permissionsService;
    }

    public static BlockDataService getBlockDataService() {
        return SlimefunPlugin.instance.blockDataService;
    }

    public static ThirdPartyPluginService getThirdPartySupportService() {
        return SlimefunPlugin.instance.thirdPartySupportService;
    }

    public static UpdaterService getUpdater() {
        return SlimefunPlugin.instance.updaterService;
    }

    public static GitHubService getGitHubService() {
        return SlimefunPlugin.instance.gitHubService;
    }

    public static SlimefunRegistry getRegistry() {
        return SlimefunPlugin.instance.registry;
    }

    public static NetworkManager getNetworkManager() {
        return SlimefunPlugin.instance.networkManager;
    }

    public static AncientAltarListener getAncientAltarListener() {
        return SlimefunPlugin.instance.ancientAltarListener;
    }

    public static GrapplingHookListener getGrapplingHookListener() {
        return SlimefunPlugin.instance.grapplingHookListener;
    }

    public static BackpackListener getBackpackListener() {
        return SlimefunPlugin.instance.backpackListener;
    }

    public static SlimefunBowListener getBowListener() {
        return SlimefunPlugin.instance.bowListener;
    }

    public static Set<Plugin> getInstalledAddons() {
        return Arrays.stream(instance.getServer().getPluginManager().getPlugins()).filter(plugin -> plugin.getDescription().getDepend().contains(instance.getName()) || plugin.getDescription().getSoftDepend().contains(instance.getName())).collect(Collectors.toSet());
    }

    public static SlimefunCommand getCommand() {
        return SlimefunPlugin.instance.command;
    }

    public static MinecraftVersion getMinecraftVersion() {
        return SlimefunPlugin.instance.minecraftVersion;
    }

    @Override
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Override
    public String getBugTrackerURL() {
        return "https://github.com/TheBusyBiscuit/Slimefun4/issues";
    }
}

