/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockBreakHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import me.mrCookieSlime.Slimefun.cscorelib2.recipes.MinecraftRecipe;
import org.bukkit.Effect;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class SmeltersPickaxe
extends SimpleSlimefunItem<BlockBreakHandler>
implements DamageableItem {
    public SmeltersPickaxe(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public BlockBreakHandler getItemHandler() {
        return new BlockBreakHandler(){

            @Override
            public boolean isPrivate() {
                return false;
            }

            @Override
            public boolean onBlockBreak(BlockBreakEvent e, ItemStack item, int fortune, List<ItemStack> drops) {
                if (MaterialCollections.getAllOres().contains(e.getBlock().getType()) && SmeltersPickaxe.this.isItem(item)) {
                    if (BlockStorage.hasBlockInfo(e.getBlock())) {
                        return true;
                    }
                    if (!Slimefun.hasUnlocked(e.getPlayer(), SmeltersPickaxe.this, true)) {
                        return true;
                    }
                    Collection blockDrops = e.getBlock().getDrops(SmeltersPickaxe.this.getItem());
                    for (ItemStack drop : blockDrops) {
                        if (drop == null) continue;
                        ItemStack output = drop;
                        output.setAmount(fortune);
                        Optional<ItemStack> furnaceOutput = SlimefunPlugin.getMinecraftRecipes().getRecipeOutput(MinecraftRecipe.FURNACE, drop);
                        if (furnaceOutput.isPresent()) {
                            e.getBlock().getWorld().playEffect(e.getBlock().getLocation(), Effect.MOBSPAWNER_FLAMES, 1);
                            output.setType(furnaceOutput.get().getType());
                        }
                        drops.add(output);
                    }
                    SmeltersPickaxe.this.damageItem(e.getPlayer(), item);
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public boolean isDamageable() {
        return true;
    }
}

