/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GrapplingHookListener
implements Listener {
    private final Map<UUID, Boolean> jumpState = new HashMap<UUID, Boolean>();
    private final Set<UUID> invulnerable = new HashSet<UUID>();
    private final Map<UUID, Entity[]> temporaryEntities = new HashMap<UUID, Entity[]>();

    public void load(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onArrowHitEntity(EntityDamageByEntityEvent e) {
        if (e.getDamager() instanceof Arrow) {
            this.handleGrapplingHook((Arrow)e.getDamager());
        }
    }

    @EventHandler
    public void onArrowHit(ProjectileHitEvent e) {
        Slimefun.runSync(() -> {
            if (e.getEntity().isValid() && e.getEntity() instanceof Arrow) {
                this.handleGrapplingHook((Arrow)e.getEntity());
            }
        }, 4L);
    }

    @EventHandler
    public void onArrowHit(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && e.getCause() == EntityDamageEvent.DamageCause.FALL && this.invulnerable.contains(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
            this.invulnerable.remove(e.getEntity().getUniqueId());
        }
    }

    private void handleGrapplingHook(Arrow arrow) {
        if (arrow != null && arrow.getShooter() instanceof Player && this.jumpState.containsKey(((Player)arrow.getShooter()).getUniqueId())) {
            Player p = (Player)arrow.getShooter();
            if (p.getGameMode() != GameMode.CREATIVE && this.jumpState.get(p.getUniqueId()).booleanValue()) {
                arrow.getWorld().dropItem(arrow.getLocation(), SlimefunItems.GRAPPLING_HOOK);
            }
            if (p.getLocation().distance(arrow.getLocation()) < 3.0) {
                if (arrow.getLocation().getY() > p.getLocation().getY()) {
                    p.setVelocity(new Vector(0.0, 0.25, 0.0));
                } else {
                    p.setVelocity(arrow.getLocation().toVector().subtract(p.getLocation().toVector()));
                }
                for (Entity n : this.temporaryEntities.get(p.getUniqueId())) {
                    if (!n.isValid()) continue;
                    n.remove();
                }
                Slimefun.runSync(() -> {
                    this.jumpState.remove(p.getUniqueId());
                    this.temporaryEntities.remove(p.getUniqueId());
                }, 20L);
            } else {
                double d;
                Location l = p.getLocation();
                l.setY(l.getY() + 0.5);
                p.teleport(l);
                double g = -0.08;
                double t = d = arrow.getLocation().distance(l);
                double vX = (1.0 + 0.08000000000000002 * t) * (arrow.getLocation().getX() - l.getX()) / t;
                double vY = (1.0 + 0.04 * t) * (arrow.getLocation().getY() - l.getY()) / t - 0.5 * g * t;
                double vZ = (1.0 + 0.08000000000000002 * t) * (arrow.getLocation().getZ() - l.getZ()) / t;
                Vector v = p.getVelocity();
                v.setX(vX);
                v.setY(vY);
                v.setZ(vZ);
                p.setVelocity(v);
                for (Entity n : this.temporaryEntities.get(p.getUniqueId())) {
                    if (!n.isValid()) continue;
                    n.remove();
                }
                Slimefun.runSync(() -> {
                    this.jumpState.remove(p.getUniqueId());
                    this.temporaryEntities.remove(p.getUniqueId());
                }, 20L);
            }
        }
    }

    public boolean isJumping(UUID uuid) {
        return this.jumpState.containsKey(uuid);
    }

    public void addGrapplingHook(UUID uuid, Arrow arrow, Bat b, boolean state, long despawnTicks) {
        this.jumpState.put(uuid, state);
        this.invulnerable.add(uuid);
        this.temporaryEntities.put(uuid, new Entity[]{b, arrow});
        Slimefun.runSync(() -> {
            if (this.jumpState.containsKey(uuid)) {
                SlimefunPlugin.getBowListener().getBows().remove(uuid);
                for (Entity n : this.temporaryEntities.get(uuid)) {
                    if (!n.isValid()) continue;
                    n.remove();
                }
                Slimefun.runSync(() -> {
                    this.invulnerable.remove(uuid);
                    this.jumpState.remove(uuid);
                    this.temporaryEntities.remove(uuid);
                }, 20L);
            }
        }, despawnTicks);
    }
}

