/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.inventory.ItemStack;

public abstract class TreeGrowthAccelerator
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent {
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};

    public TreeGrowthAccelerator(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.createPreset(this, this::constructMenu);
        TreeGrowthAccelerator.registerBlockHandler(this.getID(), (p, b, tool, reason) -> {
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                for (int slot : this.getInputSlots()) {
                    if (inv.getItemInSlot(slot) == null) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                    inv.replaceExistingItem(slot, null);
                }
            }
            return true;
        });
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public abstract int getEnergyConsumption();

    public abstract int getRadius();

    public abstract int getSpeed();

    @Override
    public int[] getInputSlots() {
        return new int[]{10, 11, 12, 13, 14, 15, 16};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    @Override
    public int getCapacity() {
        return 1024;
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                TreeGrowthAccelerator.this.tick(b);
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
    }

    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory(b);
        if (this.work(b, inv) > 0) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunManager.isItemSimilar(inv.getItemInSlot(slot), SlimefunItems.FERTILIZER, false)) continue;
                inv.consumeItem(slot);
                break;
            }
        }
    }

    private int work(Block b, BlockMenu inv) {
        int work = 0;
        for (int x = -this.getRadius(); x <= this.getRadius(); ++x) {
            for (int z = -this.getRadius(); z <= this.getRadius(); ++z) {
                Sapling sapling;
                Block block = b.getRelative(x, 0, z);
                if (!Tag.SAPLINGS.isTagged((Keyed)block.getType()) || (sapling = (Sapling)block.getBlockData()).getStage() >= sapling.getMaximumStage()) continue;
                for (int slot : this.getInputSlots()) {
                    if (!SlimefunManager.isItemSimilar(inv.getItemInSlot(slot), SlimefunItems.FERTILIZER, false)) continue;
                    if (work > this.getSpeed() - 1 || ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                        return work;
                    }
                    ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                    sapling.setStage(sapling.getStage() + 1);
                    block.setBlockData((BlockData)sapling);
                    block.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, block.getLocation().add(0.5, 0.5, 0.5), 4, (double)0.1f, (double)0.1f, (double)0.1f);
                    return ++work;
                }
            }
        }
        return work;
    }
}

