/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.Android;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ScriptAction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullBlock;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class ProgrammableAndroid
extends Android
implements InventoryBlock,
RecipeDisplayItem {
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 18, 24, 25, 26, 27, 33, 35, 36, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private static final int[] border_out = new int[]{10, 11, 12, 13, 14, 19, 23, 28, 32, 37, 38, 39, 40, 41};
    protected final List<BlockFace> directions = Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    protected final Set<MachineFuel> recipes = new HashSet<MachineFuel>();
    protected final String texture;

    public ProgrammableAndroid(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.texture = item.getBase64Texture().orElse(null);
        this.registerDefaultFuelTypes();
        new BlockMenuPreset(this.getID(), "Programmable Android"){

            @Override
            public void init() {
                ProgrammableAndroid.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                boolean open;
                boolean bl = open = BlockStorage.getLocationInfo(b.getLocation(), "owner").equals(p.getUniqueId().toString()) || p.hasPermission("slimefun.android.bypass");
                if (!open) {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "inventory.no-access", true);
                }
                return open;
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
                menu.replaceExistingItem(15, new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTAxYzdiNTcyNjE3ODk3NGIzYjNhMDFiNDJhNTkwZTU0MzY2MDI2ZmQ0MzgwOGYyYTc4NzY0ODg0M2E3ZjVhIn19fQ=="), "&aStart/Continue", new String[0]));
                menu.addMenuClickHandler(15, (p, slot, item, action) -> {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "android.started", true);
                    BlockStorage.addBlockInfo(b, "paused", "false");
                    p.closeInventory();
                    return false;
                });
                menu.replaceExistingItem(17, new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTYxMzlmZDFjNTY1NGU1NmU5ZTRlMmM4YmU3ZWIyYmQ1YjQ5OWQ2MzM2MTY2NjNmZWVlOTliNzQzNTJhZDY0In19fQ=="), "&4Pause", new String[0]));
                menu.addMenuClickHandler(17, (p, slot, item, action) -> {
                    BlockStorage.addBlockInfo(b, "paused", "true");
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "android.stopped", true);
                    return false;
                });
                menu.replaceExistingItem(16, new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDc4ZjJiN2U1ZTc1NjM5ZWE3ZmI3OTZjMzVkMzY0YzRkZjI4YjQyNDNlNjZiNzYyNzdhYWRjZDYyNjEzMzcifX19"), "&bMemory Core", "", "&8\u21e8 &7Click to open the Script Editor"));
                menu.addMenuClickHandler(16, (p, slot, item, action) -> {
                    BlockStorage.addBlockInfo(b, "paused", "true");
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "android.stopped", true);
                    ProgrammableAndroid.this.openScriptEditor(p, b);
                    return false;
                });
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }
        };
        ProgrammableAndroid.registerBlockHandler(this.getID(), new SlimefunBlockHandler(){

            @Override
            public void onPlace(Player p, Block b, SlimefunItem item) {
                BlockStorage.addBlockInfo(b, "owner", p.getUniqueId().toString());
                BlockStorage.addBlockInfo(b, "script", "START-TURN_LEFT-REPEAT");
                BlockStorage.addBlockInfo(b, "index", "0");
                BlockStorage.addBlockInfo(b, "fuel", "0");
                BlockStorage.addBlockInfo(b, "rotation", p.getFacing().getOppositeFace().toString());
                BlockStorage.addBlockInfo(b, "paused", "true");
                b.setType(Material.PLAYER_HEAD);
                Rotatable blockData = (Rotatable)b.getBlockData();
                blockData.setRotation(p.getFacing());
                b.setBlockData((BlockData)blockData);
            }

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                BlockMenu inv;
                boolean allow;
                boolean bl = allow = reason == UnregisterReason.PLAYER_BREAK && (BlockStorage.getLocationInfo(b.getLocation(), "owner").equals(p.getUniqueId().toString()) || p.hasPermission("slimefun.android.bypass"));
                if (allow && (inv = BlockStorage.getInventory(b)) != null) {
                    if (inv.getItemInSlot(43) != null) {
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(43));
                        inv.replaceExistingItem(43, null);
                    }
                    for (int slot : ProgrammableAndroid.this.getOutputSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                }
                return allow;
            }
        });
    }

    private void registerDefaultFuelTypes() {
        if (this.getTier() == 1) {
            this.registerFuel(new MachineFuel(800, new ItemStack(Material.COAL_BLOCK)));
            this.registerFuel(new MachineFuel(45, new ItemStack(Material.BLAZE_ROD)));
            for (Material mat : Tag.ITEMS_COALS.getValues()) {
                this.registerFuel(new MachineFuel(8, new ItemStack(mat)));
            }
            for (Material mat : Tag.LOGS.getValues()) {
                this.registerFuel(new MachineFuel(2, new ItemStack(mat)));
            }
            for (Material mat : Tag.PLANKS.getValues()) {
                this.registerFuel(new MachineFuel(1, new ItemStack(mat)));
            }
        } else if (this.getTier() == 2) {
            this.registerFuel(new MachineFuel(100, new ItemStack(Material.LAVA_BUCKET)));
            this.registerFuel(new MachineFuel(200, SlimefunItems.BUCKET_OF_OIL));
            this.registerFuel(new MachineFuel(500, SlimefunItems.BUCKET_OF_FUEL));
        } else {
            this.registerFuel(new MachineFuel(2500, SlimefunItems.URANIUM));
            this.registerFuel(new MachineFuel(1200, SlimefunItems.NEPTUNIUM));
            this.registerFuel(new MachineFuel(3000, SlimefunItems.BOOSTED_URANIUM));
        }
    }

    @Override
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.generator";
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MachineFuel fuel : this.recipes) {
            ItemStack item = fuel.getInput().clone();
            ItemMeta im = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColors.color("&8\u21e8 &7Lasts " + NumberUtils.getTimeLeft(fuel.getTicks() / 2)));
            im.setLore(lore);
            item.setItemMeta(im);
            list.add(item);
        }
        return list;
    }

    @Override
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{20, 21, 22, 29, 30, 31};
    }

    @Override
    public abstract AndroidType getAndroidType();

    public abstract float getFuelEfficiency();

    public abstract int getTier();

    @Override
    protected void tick(Block b) {
        if (b.getType() != Material.PLAYER_HEAD) {
            return;
        }
        if (BlockStorage.getLocationInfo(b.getLocation(), "paused").equals("false")) {
            BlockMenu menu = BlockStorage.getInventory(b);
            float fuel = Float.parseFloat(BlockStorage.getLocationInfo(b.getLocation(), "fuel"));
            if ((double)fuel < 0.001) {
                ItemStack item = menu.getItemInSlot(43);
                if (item != null) {
                    for (MachineFuel recipe : this.recipes) {
                        if (!SlimefunManager.isItemSimilar(item, recipe.getInput(), true)) continue;
                        menu.consumeItem(43);
                        if (this.getTier() == 2) {
                            menu.pushItem(new ItemStack(Material.BUCKET), this.getOutputSlots());
                        }
                        BlockStorage.addBlockInfo(b, "fuel", String.valueOf((int)((float)recipe.getTicks() * this.getFuelEfficiency())));
                        break;
                    }
                }
            } else {
                String[] script = PatternUtils.DASH.split(BlockStorage.getLocationInfo(b.getLocation(), "script"));
                int index = Integer.parseInt(BlockStorage.getLocationInfo(b.getLocation(), "index")) + 1;
                if (index >= script.length) {
                    index = 0;
                }
                boolean refresh = true;
                BlockStorage.addBlockInfo(b, "fuel", String.valueOf(fuel - 1.0f));
                ScriptAction part = ScriptAction.valueOf(script[index]);
                if (this.getAndroidType().isType(part.getRequiredType())) {
                    BlockFace face = BlockFace.valueOf((String)BlockStorage.getLocationInfo(b.getLocation(), "rotation"));
                    double damage = this.getTier() < 2 ? 20.0 : 4.0 * (double)this.getTier();
                    block0 : switch (part) {
                        case GO_DOWN: {
                            this.move(b, face, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case GO_FORWARD: {
                            this.move(b, face, b.getRelative(face));
                            break;
                        }
                        case GO_UP: {
                            this.move(b, face, b.getRelative(BlockFace.UP));
                            break;
                        }
                        case REPEAT: {
                            BlockStorage.addBlockInfo(b, "index", String.valueOf(0));
                            break;
                        }
                        case TURN_LEFT: {
                            int indexLeft = this.directions.indexOf(BlockFace.valueOf((String)BlockStorage.getLocationInfo(b.getLocation(), "rotation"))) - 1;
                            if (indexLeft < 0) {
                                indexLeft = this.directions.size() - 1;
                            }
                            Rotatable rotatableLeft = (Rotatable)b.getBlockData();
                            rotatableLeft.setRotation(this.directions.get(indexLeft));
                            b.setBlockData((BlockData)rotatableLeft);
                            BlockStorage.addBlockInfo(b, "rotation", this.directions.get(indexLeft).toString());
                            break;
                        }
                        case TURN_RIGHT: {
                            int indexRight = this.directions.indexOf(BlockFace.valueOf((String)BlockStorage.getLocationInfo(b.getLocation(), "rotation"))) + 1;
                            if (indexRight == this.directions.size()) {
                                indexRight = 0;
                            }
                            Rotatable rotatableRight = (Rotatable)b.getBlockData();
                            rotatableRight.setRotation(this.directions.get(indexRight));
                            b.setBlockData((BlockData)rotatableRight);
                            BlockStorage.addBlockInfo(b, "rotation", this.directions.get(indexRight).toString());
                            break;
                        }
                        case DIG_FORWARD: {
                            this.mine(b, menu, b.getRelative(face));
                            break;
                        }
                        case DIG_UP: {
                            this.mine(b, menu, b.getRelative(BlockFace.UP));
                            break;
                        }
                        case DIG_DOWN: {
                            this.mine(b, menu, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case CATCH_FISH: {
                            this.fish(b, menu);
                            break;
                        }
                        case MOVE_AND_DIG_FORWARD: {
                            this.movedig(b, menu, face, b.getRelative(face));
                            break;
                        }
                        case MOVE_AND_DIG_UP: {
                            this.movedig(b, menu, face, b.getRelative(BlockFace.UP));
                            break;
                        }
                        case MOVE_AND_DIG_DOWN: {
                            this.movedig(b, menu, face, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case INTERFACE_ITEMS: {
                            if (!BlockStorage.check(b.getRelative(face), "ANDROID_INTERFACE_ITEMS") || !(b.getRelative(face).getState() instanceof Dispenser)) break;
                            Dispenser d = (Dispenser)b.getRelative(face).getState();
                            for (int slot : this.getOutputSlots()) {
                                ItemStack stack = menu.getItemInSlot(slot);
                                if (stack == null) continue;
                                Optional optional = d.getInventory().addItem(new ItemStack[]{stack}).values().stream().findFirst();
                                if (optional.isPresent()) {
                                    menu.replaceExistingItem(slot, (ItemStack)optional.get());
                                    continue;
                                }
                                menu.replaceExistingItem(slot, null);
                            }
                            break;
                        }
                        case INTERFACE_FUEL: {
                            if (!BlockStorage.check(b.getRelative(face), "ANDROID_INTERFACE_FUEL") || !(b.getRelative(face).getState() instanceof Dispenser)) break;
                            Dispenser d = (Dispenser)b.getRelative(face).getState();
                            for (int slot = 0; slot < 9; ++slot) {
                                ItemStack item = d.getInventory().getItem(slot);
                                if (item == null) continue;
                                if (menu.getItemInSlot(43) == null) {
                                    menu.replaceExistingItem(43, item);
                                    d.getInventory().setItem(slot, null);
                                    break block0;
                                }
                                if (!SlimefunManager.isItemSimilar(item, menu.getItemInSlot(43), true)) continue;
                                int rest = item.getType().getMaxStackSize() - menu.getItemInSlot(43).getAmount();
                                if (rest <= 0) break block0;
                                int amt = item.getAmount() > rest ? rest : item.getAmount();
                                menu.replaceExistingItem(43, new CustomItem(item, menu.getItemInSlot(43).getAmount() + amt));
                                ItemUtils.consumeItem(item, amt, false);
                                break block0;
                            }
                            break;
                        }
                        case FARM_FORWARD: {
                            this.farm(menu, b.getRelative(face));
                            break;
                        }
                        case FARM_DOWN: {
                            this.farm(menu, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case FARM_EXOTIC_FORWARD: {
                            this.exoticFarm(menu, b.getRelative(face));
                            break;
                        }
                        case FARM_EXOTIC_DOWN: {
                            this.exoticFarm(menu, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case CHOP_TREE: {
                            refresh = this.chopTree(b, menu, face);
                            break;
                        }
                        case ATTACK_MOBS_ANIMALS: {
                            this.killEntities(b, damage, e -> true);
                            break;
                        }
                        case ATTACK_MOBS: {
                            this.killEntities(b, damage, e -> e instanceof Monster);
                            break;
                        }
                        case ATTACK_ANIMALS: {
                            this.killEntities(b, damage, e -> e instanceof Animals);
                            break;
                        }
                        case ATTACK_ANIMALS_ADULT: {
                            this.killEntities(b, damage, e -> e instanceof Animals && e instanceof Ageable && ((Ageable)e).isAdult());
                            break;
                        }
                    }
                }
                if (refresh) {
                    BlockStorage.addBlockInfo(b, "index", String.valueOf(index));
                }
            }
        }
    }

    protected void move(Block b, BlockFace face, Block block) {
        if (block.getY() > 0 && block.getY() < block.getWorld().getMaxHeight() && (block.getType() == Material.AIR || block.getType() == Material.CAVE_AIR)) {
            block.setType(Material.PLAYER_HEAD);
            Rotatable blockData = (Rotatable)block.getBlockData();
            blockData.setRotation(face.getOppositeFace());
            block.setBlockData((BlockData)blockData);
            SkullBlock.setFromBase64(block, this.texture);
            b.setType(Material.AIR);
            BlockStorage.moveBlockInfo(b.getLocation(), block.getLocation());
        }
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_out) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
        ItemStack generator = SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTM0M2NlNThkYTU0Yzc5OTI0YTJjOTMzMWNmYzQxN2ZlOGNjYmJlYTliZTQ1YTdhYzg1ODYwYTZjNzMwIn19fQ==");
        if (this.getTier() == 1) {
            preset.addItem(34, new CustomItem(generator, "&8\u21e9 &cFuel Input &8\u21e9", "", "&rThis Android runs on solid Fuel", "&re.g. Coal, Wood, etc..."), ChestMenuUtils.getEmptyClickHandler());
        } else if (this.getTier() == 2) {
            preset.addItem(34, new CustomItem(generator, "&8\u21e9 &cFuel Input &8\u21e9", "", "&rThis Android runs on liquid Fuel", "&re.g. Lava, Oil, Fuel, etc..."), ChestMenuUtils.getEmptyClickHandler());
        } else {
            preset.addItem(34, new CustomItem(generator, "&8\u21e9 &cFuel Input &8\u21e9", "", "&rThis Android runs on radioactive Fuel", "&re.g. Uranium, Neptunium or Boosted Uranium"), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public void addItems(Block b, ItemStack ... items) {
        BlockMenu inv = BlockStorage.getInventory(b);
        for (ItemStack item : items) {
            inv.pushItem(item, this.getOutputSlots());
        }
    }

    public void registerFuel(MachineFuel fuel) {
        this.recipes.add(fuel);
    }
}

