/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide;

import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideLayout;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class SlimefunGuide {
    private SlimefunGuide() {
    }

    public static ItemStack getItem(SlimefunGuideLayout design) {
        ItemStack item = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta meta = item.getItemMeta();
        LinkedList<String> lore = new LinkedList<String>();
        lore.addAll(Arrays.asList("", ChatColors.color("&eRight Click &8\u21e8 &7Browse Items"), ChatColors.color("&eShift + Right Click &8\u21e8 &7Open Settings / Credits")));
        switch (design) {
            case BOOK: {
                meta.setDisplayName(ChatColors.color("&aSlimefun Guide &7(Book GUI)"));
                break;
            }
            case CHEAT_SHEET: {
                meta.setDisplayName(ChatColors.color("&cSlimefun Guide &4(Cheat Sheet)"));
                lore.add(0, ChatColors.color("&4&lOnly openable by Admins"));
                lore.add(0, "");
                break;
            }
            case CHEST: {
                meta.setDisplayName(ChatColors.color("&aSlimefun Guide &7(Chest GUI)"));
                break;
            }
            default: {
                return null;
            }
        }
        meta.setLore(lore);
        SlimefunPlugin.getItemTextureService().setTexture(meta, "SLIMEFUN_GUIDE");
        item.setItemMeta(meta);
        return item;
    }

    public static void openCheatMenu(Player p) {
        SlimefunGuide.openMainMenuAsync(p, false, SlimefunGuideLayout.CHEAT_SHEET, 1);
    }

    public static void openGuide(Player p, ItemStack guide) {
        if (SlimefunManager.isItemSimilar(guide, SlimefunGuide.getItem(SlimefunGuideLayout.CHEST), true)) {
            SlimefunGuide.openGuide(p, SlimefunGuideLayout.CHEST);
        } else if (SlimefunManager.isItemSimilar(guide, SlimefunGuide.getItem(SlimefunGuideLayout.BOOK), true)) {
            SlimefunGuide.openGuide(p, SlimefunGuideLayout.BOOK);
        } else if (SlimefunManager.isItemSimilar(guide, SlimefunGuide.getItem(SlimefunGuideLayout.CHEAT_SHEET), true)) {
            SlimefunGuide.openGuide(p, SlimefunGuideLayout.CHEAT_SHEET);
        } else {
            SlimefunGuide.openGuide(p, SlimefunGuideLayout.CHEST);
        }
    }

    public static void openGuide(Player p, SlimefunGuideLayout layout) {
        if (!SlimefunPlugin.getWhitelist().getBoolean(p.getWorld().getName() + ".enabled")) {
            return;
        }
        if (!SlimefunPlugin.getWhitelist().getBoolean(p.getWorld().getName() + ".enabled-items.SLIMEFUN_GUIDE")) {
            return;
        }
        SlimefunGuideImplementation guide = SlimefunPlugin.getRegistry().getGuideLayout(layout);
        Object last = null;
        Optional<PlayerProfile> profile = PlayerProfile.find((OfflinePlayer)p);
        if (profile.isPresent()) {
            last = guide.getLastEntry(profile.get(), false);
            guide.openEntry(profile.get(), last, true);
        } else {
            SlimefunGuide.openMainMenuAsync(p, true, layout, 1);
        }
    }

    private static void openMainMenuAsync(Player player, boolean survival, SlimefunGuideLayout layout, int selectedPage) {
        if (!PlayerProfile.get((OfflinePlayer)player, profile -> Slimefun.runSync(() -> SlimefunGuide.openMainMenu(profile, layout, survival, selectedPage)))) {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)player, "messages.opening-guide");
        }
    }

    public static void openMainMenu(PlayerProfile profile, SlimefunGuideLayout layout, boolean survival, int selectedPage) {
        SlimefunPlugin.getRegistry().getGuideLayout(layout).openMainMenu(profile, survival, selectedPage);
    }

    public static void openCategory(PlayerProfile profile, Category category, SlimefunGuideLayout layout, boolean survival, int selectedPage) {
        if (category == null) {
            return;
        }
        SlimefunPlugin.getRegistry().getGuideLayout(layout).openCategory(profile, category, survival, selectedPage);
    }

    public static void openSearch(PlayerProfile profile, String input, boolean survival, boolean addToHistory) {
        SlimefunPlugin.getRegistry().getGuideLayout(SlimefunGuideLayout.CHEST).openSearch(profile, input, survival, addToHistory);
    }

    public static void displayItem(PlayerProfile profile, ItemStack item, boolean addToHistory) {
        SlimefunPlugin.getRegistry().getGuideLayout(SlimefunGuideLayout.CHEST).displayItem(profile, item, addToHistory);
    }

    public static void displayItem(PlayerProfile profile, SlimefunItem item, boolean addToHistory) {
        SlimefunPlugin.getRegistry().getGuideLayout(SlimefunGuideLayout.CHEST).displayItem(profile, item, addToHistory);
    }

    public static boolean isGuideItem(ItemStack item) {
        return SlimefunManager.isItemSimilar(item, SlimefunGuide.getItem(SlimefunGuideLayout.CHEST), true) || SlimefunManager.isItemSimilar(item, SlimefunGuide.getItem(SlimefunGuideLayout.BOOK), true) || SlimefunManager.isItemSimilar(item, SlimefunGuide.getItem(SlimefunGuideLayout.CHEAT_SHEET), true);
    }
}

