/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.exceptions.IdConflictException;
import io.github.thebusybiscuit.slimefun4.api.exceptions.UnregisteredItemException;
import io.github.thebusybiscuit.slimefun4.api.items.Placeable;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.core.attributes.WitherProof;
import io.github.thebusybiscuit.slimefun4.implementation.items.VanillaItem;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.SlimefunBackpack;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ChargableItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ItemState;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Objects.handlers.GeneratorTicker;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.OptionalMap;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SlimefunItem
implements Placeable {
    private ItemState state = ItemState.UNREGISTERED;
    protected String id;
    protected SlimefunAddon addon;
    protected ItemStack item;
    protected Category category;
    protected ItemStack[] recipe;
    protected RecipeType recipeType;
    protected ItemStack recipeOutput;
    protected Research research;
    protected boolean enchantable = true;
    protected boolean disenchantable = true;
    protected boolean hidden = false;
    protected boolean useableInWorkbench = false;
    private String[] keys;
    private Object[] values;
    private String wiki = null;
    private final OptionalMap<Class<? extends ItemHandler>, ItemHandler> itemhandlers = new OptionalMap(HashMap::new);
    private boolean ticking = false;
    private BlockTicker blockTicker;
    private GeneratorTicker energyTicker;

    public SlimefunItem(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(category, item, recipeType, recipe, null);
    }

    public SlimefunItem(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        this(category, item, recipeType, recipe, recipeOutput, null, null);
    }

    public SlimefunItem(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, String[] keys, Object[] values) {
        this(category, item, recipeType, recipe, null, keys, values);
    }

    public SlimefunItem(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput, String[] keys, Object[] values) {
        Validate.notNull((Object)category, (String)"'category' is not allowed to be null!");
        Validate.notNull((Object)((Object)item), (String)"'item' is not allowed to be null!");
        this.category = category;
        this.item = item;
        this.id = item.getItemID();
        this.recipeType = recipeType;
        this.recipe = recipe;
        this.recipeOutput = recipeOutput;
        this.keys = keys;
        this.values = values;
    }

    protected SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe) {
        this.category = category;
        this.item = item;
        this.id = id;
        this.recipeType = recipeType;
        this.recipe = recipe;
    }

    public String getID() {
        return this.id;
    }

    public ItemState getState() {
        return this.state;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Category getCategory() {
        return this.category;
    }

    public ItemStack[] getRecipe() {
        return this.recipe;
    }

    public RecipeType getRecipeType() {
        return this.recipeType;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public Research getResearch() {
        return this.research;
    }

    public boolean isEnchantable() {
        return this.enchantable;
    }

    public boolean isDisenchantable() {
        return this.disenchantable;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isAddonItem() {
        return !(this.addon instanceof SlimefunPlugin);
    }

    public SlimefunAddon getAddon() {
        return this.addon;
    }

    public BlockTicker getBlockTicker() {
        return this.blockTicker;
    }

    public GeneratorTicker getEnergyTicker() {
        return this.energyTicker;
    }

    public boolean isDisabled() {
        if (this.state == ItemState.UNREGISTERED) {
            this.error("isDisabled() cannot be called before registering the item", new UnregisteredItemException(this));
            return false;
        }
        return this.state != ItemState.ENABLED;
    }

    public void register(SlimefunAddon addon) {
        this.addon = addon;
        try {
            this.preRegister();
            SlimefunItem conflicting = SlimefunItem.getByID(this.id);
            if (conflicting != null) {
                throw new IdConflictException(this, conflicting);
            }
            if (this.recipe == null || this.recipe.length < 9) {
                this.recipe = new ItemStack[]{null, null, null, null, null, null, null, null, null};
            }
            SlimefunPlugin.getRegistry().getAllSlimefunItems().add(this);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".enabled", true);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".can-be-used-in-workbenches", this.useableInWorkbench);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".hide-in-guide", this.hidden);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".allow-enchanting", this.enchantable);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".allow-disenchanting", this.disenchantable);
            if (this.keys != null && this.values != null) {
                for (int i = 0; i < this.keys.length; ++i) {
                    SlimefunPlugin.getItemCfg().setDefaultValue(this.id + '.' + this.keys[i], this.values[i]);
                }
            }
            for (World world : Bukkit.getWorlds()) {
                SlimefunPlugin.getWhitelist().setDefaultValue(world.getName() + ".enabled", true);
                SlimefunPlugin.getWhitelist().setDefaultValue(world.getName() + ".enabled-items." + this.id, true);
            }
            if (this.ticking && !SlimefunPlugin.getCfg().getBoolean("URID.enable-tickers")) {
                this.state = ItemState.DISABLED;
                return;
            }
            if (this instanceof Radioactive) {
                SlimefunPlugin.getRegistry().getRadioactiveItems().add(this);
            }
            if (this instanceof WitherProof) {
                SlimefunPlugin.getRegistry().getWitherProofBlocks().add(this.id);
            }
            if (this instanceof EnergyNetComponent && !SlimefunPlugin.getRegistry().getEnergyCapacities().containsKey(this.getID())) {
                this.registerEnergyNetComponent((EnergyNetComponent)((Object)this));
            }
            if (SlimefunPlugin.getItemCfg().getBoolean(this.id + ".enabled")) {
                if (!SlimefunPlugin.getRegistry().getEnabledCategories().contains(this.category)) {
                    this.category.register();
                }
                this.state = ItemState.ENABLED;
                this.useableInWorkbench = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".can-be-used-in-workbenches");
                this.hidden = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".hide-in-guide");
                this.enchantable = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".allow-enchanting");
                this.disenchantable = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".allow-disenchanting");
                SlimefunPlugin.getRegistry().getEnabledSlimefunItems().add(this);
                SlimefunPlugin.getRegistry().getSlimefunItemIds().put(this.id, this);
                for (ItemHandler handler : this.itemhandlers.values()) {
                    if (handler.isPrivate()) continue;
                    Set<ItemHandler> handlerset = SlimefunItem.getPublicItemHandlers(handler.getIdentifier());
                    handlerset.add(handler);
                }
            } else {
                this.state = this instanceof VanillaItem ? ItemState.VANILLA : ItemState.DISABLED;
            }
            this.postRegister();
        }
        catch (Exception x) {
            this.error("Registering " + this.toString() + " has failed", x);
        }
    }

    private void registerEnergyNetComponent(EnergyNetComponent component) {
        switch (component.getEnergyComponentType()) {
            case CONSUMER: {
                SlimefunPlugin.getRegistry().getEnergyConsumers().add(this.id);
                break;
            }
            case CAPACITOR: {
                SlimefunPlugin.getRegistry().getEnergyCapacitors().add(this.id);
                break;
            }
            case GENERATOR: {
                SlimefunPlugin.getRegistry().getEnergyGenerators().add(this.id);
                break;
            }
        }
        int capacity = component.getCapacity();
        if (capacity > 0) {
            SlimefunPlugin.getRegistry().getEnergyCapacities().put(this.id, capacity);
        }
    }

    public void bindToResearch(Research r) {
        if (r != null) {
            r.getAffectedItems().add(this);
        }
        this.research = r;
    }

    public void setRecipe(ItemStack[] recipe) {
        this.recipe = recipe;
    }

    public void setRecipeType(RecipeType type) {
        this.recipeType = type;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public void setRecipeOutput(ItemStack output) {
        this.recipeOutput = output;
    }

    public boolean isUseableInWorkbench() {
        return this.useableInWorkbench;
    }

    public SlimefunItem setUseableInWorkbench(boolean useable) {
        this.useableInWorkbench = useable;
        return this;
    }

    public boolean isItem(ItemStack item) {
        Optional<String> itemID;
        if (item == null) {
            return false;
        }
        if (item.hasItemMeta() && (itemID = SlimefunPlugin.getItemDataService().getItemData(item)).isPresent()) {
            return this.getID().equals(itemID.get());
        }
        if (this instanceof ChargableItem && SlimefunManager.isItemSimilar(item, this.item, false)) {
            return true;
        }
        if (this instanceof SlimefunBackpack && SlimefunManager.isItemSimilar(item, this.item, false)) {
            return true;
        }
        return SlimefunManager.isItemSimilar(item, this.item, true);
    }

    public void load() {
        try {
            if (!this.hidden) {
                this.category.add(this);
            }
            ItemStack output = this.recipeOutput == null ? this.item.clone() : this.recipeOutput.clone();
            this.recipeType.register(this.recipe, output);
        }
        catch (Exception x) {
            this.error("Failed to properly load the Item \"" + this.id + "\"", x);
        }
    }

    public void addItemHandler(ItemHandler ... handlers) {
        for (ItemHandler handler : handlers) {
            this.itemhandlers.put(handler.getIdentifier(), handler);
            if (handler instanceof BlockTicker) {
                this.ticking = true;
                SlimefunPlugin.getRegistry().getTickerBlocks().add(this.getID());
                this.blockTicker = (BlockTicker)handler;
                continue;
            }
            if (!(handler instanceof GeneratorTicker)) continue;
            this.energyTicker = (GeneratorTicker)handler;
        }
    }

    public void preRegister() {
    }

    public void postRegister() {
    }

    protected void setItem(ItemStack stack) {
        this.item = stack;
    }

    public void addOficialWikipage(String page) {
        this.wiki = "https://github.com/TheBusyBiscuit/Slimefun4/wiki/" + page;
    }

    public boolean hasWikipage() {
        return this.wiki != null;
    }

    public String getWikipage() {
        return this.wiki;
    }

    public final String getItemName() {
        return ItemUtils.getItemName(this.item);
    }

    public Collection<ItemHandler> getHandlers() {
        return this.itemhandlers.values();
    }

    public <T extends ItemHandler> boolean callItemHandler(Class<T> c, Consumer<T> callable) {
        Optional<ItemHandler> handler = this.itemhandlers.get(c);
        if (handler.isPresent()) {
            try {
                callable.accept(c.cast(handler.get()));
            }
            catch (Throwable x) {
                this.error("Could not pass \"" + c.getSimpleName() + "\" for " + this.toString(), x);
            }
            return true;
        }
        return false;
    }

    public boolean isTicking() {
        return this.ticking;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - '" + this.id + "' (" + this.addon.getName() + ')';
    }

    @Override
    public Collection<ItemStack> getDrops() {
        return Arrays.asList(this.item.clone());
    }

    @Override
    public Collection<ItemStack> getDrops(Player p) {
        return this.getDrops();
    }

    public void info(String message) {
        this.addon.getLogger().log(Level.INFO, message);
    }

    public void warn(String message) {
        this.addon.getLogger().log(Level.WARNING, message);
    }

    public void error(String message, Throwable throwable) {
        this.addon.getLogger().log(Level.SEVERE, "Item \"{0}\" from {1} v{2} has caused an Error!", new Object[]{this.id, this.addon.getName(), this.addon.getPluginVersion()});
        if (this.addon.getBugTrackerURL() != null) {
            this.addon.getLogger().log(Level.SEVERE, "You can report it here: {0}", this.addon.getBugTrackerURL());
        }
        this.addon.getLogger().log(Level.SEVERE, message, throwable);
    }

    public static SlimefunItem getByID(String id) {
        return SlimefunPlugin.getRegistry().getSlimefunItemIds().get(id);
    }

    public static SlimefunItem getByItem(ItemStack item) {
        Optional<String> itemID;
        if (item == null) {
            return null;
        }
        if (item instanceof SlimefunItemStack) {
            return SlimefunItem.getByID(((SlimefunItemStack)item).getItemID());
        }
        if (item.hasItemMeta() && (itemID = SlimefunPlugin.getItemDataService().getItemData(item)).isPresent()) {
            return SlimefunItem.getByID(itemID.get());
        }
        for (SlimefunItem sfi : SlimefunPlugin.getRegistry().getAllSlimefunItems()) {
            if (!sfi.isItem(item)) continue;
            SlimefunPlugin.getItemDataService().setItemData(item, sfi.getID());
            return sfi;
        }
        if (SlimefunManager.isItemSimilar(item, SlimefunItems.BROKEN_SPAWNER, false)) {
            return SlimefunItem.getByID("BROKEN_SPAWNER");
        }
        if (SlimefunManager.isItemSimilar(item, SlimefunItems.REPAIRED_SPAWNER, false)) {
            return SlimefunItem.getByID("REINFORCED_SPAWNER");
        }
        return null;
    }

    public static ItemStack getItem(String id) {
        SlimefunItem item = SlimefunItem.getByID(id);
        return item != null ? item.getItem() : null;
    }

    public static Set<ItemHandler> getPublicItemHandlers(Class<? extends ItemHandler> identifier) {
        return SlimefunPlugin.getRegistry().getPublicItemHandlers().computeIfAbsent(identifier, c -> new HashSet());
    }

    public static void registerBlockHandler(String id, SlimefunBlockHandler handler) {
        SlimefunPlugin.getRegistry().getBlockHandlers().put(id, handler);
    }
}

