/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import java.util.Arrays;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PermissionsService {
    private final SlimefunPlugin plugin;
    private Config config;

    public PermissionsService(SlimefunPlugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        this.config = new Config((Plugin)this.plugin, "permissions.yml");
        this.config.getConfiguration().options().header("This file is used to assign permission nodes to items from Slimefun or any of its addons.\nTo assign an item a certain permission node you simply have to set the 'permission' attribute\nto your desired permission node. You can also customize the text that is displayed when a Player does not have that permission.");
        this.config.getConfiguration().options().copyHeader(true);
    }

    public void register(Iterable<SlimefunItem> items) {
        for (SlimefunItem item : items) {
            if (item == null || item.getID() == null || this.migrate(item)) continue;
            this.config.setDefaultValue(item.getID() + ".permission", "none");
            this.config.setDefaultValue(item.getID() + ".lore", new String[]{"&rYou do not have the permission", "&rto access this item."});
        }
        this.config.save();
    }

    private boolean migrate(SlimefunItem item) {
        String permission = SlimefunPlugin.getItemCfg().getString(item.getID() + ".required-permission");
        if (permission != null) {
            this.config.setDefaultValue(item.getID() + ".permission", permission.length() == 0 ? "none" : permission);
            this.config.setDefaultValue(item.getID() + ".lore", SlimefunPlugin.getItemCfg().getString(item.getID() + ".no-permission-tooltip"));
            SlimefunPlugin.getItemCfg().setValue(item.getID() + ".required-permission", null);
            SlimefunPlugin.getItemCfg().setValue(item.getID() + ".no-permission-tooltip", null);
            return true;
        }
        return false;
    }

    public boolean hasPermission(Player p, SlimefunItem item) {
        if (item == null) {
            return true;
        }
        String permission = this.config.getString(item.getID() + ".permission");
        return permission == null || permission.equals("none") || p.hasPermission(permission);
    }

    public List<String> getLore(SlimefunItem item) {
        List<String> lore = this.config.getStringList(item.getID() + ".lore");
        return lore == null ? Arrays.asList("LORE NOT FOUND") : lore;
    }
}

