/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem;

import io.github.thebusybiscuit.slimefun4.core.MultiBlock;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class SlimefunMachine
extends SlimefunItem
implements RecipeDisplayItem {
    protected final List<ItemStack[]> recipes = new ArrayList<ItemStack[]>();
    protected final List<ItemStack> shownRecipes = new ArrayList<ItemStack>();
    protected final MultiBlock multiblock;

    public SlimefunMachine(Category category, SlimefunItemStack item, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger) {
        super(category, item, RecipeType.MULTIBLOCK, recipe);
        this.shownRecipes.addAll(Arrays.asList(machineRecipes));
        this.multiblock = new MultiBlock(this, SlimefunMachine.convertItemStacksToMaterial(recipe), trigger);
    }

    @Deprecated
    public SlimefunMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger) {
        super(category, item, id, RecipeType.MULTIBLOCK, recipe);
        this.shownRecipes.addAll(Arrays.asList(machineRecipes));
        this.multiblock = new MultiBlock(this, SlimefunMachine.convertItemStacksToMaterial(recipe), trigger);
    }

    public SlimefunMachine(Category category, SlimefunItemStack item, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger, String[] keys, Object[] values) {
        super(category, item, RecipeType.MULTIBLOCK, recipe, keys, values);
        this.shownRecipes.addAll(Arrays.asList(machineRecipes));
        this.multiblock = new MultiBlock(this, SlimefunMachine.convertItemStacksToMaterial(recipe), trigger);
    }

    public List<ItemStack[]> getRecipes() {
        return this.recipes;
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.shownRecipes;
    }

    public void addRecipe(ItemStack[] input, ItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Recipes must have an Output!");
        }
        this.recipes.add(input);
        this.recipes.add(new ItemStack[]{output});
    }

    @Override
    public void postRegister() {
        this.multiblock.register();
    }

    @Override
    public void install() {
        for (ItemStack recipeItem : this.shownRecipes) {
            SlimefunItem item = SlimefunItem.getByItem(recipeItem);
            if (item != null && item.isDisabled()) continue;
            this.recipes.add(new ItemStack[]{recipeItem});
        }
    }

    private static Material[] convertItemStacksToMaterial(ItemStack[] items) {
        ArrayList<Material> mats = new ArrayList<Material>();
        for (ItemStack item : items) {
            if (item == null) {
                mats.add(null);
                continue;
            }
            if (item.getType() == Material.FLINT_AND_STEEL) {
                mats.add(Material.FIRE);
                continue;
            }
            mats.add(item.getType());
        }
        return mats.toArray(new Material[0]);
    }

    @Override
    protected boolean areItemHandlersPrivate() {
        return true;
    }

    public Iterator<ItemStack[]> recipeIterator() {
        return this.recipes.iterator();
    }

    public MultiBlock getMultiBlock() {
        return this.multiblock;
    }
}

