/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.items.food.Cooler;
import io.github.thebusybiscuit.slimefun4.implementation.items.food.Juice;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.SlimefunBackpack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BackpackListener
implements Listener {
    private Map<UUID, ItemStack> backpacks = new HashMap<UUID, ItemStack>();

    public BackpackListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (this.backpacks.containsKey(e.getPlayer().getUniqueId())) {
            ((Player)e.getPlayer()).playSound(e.getPlayer().getLocation(), Sound.ENTITY_HORSE_ARMOR, 1.0f, 1.0f);
            PlayerProfile.getBackpack(this.backpacks.get(e.getPlayer().getUniqueId())).markDirty();
            this.backpacks.remove(e.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent e) {
        ItemStack item;
        SlimefunItem sfItem;
        if (this.backpacks.containsKey(e.getPlayer().getUniqueId()) && (sfItem = SlimefunItem.getByItem(item = e.getItemDrop().getItemStack())) instanceof SlimefunBackpack) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        ItemStack item = this.backpacks.get(e.getWhoClicked().getUniqueId());
        if (item != null) {
            if (e.getClick() == ClickType.NUMBER_KEY) {
                ItemStack hotbarItem;
                if (e.getClickedInventory().getType() != InventoryType.PLAYER && (hotbarItem = e.getWhoClicked().getInventory().getItem(e.getHotbarButton())) != null && (hotbarItem.getType().toString().contains("SHULKER_BOX") || SlimefunItem.getByItem(hotbarItem) instanceof SlimefunBackpack)) {
                    e.setCancelled(true);
                }
            } else if (!this.isItemAllowed(e.getCurrentItem())) {
                e.setCancelled(true);
            }
        }
    }

    private boolean isItemAllowed(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return true;
        }
        if (item.getType().toString().contains("SHULKER_BOX")) {
            return false;
        }
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem instanceof SlimefunBackpack) {
            return false;
        }
        if (sfItem instanceof Cooler) {
            return sfItem instanceof Juice;
        }
        return true;
    }

    public void openBackpack(Player p, ItemStack item, SlimefunBackpack backpack) {
        if (item.getAmount() == 1) {
            if (Slimefun.hasUnlocked(p, backpack, true) && !PlayerProfile.get((OfflinePlayer)p, profile -> this.openBackpack(item, (PlayerProfile)profile, backpack.getSize()))) {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.opening-backpack");
            }
        } else {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "backpack.no-stack", true);
        }
    }

    private void openBackpack(ItemStack item, PlayerProfile profile, int size) {
        Player p = profile.getPlayer();
        for (int line = 0; line < item.getItemMeta().getLore().size(); ++line) {
            if (!((String)item.getItemMeta().getLore().get(line)).equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7ID: <ID>"))) continue;
            BackpackListener.setBackpackId(p, item, line, profile.createBackpack(size).getID());
            break;
        }
        if (!this.backpacks.containsValue(item)) {
            p.playSound(p.getLocation(), Sound.ENTITY_HORSE_ARMOR, 1.0f, 1.0f);
            this.backpacks.put(p.getUniqueId(), item);
            Slimefun.runSync(() -> PlayerProfile.getBackpack(item).open(p));
        } else {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "backpack.already-open", true);
        }
    }

    public static void setBackpackId(Player p, ItemStack item, int line, int id) {
        ItemMeta im = item.getItemMeta();
        List lore = im.getLore();
        lore.set(line, ((String)lore.get(line)).replace("<ID>", p.getUniqueId() + "#" + id));
        im.setLore(lore);
        item.setItemMeta(im);
    }
}

