/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.hooks;

import io.github.thebusybiscuit.slimefun4.core.hooks.ClearLagHook;
import io.github.thebusybiscuit.slimefun4.core.hooks.PlaceholderAPIHook;
import io.github.thebusybiscuit.slimefun4.core.hooks.WorldEditHook;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.plugin.Plugin;

public final class SlimefunHooks {
    private final SlimefunPlugin plugin;
    private boolean exoticGarden = false;
    private boolean emeraldEnchants = false;
    private boolean coreProtect = false;
    private boolean clearLag = false;
    private boolean worldEdit = false;
    private boolean placeHolderAPI = false;

    public SlimefunHooks(SlimefunPlugin plugin) {
        this.plugin = plugin;
        if (this.isPluginInstalled("PlaceholderAPI")) {
            this.placeHolderAPI = true;
            new PlaceholderAPIHook().register();
        }
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> {
            if (this.isPluginInstalled("ClearLag")) {
                this.clearLag = true;
                new ClearLagHook(plugin);
            }
            this.exoticGarden = this.isPluginInstalled("ExoticGarden");
            this.emeraldEnchants = this.isPluginInstalled("EmeraldEnchants");
            if (this.isPluginInstalled("WorldEdit")) {
                try {
                    Class.forName("com.sk89q.worldedit.extent.Extent");
                    this.worldEdit = true;
                    new WorldEditHook();
                }
                catch (Exception x) {
                    Slimefun.getLogger().log(Level.WARNING, "Failed to hook into WorldEdit!");
                    Slimefun.getLogger().log(Level.WARNING, "Maybe consider updating WorldEdit or Slimefun?");
                }
            }
        });
    }

    private boolean isPluginInstalled(String hook) {
        if (this.plugin.getServer().getPluginManager().isPluginEnabled(hook)) {
            Slimefun.getLogger().log(Level.INFO, "Hooked into Plugin: {0}", hook);
            return true;
        }
        return false;
    }

    public boolean isExoticGardenInstalled() {
        return this.exoticGarden;
    }

    public boolean isEmeraldEnchantsInstalled() {
        return this.emeraldEnchants;
    }

    public boolean isCoreProtectInstalled() {
        return this.coreProtect;
    }

    public boolean isClearLagInstalled() {
        return this.clearLag;
    }

    public boolean isWorldEditInstalled() {
        return this.worldEdit;
    }

    public boolean isPlaceholderAPIInstalled() {
        return this.placeHolderAPI;
    }
}

