/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.implementation.items.cargo.ReactorAccessPort;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.holograms.ReactorHologram;
import io.github.thebusybiscuit.slimefun4.utils.holograms.SimpleHologram;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.RecipeDisplayItem;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.energy.EnergyNetComponentType;
import me.mrCookieSlime.Slimefun.api.energy.EnergyTicker;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AReactor
extends SlimefunItem
implements RecipeDisplayItem,
EnergyNetComponent {
    public static Map<Location, MachineFuel> processing = new HashMap<Location, MachineFuel>();
    public static Map<Location, Integer> progress = new HashMap<Location, Integer>();
    private static final BlockFace[] cooling = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private final Set<MachineFuel> recipes = new HashSet<MachineFuel>();
    private static final int[] border = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 12, 13, 14, 21, 23};
    private static final int[] border_1 = new int[]{9, 10, 11, 18, 20, 27, 29, 36, 38, 45, 46, 47};
    private static final int[] border_2 = new int[]{15, 16, 17, 24, 26, 33, 35, 42, 44, 51, 52, 53};
    private static final int[] border_3 = new int[]{30, 31, 32, 39, 41, 48, 50};
    private static final int[] border_4 = new int[]{25, 34, 43};
    private static final int INFO_SLOT = 49;

    public AReactor(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        new BlockMenuPreset(this.getID(), this.getInventoryTitle()){

            @Override
            public void init() {
                AReactor.this.constructMenu(this);
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
                if (BlockStorage.getLocationInfo(b.getLocation(), "reactor-mode") == null) {
                    BlockStorage.addBlockInfo(b, "reactor-mode", "generator");
                }
                if (!BlockStorage.hasBlockInfo(b) || BlockStorage.getLocationInfo(b.getLocation(), "reactor-mode").equals("generator")) {
                    menu.replaceExistingItem(4, new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTM0M2NlNThkYTU0Yzc5OTI0YTJjOTMzMWNmYzQxN2ZlOGNjYmJlYTliZTQ1YTdhYzg1ODYwYTZjNzMwIn19fQ=="), "&7Focus: &eElectricity", "", "&6Your Reactor will focus on Power Generation", "&6If your Energy Network doesn't need Power", "&6it will not produce any either", "", "&7> Click to change the Focus to &eProduction"));
                    menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo(b, "reactor-mode", "production");
                        this.newInstance(menu, b);
                        return false;
                    });
                } else {
                    menu.replaceExistingItem(4, new CustomItem(SlimefunItems.PLUTONIUM, "&7Focus: &eProduction", "", "&6Your Reactor will focus on producing goods", "&6If your Energy Network doesn't need Power", "&6it will continue to run and simply will", "&6not generate any Power in the mean time", "", "&7> Click to change the Focus to &ePower Generation"));
                    menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo(b, "reactor-mode", "generator");
                        this.newInstance(menu, b);
                        return false;
                    });
                }
                BlockMenu port = AReactor.this.getAccessPort(b.getLocation());
                if (port != null) {
                    menu.replaceExistingItem(49, new CustomItem(new ItemStack(Material.GREEN_WOOL), "&7Access Port", "", "&6Detected", "", "&7> Click to view Access Port"));
                    menu.addMenuClickHandler(49, (p, slot, item, action) -> {
                        port.open(new Player[]{p});
                        this.newInstance(menu, b);
                        return false;
                    });
                } else {
                    menu.replaceExistingItem(49, new CustomItem(new ItemStack(Material.RED_WOOL), "&7Access Port", "", "&cNot detected", "", "&7Access Port must be", "&7placed 3 blocks above", "&7a reactor!"));
                    menu.addMenuClickHandler(49, (p, slot, item, action) -> {
                        this.newInstance(menu, b);
                        menu.open(new Player[]{p});
                        return false;
                    });
                }
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }
        };
        AReactor.registerBlockHandler(this.getID(), (p, b, tool, reason) -> {
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                for (int slot : this.getFuelSlots()) {
                    if (inv.getItemInSlot(slot) == null) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                    inv.replaceExistingItem(slot, null);
                }
                for (int slot : this.getCoolantSlots()) {
                    if (inv.getItemInSlot(slot) == null) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                    inv.replaceExistingItem(slot, null);
                }
                for (int slot : this.getOutputSlots()) {
                    if (inv.getItemInSlot(slot) == null) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                    inv.replaceExistingItem(slot, null);
                }
            }
            progress.remove(b.getLocation());
            processing.remove(b.getLocation());
            SimpleHologram.remove(b);
            return true;
        });
        this.registerDefaultRecipes();
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_1) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_3) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.GREEN_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(22, new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(1, new CustomItem(SlimefunItems.URANIUM, "&7Fuel Slot", "", "&rThis Slot accepts radioactive Fuel such as:", "&2Uranium &ror &aNeptunium"), ChestMenuUtils.getEmptyClickHandler());
        for (int i : border_2) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        if (this.needsCooling()) {
            preset.addItem(7, new CustomItem(this.getCoolant(), "&bCoolant Slot", "", "&rThis Slot accepts Coolant Cells", "&4Without any Coolant Cells, your Reactor", "&4will explode"));
        } else {
            preset.addItem(7, new CustomItem(new ItemStack(Material.BARRIER), "&bCoolant Slot", "", "&rThis Slot accepts Coolant Cells"));
            for (int i : border_4) {
                preset.addItem(i, new CustomItem(new ItemStack(Material.BARRIER), "&cNo Coolant Required", new String[0]), ChestMenuUtils.getEmptyClickHandler());
            }
        }
    }

    public abstract String getInventoryTitle();

    public abstract void registerDefaultRecipes();

    public abstract int getEnergyProduction();

    public abstract void extraTick(Location var1);

    public abstract ItemStack getCoolant();

    public boolean needsCooling() {
        return this.getCoolant() != null;
    }

    public int[] getInputSlots() {
        return new int[]{19, 28, 37, 25, 34, 43};
    }

    public int[] getFuelSlots() {
        return new int[]{19, 28, 37};
    }

    public int[] getCoolantSlots() {
        int[] nArray;
        if (this.needsCooling()) {
            int[] nArray2 = new int[3];
            nArray2[0] = 25;
            nArray2[1] = 34;
            nArray = nArray2;
            nArray2[2] = 43;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public int[] getOutputSlots() {
        return new int[]{40};
    }

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.GENERATOR;
    }

    public MachineFuel getProcessing(Location l) {
        return processing.get(l);
    }

    public boolean isProcessing(Location l) {
        return progress.containsKey(l);
    }

    public void registerFuel(MachineFuel fuel) {
        this.recipes.add(fuel);
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new EnergyTicker(){
            private final Set<Location> explode = new HashSet<Location>();

            @Override
            public double generateEnergy(Location l, SlimefunItem sf, Config data) {
                BlockMenu menu = BlockStorage.getInventory(l);
                BlockMenu port = AReactor.this.getAccessPort(l);
                if (AReactor.this.isProcessing(l)) {
                    AReactor.this.extraTick(l);
                    int timeleft = progress.get(l);
                    if (timeleft > 0) {
                        int produced = AReactor.this.getEnergyProduction();
                        int space = ChargableBlock.getMaxCharge(l) - ChargableBlock.getCharge(l);
                        if (space >= produced) {
                            ChargableBlock.addCharge(l, AReactor.this.getEnergyProduction());
                            space -= produced;
                        }
                        if (space >= produced || !"generator".equals(BlockStorage.getLocationInfo(l, "reactor-mode"))) {
                            progress.put(l, timeleft - 1);
                            Slimefun.runSync(() -> {
                                if (!l.getBlock().getRelative(cooling[ThreadLocalRandom.current().nextInt(cooling.length)]).isLiquid()) {
                                    this.explode.add(l);
                                }
                            });
                            ChestMenuUtils.updateProgressbar(menu, 22, timeleft, processing.get(l).getTicks(), AReactor.this.getProgressBar());
                            if (AReactor.this.needsCooling()) {
                                boolean coolant;
                                boolean bl = coolant = (processing.get(l).getTicks() - timeleft) % 25 == 0;
                                if (coolant) {
                                    if (port != null) {
                                        for (int slot : AReactor.this.getCoolantSlots()) {
                                            if (!SlimefunManager.isItemSimilar(port.getItemInSlot(slot), AReactor.this.getCoolant(), true)) continue;
                                            port.replaceExistingItem(slot, menu.pushItem(port.getItemInSlot(slot), AReactor.this.getCoolantSlots()));
                                        }
                                    }
                                    boolean explosion = true;
                                    for (int slot : AReactor.this.getCoolantSlots()) {
                                        if (!SlimefunManager.isItemSimilar(menu.getItemInSlot(slot), AReactor.this.getCoolant(), true)) continue;
                                        menu.consumeItem(slot);
                                        ReactorHologram.update(l, "&b\u2744 &7100%");
                                        explosion = false;
                                        break;
                                    }
                                    if (explosion) {
                                        this.explode.add(l);
                                        return 0.0;
                                    }
                                } else {
                                    ReactorHologram.update(l, "&b\u2744 &7" + AReactor.this.getPercentage(timeleft, processing.get(l).getTicks()) + "%");
                                }
                            }
                            return ChargableBlock.getCharge(l);
                        }
                        return 0.0;
                    }
                    menu.replaceExistingItem(22, new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ", new String[0]));
                    if (processing.get(l).getOutput() != null) {
                        menu.pushItem(processing.get(l).getOutput(), AReactor.this.getOutputSlots());
                    }
                    if (port != null) {
                        for (int slot : AReactor.this.getOutputSlots()) {
                            if (menu.getItemInSlot(slot) == null) continue;
                            menu.replaceExistingItem(slot, port.pushItem(menu.getItemInSlot(slot), ReactorAccessPort.getOutputSlots()));
                        }
                    }
                    progress.remove(l);
                    processing.remove(l);
                    return 0.0;
                }
                HashMap found = new HashMap();
                MachineFuel fuel = AReactor.this.findRecipe(menu, found);
                if (port != null) {
                    AReactor.this.restockFuel(menu, port);
                }
                if (fuel != null) {
                    for (Map.Entry entry : found.entrySet()) {
                        menu.consumeItem((Integer)entry.getKey(), (Integer)entry.getValue());
                    }
                    processing.put(l, fuel);
                    progress.put(l, fuel.getTicks());
                }
                return 0.0;
            }

            @Override
            public boolean explode(Location l) {
                boolean explosion = this.explode.contains(l);
                if (explosion) {
                    Slimefun.runSync(() -> {
                        BlockStorage.getInventory(l).close();
                        SimpleHologram.remove(l.getBlock());
                    });
                    this.explode.remove(l);
                    processing.remove(l);
                    progress.remove(l);
                }
                return explosion;
            }
        });
    }

    private float getPercentage(int time, int total) {
        int passed = (total - time) % 25;
        return Math.round((float)(25 - passed) * 100.0f / 25.0f * 100.0f / 100.0f);
    }

    private void restockFuel(BlockMenu menu, BlockMenu port) {
        for (int slot : this.getFuelSlots()) {
            for (MachineFuel recipe : this.recipes) {
                if (!SlimefunManager.isItemSimilar(port.getItemInSlot(slot), recipe.getInput(), true) || !menu.fits(new CustomItem(port.getItemInSlot(slot), 1), this.getFuelSlots())) continue;
                port.replaceExistingItem(slot, menu.pushItem(port.getItemInSlot(slot), this.getFuelSlots()));
                return;
            }
        }
    }

    private MachineFuel findRecipe(BlockMenu menu, Map<Integer, Integer> found) {
        for (MachineFuel recipe : this.recipes) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunManager.isItemSimilar(menu.getItemInSlot(slot), recipe.getInput(), true)) continue;
                found.put(slot, recipe.getInput().getAmount());
                return recipe;
            }
        }
        return null;
    }

    public abstract ItemStack getProgressBar();

    public Set<MachineFuel> getFuelTypes() {
        return this.recipes;
    }

    public BlockMenu getAccessPort(Location l) {
        Location portL = new Location(l.getWorld(), l.getX(), l.getY() + 3.0, l.getZ());
        if (BlockStorage.check(portL, "REACTOR_ACCESS_PORT")) {
            return BlockStorage.getInventory(portL);
        }
        return null;
    }

    @Override
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.generator";
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MachineFuel fuel : this.recipes) {
            ItemStack item = fuel.getInput().clone();
            ItemMeta im = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &7Lasts " + AReactor.getTimeLeft(fuel.getTicks() / 2))));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &e\u26a1 &7" + this.getEnergyProduction() * 2)) + " J/s");
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &e\u26a1 &7" + DoubleHandler.getFancyDouble((double)fuel.getTicks() * (double)this.getEnergyProduction()) + " J in total")));
            im.setLore(lore);
            item.setItemMeta(im);
            list.add(item);
        }
        return list;
    }

    private static String getTimeLeft(int seconds) {
        String timeleft = "";
        int minutes = (int)((long)seconds / 60L);
        if (minutes > 0) {
            timeleft = timeleft + minutes + "m ";
        }
        return "&7" + timeleft + (seconds -= minutes * 60) + "s";
    }
}

