/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.localization;

import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Localization;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class SlimefunLocalization
extends Localization
implements Keyed {
    public SlimefunLocalization(SlimefunPlugin plugin) {
        super((Plugin)plugin);
    }

    public abstract Language getLanguage(String var1);

    public abstract Language getLanguage(Player var1);

    public abstract Language getDefaultLanguage();

    public abstract boolean hasLanguage(String var1);

    public abstract Collection<Language> getLanguages();

    public String getMessage(Player p, String key) {
        Language language = this.getLanguage(p);
        return language.getMessages().getString(key);
    }

    public List<String> getMessages(Player p, String key) {
        Language language = this.getLanguage(p);
        return language.getMessages().getStringList(key);
    }

    public String getResearchName(Player p, NamespacedKey key) {
        Language language = this.getLanguage(p);
        if (language.getResearches() == null) {
            return null;
        }
        return language.getResearches().getString(key.getNamespace() + "." + key.getKey());
    }

    public String getCategoryName(Player p, NamespacedKey key) {
        Language language = this.getLanguage(p);
        if (language.getCategories() == null) {
            return null;
        }
        return language.getCategories().getString(key.getNamespace() + "." + key.getKey());
    }

    public String getResourceString(Player p, String key) {
        String value;
        Language language = this.getLanguage(p);
        String string = value = language.getResources() != null ? language.getResources().getString(key) : null;
        if (value != null) {
            return value;
        }
        return this.getLanguage("en").getResources().getString(key);
    }

    public ItemStack getRecipeTypeItem(Player p, RecipeType recipeType) {
        Language language = this.getLanguage(p);
        ItemStack item = recipeType.toItem();
        NamespacedKey key = recipeType.getKey();
        if (language.getRecipeTypes() == null || !language.getRecipeTypes().contains(key.getNamespace() + "." + key.getKey())) {
            language = this.getLanguage("en");
        }
        if (!language.getRecipeTypes().contains(key.getNamespace() + "." + key.getKey())) {
            return item;
        }
        FileConfiguration config = language.getRecipeTypes();
        return new CustomItem(item, meta -> {
            meta.setDisplayName(ChatColor.AQUA + config.getString(key.getNamespace() + "." + key.getKey() + ".name"));
            List lore = config.getStringList(key.getNamespace() + "." + key.getKey() + ".lore");
            lore.replaceAll(str -> ChatColor.GRAY + str);
            meta.setLore(lore);
        });
    }

    @Override
    public void sendMessage(CommandSender sender, String key, boolean addPrefix) {
        String prefix;
        String string = prefix = addPrefix ? this.getPrefix() : "";
        if (sender instanceof Player) {
            sender.sendMessage(ChatColors.color(prefix + this.getMessage((Player)sender, key)));
        } else {
            sender.sendMessage(ChatColor.stripColor((String)ChatColors.color(prefix + this.getMessage(key))));
        }
    }

    @Override
    public void sendMessage(CommandSender sender, String key) {
        this.sendMessage(sender, key, true);
    }

    public void sendMessage(CommandSender sender, String key, UnaryOperator<String> function) {
        this.sendMessage(sender, key, true, function);
    }

    @Override
    public void sendMessage(CommandSender sender, String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix;
        String string = prefix = addPrefix ? this.getPrefix() : "";
        if (sender instanceof Player) {
            sender.sendMessage(ChatColors.color(prefix + (String)function.apply(this.getMessage((Player)sender, key))));
        } else {
            sender.sendMessage(ChatColor.stripColor((String)ChatColors.color(prefix + (String)function.apply(this.getMessage(key)))));
        }
    }

    @Override
    public void sendMessages(CommandSender sender, String key) {
        String prefix = this.getPrefix();
        if (sender instanceof Player) {
            for (String translation : this.getMessages((Player)sender, key)) {
                String message = ChatColors.color(prefix + translation);
                sender.sendMessage(message);
            }
        } else {
            for (String translation : this.getMessages(key)) {
                String message = ChatColors.color(prefix + translation);
                sender.sendMessage(ChatColor.stripColor((String)message));
            }
        }
    }

    @Override
    public void sendMessages(CommandSender sender, String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix;
        String string = prefix = addPrefix ? this.getPrefix() : "";
        if (sender instanceof Player) {
            for (String translation : this.getMessages((Player)sender, key)) {
                String message = ChatColors.color(prefix + (String)function.apply(translation));
                sender.sendMessage(message);
            }
        } else {
            for (String translation : this.getMessages(key)) {
                String message = ChatColors.color(prefix + (String)function.apply(translation));
                sender.sendMessage(ChatColor.stripColor((String)message));
            }
        }
    }

    public void sendMessages(CommandSender sender, String key, UnaryOperator<String> function) {
        this.sendMessages(sender, key, true, function);
    }
}

