/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ScriptPart;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

abstract class ScriptHolder
extends SimpleSlimefunItem<BlockTicker> {
    public ScriptHolder(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    public abstract AndroidType getAndroidType();

    protected void killEntities(Block b, double damage, Predicate<Entity> predicate) {
        throw new UnsupportedOperationException("Non-butcher Android tried to butcher!");
    }

    protected void fish(Block b, BlockMenu menu) {
        throw new UnsupportedOperationException("Non-fishing Android tried to fish!");
    }

    protected void mine(Block b, BlockMenu menu, Block block) {
        throw new UnsupportedOperationException("Non-mining Android tried to mine!");
    }

    protected void movedig(Block b, BlockMenu menu, BlockFace face, Block block) {
        throw new UnsupportedOperationException("Non-mining Android tried to mine!");
    }

    protected boolean chopTree(Block b, BlockMenu menu, BlockFace face) {
        throw new UnsupportedOperationException("Non-woodcutter Android tried to chop a Tree!");
    }

    protected void farm(BlockMenu menu, Block block) {
        throw new UnsupportedOperationException("Non-farming Android tried to farm!");
    }

    protected void exoticFarm(BlockMenu menu, Block block) {
        throw new UnsupportedOperationException("Non-farming Android tried to farm!");
    }

    public void openScript(Player p, Block b, String script) {
        ChestMenu menu = new ChestMenu(ChatColor.DARK_AQUA + SlimefunPlugin.getLocal().getMessage(p, "android.scripts.editor"));
        String[] commands = script.split("-");
        menu.addItem(0, (ItemStack)new CustomItem(ScriptPart.START.getItem(), SlimefunPlugin.getLocal().getMessage(p, "android.scripts.instructions.START"), "", "&7\u21e8 &eLeft Click &7to return to the Android's interface"));
        menu.addMenuClickHandler(0, (pl, slot, item, action) -> {
            BlockStorage.getInventory(b).open(new Player[]{pl});
            return false;
        });
        for (int i = 1; i < commands.length; ++i) {
            int index = i;
            if (i == commands.length - 1) {
                int additional;
                int n = additional = commands.length == 54 ? 0 : 1;
                if (additional == 1) {
                    menu.addItem(i, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTcxZDg5NzljMTg3OGEwNTk4N2E3ZmFmMjFiNTZkMWI3NDRmOWQwNjhjNzRjZmZjZGUxZWExZWRhZDU4NTIifX19"), "&7> Add new Command", new String[0]));
                    menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                        this.openScriptComponentEditor(pl, b, script, index);
                        return false;
                    });
                }
                menu.addItem(i + additional, (ItemStack)new CustomItem(ScriptPart.REPEAT.getItem(), SlimefunPlugin.getLocal().getMessage(p, "android.scripts.instructions.REPEAT"), "", "&7\u21e8 &eLeft Click &7to return to the Android's interface"));
                menu.addMenuClickHandler(i + additional, (pl, slot, item, action) -> {
                    BlockStorage.getInventory(b).open(new Player[]{pl});
                    return false;
                });
                continue;
            }
            ItemStack stack = ScriptPart.valueOf(commands[i]).getItem();
            menu.addItem(i, (ItemStack)new CustomItem(stack, SlimefunPlugin.getLocal().getMessage(p, "android.scripts.instructions." + ScriptPart.valueOf(commands[i]).name()), "", "&7\u21e8 &eLeft Click &7to edit", "&7\u21e8 &eRight Click &7to delete", "&7\u21e8 &eShift + Right Click &7to duplicate"));
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                if (action.isRightClicked() && action.isShiftClicked()) {
                    if (commands.length == 54) {
                        return false;
                    }
                    int j = 0;
                    StringBuilder builder = new StringBuilder((Object)((Object)ScriptPart.START) + "-");
                    for (String command : commands) {
                        if (j > 0) {
                            if (j == index) {
                                builder.append(commands[j] + "-");
                                builder.append(commands[j] + "-");
                            } else if (j < commands.length - 1) {
                                builder.append(command + "-");
                            }
                        }
                        ++j;
                    }
                    builder.append((Object)ScriptPart.REPEAT);
                    BlockStorage.addBlockInfo(b, "script", builder.toString());
                    this.openScript(pl, b, builder.toString());
                } else if (action.isRightClicked()) {
                    int j = 0;
                    StringBuilder builder = new StringBuilder((Object)((Object)ScriptPart.START) + "-");
                    for (String command : commands) {
                        if (j != index && j > 0 && j < commands.length - 1) {
                            builder.append(command + "-");
                        }
                        ++j;
                    }
                    builder.append((Object)ScriptPart.REPEAT);
                    BlockStorage.addBlockInfo(b, "script", builder.toString());
                    this.openScript(pl, b, builder.toString());
                } else {
                    this.openScriptComponentEditor(pl, b, script, index);
                }
                return false;
            });
        }
        menu.open(new Player[]{p});
    }

    protected void openScriptDownloader(Player p, Block b, int page) {
        int target;
        ChestMenu menu = new ChestMenu("Android Scripts");
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 0.7f, 0.7f));
        List<Config> scripts = this.getUploadedScripts();
        int index = 0;
        int pages = scripts.size() / 45 + 1;
        for (int i = 45; i < 54; ++i) {
            menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]));
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
        }
        menu.addItem(46, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), "&r\u21e6 Previous Page", "", "&7(" + page + " / " + pages + ")"));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            int next = page - 1;
            if (next < 1) {
                next = pages;
            }
            if (next != page) {
                this.openScriptDownloader(pl, b, next);
            }
            return false;
        });
        menu.addItem(48, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTA1YTJjYWI4YjY4ZWE1N2UzYWY5OTJhMzZlNDdjOGZmOWFhODdjYzg3NzYyODE5NjZmOGMzY2YzMWEzOCJ9fX0="), "&eUpload a Script", "", "&6Click &7to upload your Android's Script", "&7to the Database"));
        menu.addMenuClickHandler(48, (pl, slot, item, action) -> {
            String code = BlockStorage.getLocationInfo(b.getLocation(), "script");
            int num = 1;
            for (Config script : this.getUploadedScripts()) {
                if (script.getString("author").equals(pl.getUniqueId().toString())) {
                    ++num;
                }
                if (!script.getString("code").equals(code)) continue;
                SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.already-uploaded", true);
                return false;
            }
            int id = num;
            pl.closeInventory();
            SlimefunPlugin.getLocal().sendMessages((CommandSender)pl, "android.scripts.enter-name");
            ChatInput.waitForPlayer((Plugin)SlimefunPlugin.instance, pl, msg -> {
                Config script = new Config("plugins/Slimefun/scripts/" + this.getAndroidType().toString() + '/' + p.getName() + ' ' + id + ".sfs");
                script.setValue("author", pl.getUniqueId().toString());
                script.setValue("author_name", pl.getName());
                script.setValue("name", ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)msg)));
                script.setValue("code", code);
                script.setValue("downloads", 0);
                script.setValue("android", this.getAndroidType().toString());
                script.setValue("rating.positive", new ArrayList());
                script.setValue("rating.negative", new ArrayList());
                script.save();
                SlimefunPlugin.getLocal().sendMessages((CommandSender)pl, "android.scripts.uploaded");
                this.openScriptDownloader(pl, b, page);
            });
            return false;
        });
        menu.addItem(50, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), "&rNext Page \u21e8", "", "&7(" + page + " / " + pages + ")"));
        menu.addMenuClickHandler(50, (pl, slot, item, action) -> {
            int next = page + 1;
            if (next > pages) {
                next = 1;
            }
            if (next != page) {
                this.openScriptDownloader(pl, b, next);
            }
            return false;
        });
        menu.addItem(53, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTE4NWM5N2RiYjgzNTNkZTY1MjY5OGQyNGI2NDMyN2I3OTNhM2YzMmE5OGJlNjdiNzE5ZmJlZGFiMzVlIn19fQ=="), "&6> Back", "", "&7Return to the Android's interface"));
        menu.addMenuClickHandler(53, (pl, slot, item, action) -> {
            this.openScriptEditor(pl, b);
            return false;
        });
        int categoryIndex = 45 * (page - 1);
        for (int i = 0; i < 45 && (target = categoryIndex + i) < scripts.size(); ++i) {
            String author;
            Config script = scripts.get(target);
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)script.getUUID("author"));
            String string = author = op != null && op.getName() != null ? op.getName() : script.getString("author_name");
            if (script.getString("author").equals(p.getUniqueId().toString())) {
                menu.addItem(index, (ItemStack)new CustomItem(this.getItem(), "&b" + script.getString("name"), "&7by &r" + author, "", "&7Downloads: &r" + script.getInt("downloads"), "&7Rating: " + this.getScriptRatingPercentage(script), "&a" + this.getScriptRating(script, true) + " \u263a &7- &4\u2639 " + this.getScriptRating(script, false), "", "&eLeft Click &rto download this Script", "&4(This will override your current Script)"));
            } else {
                menu.addItem(index, (ItemStack)new CustomItem(this.getItem(), "&b" + script.getString("name"), "&7by &r" + author, "", "&7Downloads: &r" + script.getInt("downloads"), "&7Rating: " + this.getScriptRatingPercentage(script), "&a" + this.getScriptRating(script, true) + " \u263a &7- &4\u2639 " + this.getScriptRating(script, false), "", "&eLeft Click &rto download this Script", "&4(This will override your current Script)", "&eShift + Left Click &rto leave a positive Rating", "&eShift + Right Click &rto leave a negative Rating"));
            }
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                Config script2 = new Config(script.getFile());
                if (action.isShiftClicked()) {
                    if (script2.getString("author").equals(pl.getUniqueId().toString())) {
                        SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.rating.own", true);
                    } else if (action.isRightClicked()) {
                        if (!script2.getStringList("rating.negative").contains(pl.getUniqueId().toString()) && !script2.getStringList("rating.positive").contains(pl.getUniqueId().toString())) {
                            List<String> list = script2.getStringList("rating.negative");
                            list.add(p.getUniqueId().toString());
                            script2.setValue("rating.negative", list);
                            script2.save();
                            this.openScriptDownloader(pl, b, page);
                        } else {
                            SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.rating.already", true);
                        }
                    } else if (!script2.getStringList("rating.negative").contains(pl.getUniqueId().toString()) && !script2.getStringList("rating.positive").contains(pl.getUniqueId().toString())) {
                        List<String> list = script2.getStringList("rating.positive");
                        list.add(pl.getUniqueId().toString());
                        script2.setValue("rating.positive", list);
                        script2.save();
                        this.openScriptDownloader(pl, b, page);
                    } else {
                        SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.rating.already", true);
                    }
                } else if (!action.isRightClicked()) {
                    script2.setValue("downloads", script2.getInt("downloads") + 1);
                    script2.save();
                    BlockStorage.addBlockInfo(b, "script", script2.getString("code"));
                    this.openScriptEditor(pl, b);
                }
                return false;
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public void openScriptEditor(Player p, Block b) {
        ChestMenu menu = new ChestMenu(ChatColor.DARK_AQUA + SlimefunPlugin.getLocal().getMessage(p, "android.scripts.editor"));
        menu.addItem(1, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDliZjZkYjRhZWRhOWQ4ODIyYjlmNzM2NTM4ZThjMThiOWE0ODQ0Zjg0ZWI0NTUwNGFkZmJmZWU4N2ViIn19fQ=="), "&2> Edit Script", "", "&aEdits your current Script"));
        menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
            this.openScript(pl, b, BlockStorage.getLocationInfo(b.getLocation(), "script"));
            return false;
        });
        menu.addItem(3, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTcxZDg5NzljMTg3OGEwNTk4N2E3ZmFmMjFiNTZkMWI3NDRmOWQwNjhjNzRjZmZjZGUxZWExZWRhZDU4NTIifX19"), "&4> Create new Script", "", "&cDeletes your current Script", "&cand creates a blank one"));
        menu.addMenuClickHandler(3, (pl, slot, item, action) -> {
            this.openScript(pl, b, "START-TURN_LEFT-REPEAT");
            return false;
        });
        menu.addItem(5, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzAxNTg2ZTM5ZjZmZmE2M2I0ZmIzMDFiNjVjYTdkYThhOTJmNzM1M2FhYWI4OWQzODg2NTc5MTI1ZGZiYWY5In19fQ=="), "&6> Download a Script", "", "&eDownload a Script from the Server", "&eYou can edit or simply use it"));
        menu.addMenuClickHandler(5, (pl, slot, item, action) -> {
            this.openScriptDownloader(pl, b, 1);
            return false;
        });
        menu.addItem(8, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTE4NWM5N2RiYjgzNTNkZTY1MjY5OGQyNGI2NDMyN2I3OTNhM2YzMmE5OGJlNjdiNzE5ZmJlZGFiMzVlIn19fQ=="), "&6> Back", "", "&7Return to the Android's interface"));
        menu.addMenuClickHandler(8, (pl, slot, item, action) -> {
            BlockStorage.getInventory(b).open(new Player[]{p});
            return false;
        });
        menu.open(new Player[]{p});
    }

    protected List<Config> getUploadedScripts() {
        ArrayList<Config> scripts = new ArrayList<Config>();
        File directory = new File("plugins/Slimefun/scripts/" + this.getAndroidType().toString());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        for (File script2 : directory.listFiles()) {
            if (!script2.getName().endsWith("sfs")) continue;
            scripts.add(new Config(script2));
        }
        if (this.getAndroidType() != AndroidType.NONE) {
            File directory2 = new File("plugins/Slimefun/scripts/NONE");
            if (!directory2.exists()) {
                directory2.mkdirs();
            }
            for (File script3 : directory2.listFiles()) {
                if (!script3.getName().endsWith("sfs")) continue;
                scripts.add(new Config(script3));
            }
        }
        Collections.sort(scripts, Comparator.comparingInt(script -> -(this.getScriptRating((Config)script, true) + 1 - this.getScriptRating((Config)script, false))));
        return scripts;
    }

    protected List<ScriptPart> getAccessibleScriptParts() {
        ArrayList<ScriptPart> list = new ArrayList<ScriptPart>();
        for (ScriptPart part : ScriptPart.values()) {
            if (part == ScriptPart.START || part == ScriptPart.REPEAT || !this.getAndroidType().isType(part.getRequiredType())) continue;
            list.add(part);
        }
        return list;
    }

    protected float getScriptRating(Config script) {
        int positive = this.getScriptRating(script, true) + 1;
        int negative = this.getScriptRating(script, false);
        return (float)Math.round((double)positive / (double)(positive + negative) * 100.0) / 100.0f;
    }

    protected int getScriptRating(Config script, boolean positive) {
        if (positive) {
            return script.getStringList("rating.positive").size();
        }
        return script.getStringList("rating.negative").size();
    }

    protected String getScriptRatingPercentage(Config script) {
        String progress = String.valueOf(this.getScriptRating(script));
        progress = Float.parseFloat(progress) < 16.0f ? "&4" + progress + "&r% " : (Float.parseFloat(progress) < 32.0f ? "&c" + progress + "&r% " : (Float.parseFloat(progress) < 48.0f ? "&6" + progress + "&r% " : (Float.parseFloat(progress) < 64.0f ? "&e" + progress + "&r% " : (Float.parseFloat(progress) < 80.0f ? "&2" + progress + "&r% " : "&a" + progress + "&r% "))));
        return progress;
    }

    protected void openScriptComponentEditor(Player p, Block b, String script, int index) {
        ChestMenu menu = new ChestMenu(ChatColor.DARK_AQUA + SlimefunPlugin.getLocal().getMessage(p, "android.scripts.editor"));
        String[] commands = script.split("-");
        ChestMenuUtils.drawBackground(menu, 0, 1, 2, 3, 4, 5, 6, 7, 8);
        menu.addItem(9, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTYxMzlmZDFjNTY1NGU1NmU5ZTRlMmM4YmU3ZWIyYmQ1YjQ5OWQ2MzM2MTY2NjNmZWVlOTliNzQzNTJhZDY0In19fQ=="), "&rDo nothing", new String[0]), (pl, slot, item, action) -> {
            int i = 0;
            StringBuilder builder = new StringBuilder("START-");
            for (String command : commands) {
                if (i != index && i > 0 && i < commands.length - 1) {
                    builder.append(command + "-");
                }
                ++i;
            }
            builder.append("REPEAT");
            BlockStorage.addBlockInfo(b, "script", builder.toString());
            this.openScript(p, b, builder.toString());
            return false;
        });
        int i = 10;
        for (ScriptPart part : this.getAccessibleScriptParts()) {
            menu.addItem(i, (ItemStack)new CustomItem(part.getItem(), SlimefunPlugin.getLocal().getMessage(p, "android.scripts.instructions." + part.name()), new String[0]), (pl, slot, item, action) -> {
                int j = 0;
                StringBuilder builder = new StringBuilder("START-");
                for (String command : commands) {
                    if (j > 0) {
                        if (j == index) {
                            builder.append(part.toString() + "-");
                        } else if (j < commands.length - 1) {
                            builder.append(command + "-");
                        }
                    }
                    ++j;
                }
                builder.append("REPEAT");
                BlockStorage.addBlockInfo(b, "script", builder.toString());
                this.openScript(pl, b, builder.toString());
                return false;
            });
            ++i;
        }
        menu.open(new Player[]{p});
    }
}

