/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.network;

import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;

public abstract class Network {
    protected Location regulator;
    private Queue<Location> nodeQueue = new ArrayDeque<Location>();
    protected Set<Location> connectedLocations = new HashSet<Location>();
    protected Set<Location> regulatorNodes = new HashSet<Location>();
    protected Set<Location> connectorNodes = new HashSet<Location>();
    protected Set<Location> terminusNodes = new HashSet<Location>();

    public abstract int getRange();

    public abstract NetworkComponent classifyLocation(Location var1);

    public abstract void locationClassificationChange(Location var1, NetworkComponent var2, NetworkComponent var3);

    protected Network(Location regulator) {
        this.regulator = regulator;
        this.connectedLocations.add(regulator);
        this.nodeQueue.add(regulator.clone());
    }

    protected void addLocationToNetwork(Location l) {
        if (this.connectedLocations.contains(l)) {
            return;
        }
        this.connectedLocations.add(l.clone());
        this.handleLocationUpdate(l);
    }

    public void handleLocationUpdate(Location l) {
        if (this.regulator.equals((Object)l)) {
            SlimefunPlugin.getNetworkManager().unregisterNetwork(this);
            return;
        }
        this.nodeQueue.add(l.clone());
    }

    public boolean connectsTo(Location l) {
        return this.connectedLocations.contains(l);
    }

    private NetworkComponent getCurrentClassification(Location l) {
        if (this.regulatorNodes.contains(l)) {
            return NetworkComponent.REGULATOR;
        }
        if (this.connectorNodes.contains(l)) {
            return NetworkComponent.CONNECTOR;
        }
        if (this.terminusNodes.contains(l)) {
            return NetworkComponent.TERMINUS;
        }
        return null;
    }

    private void discoverStep() {
        int maxSteps = SlimefunPlugin.getNetworkManager().getMaxSize();
        int steps = 0;
        while (this.nodeQueue.peek() != null) {
            Location l = this.nodeQueue.poll();
            NetworkComponent currentAssignment = this.getCurrentClassification(l);
            NetworkComponent classification = this.classifyLocation(l);
            if (classification != currentAssignment) {
                if (currentAssignment == NetworkComponent.REGULATOR || currentAssignment == NetworkComponent.CONNECTOR) {
                    SlimefunPlugin.getNetworkManager().unregisterNetwork(this);
                    return;
                }
                if (currentAssignment == NetworkComponent.TERMINUS) {
                    this.terminusNodes.remove(l);
                }
                if (classification == NetworkComponent.REGULATOR) {
                    this.regulatorNodes.add(l);
                    this.discoverNeighbors(l);
                } else if (classification == NetworkComponent.CONNECTOR) {
                    this.connectorNodes.add(l);
                    this.discoverNeighbors(l);
                } else if (classification == NetworkComponent.TERMINUS) {
                    this.terminusNodes.add(l);
                }
                this.locationClassificationChange(l, currentAssignment, classification);
            }
            if (++steps < maxSteps) continue;
            break;
        }
    }

    private void discoverNeighbors(Location l, double xDiff, double yDiff, double zDiff) {
        for (int i = this.getRange() + 1; i > 0; --i) {
            Location newLocation = l.clone().add((double)i * xDiff, (double)i * yDiff, (double)i * zDiff);
            this.addLocationToNetwork(newLocation);
        }
    }

    private void discoverNeighbors(Location l) {
        this.discoverNeighbors(l, 1.0, 0.0, 0.0);
        this.discoverNeighbors(l, -1.0, 0.0, 0.0);
        this.discoverNeighbors(l, 0.0, 1.0, 0.0);
        this.discoverNeighbors(l, 0.0, -1.0, 0.0);
        this.discoverNeighbors(l, 0.0, 0.0, 1.0);
        this.discoverNeighbors(l, 0.0, 0.0, -1.0);
    }

    public void display() {
        Slimefun.runSync(() -> {
            Particle.DustOptions options = new Particle.DustOptions(Color.BLUE, 2.0f);
            for (Location l : this.connectedLocations) {
                l.getWorld().spawnParticle(Particle.REDSTONE, l.getX() + 0.5, l.getY() + 0.5, l.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 1.0, (Object)options);
            }
        });
    }

    public void tick() {
        this.discoverStep();
    }
}

