/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun;

import io.github.thebusybiscuit.slimefun4.api.gps.GPSNetwork;
import io.github.thebusybiscuit.slimefun4.api.network.NetworkManager;
import io.github.thebusybiscuit.slimefun4.core.SlimefunRegistry;
import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunTabCompleter;
import io.github.thebusybiscuit.slimefun4.core.hooks.SlimefunHooks;
import io.github.thebusybiscuit.slimefun4.core.services.AutoSavingService;
import io.github.thebusybiscuit.slimefun4.core.services.BackupService;
import io.github.thebusybiscuit.slimefun4.core.services.BlockDataService;
import io.github.thebusybiscuit.slimefun4.core.services.CustomItemDataService;
import io.github.thebusybiscuit.slimefun4.core.services.CustomTextureService;
import io.github.thebusybiscuit.slimefun4.core.services.GitHubService;
import io.github.thebusybiscuit.slimefun4.core.services.LocalizationService;
import io.github.thebusybiscuit.slimefun4.core.services.MetricsService;
import io.github.thebusybiscuit.slimefun4.core.services.UpdaterService;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.AncientAltarListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.AndroidKillingListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.AutonomousToolsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BackpackListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BlockListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BlockPhysicsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.CoolerListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DamageListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DeathpointListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DebugFishListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.EnhancedFurnaceListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ExplosionsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.GearListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.GrapplingHookListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.IgnitionChamberListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ItemPickupListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.MultiBlockListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.NetworkListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.PlayerProfileListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunBootsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunBowListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunGuideListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunItemListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SoulboundListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.TalismanListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.TeleporterListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.VanillaMachinesListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.WorldListener;
import io.github.thebusybiscuit.slimefun4.implementation.resources.NetherIceResource;
import io.github.thebusybiscuit.slimefun4.implementation.resources.OilResource;
import io.github.thebusybiscuit.slimefun4.implementation.resources.SaltResource;
import io.github.thebusybiscuit.slimefun4.implementation.resources.UraniumResource;
import io.github.thebusybiscuit.slimefun4.implementation.setup.MiscSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.ResearchSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.SlimefunItemSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.WikiSetup;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.ArmorTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.TickerTask;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AGenerator;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AReactor;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionManager;
import me.mrCookieSlime.Slimefun.cscorelib2.recipes.RecipeSnapshot;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.ReflectionUtils;
import me.mrCookieSlime.Slimefun.utils.ConfigCache;
import me.mrCookieSlime.Slimefun.utils.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SlimefunPlugin
extends JavaPlugin {
    public static SlimefunPlugin instance;
    private RecipeSnapshot recipeSnapshot;
    private SlimefunRegistry registry;
    private final CustomItemDataService itemDataService = new CustomItemDataService((Plugin)this, "slimefun_item");
    private final CustomTextureService textureService = new CustomTextureService((Plugin)this);
    private final BlockDataService blockDataService = new BlockDataService((Plugin)this, "slimefun_block");
    private final GitHubService gitHubService = new GitHubService("TheBusyBiscuit/Slimefun4");
    private final UpdaterService updaterService = new UpdaterService((Plugin)this, this.getFile());
    private final AutoSavingService autoSavingService = new AutoSavingService();
    private final BackupService backupService = new BackupService();
    private TickerTask ticker;
    private LocalizationService local;
    private NetworkManager networkManager;
    private Config researches;
    private Config items;
    private Config whitelist;
    private Config config;
    private GPSNetwork gps;
    private ProtectionManager protections;
    private Utilities utilities;
    private ConfigCache settings;
    private SlimefunHooks hooks;
    private final String[] supported = new String[]{"v1_14_", "v1_15_"};
    private AncientAltarListener ancientAltarListener;
    private BackpackListener backpackListener;
    private SlimefunBowListener bowListener;

    public void onEnable() {
        if (this.getServer().getPluginManager().isPluginEnabled("CS-CoreLib")) {
            if (this.isVersionUnsupported()) {
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            instance = this;
            this.getLogger().log(Level.INFO, "Loading Files...");
            String[] storage = new String[]{"Players", "blocks", "stored-blocks", "stored-inventories", "stored-chunks", "universal-inventories", "waypoints", "block-backups"};
            String[] general = new String[]{"scripts", "generators", "error-reports", "cache/github"};
            for (String file : storage) {
                this.createDir("data-storage/Slimefun/" + file);
            }
            for (String file : general) {
                this.createDir("plugins/Slimefun/" + file);
            }
            this.getLogger().log(Level.INFO, "Loading Config...");
            this.config = new Config((Plugin)this);
            this.registry = new SlimefunRegistry();
            this.settings = new ConfigCache(this.config);
            this.researches = new Config((Plugin)this, "Researches.yml");
            this.items = new Config((Plugin)this, "Items.yml");
            this.whitelist = new Config((Plugin)this, "whitelist.yml");
            this.local = new LocalizationService(this, this.config.getString("options.language"));
            this.networkManager = new NetworkManager(this.config.getInt("options.max-network-size"));
            this.utilities = new Utilities();
            this.gps = new GPSNetwork();
            new MetricsService(this);
            if (this.config.getBoolean("options.auto-update")) {
                this.updaterService.start();
            }
            this.getLogger().log(Level.INFO, "Loading Items...");
            MiscSetup.setupItemSettings();
            try {
                SlimefunItemSetup.setup();
            }
            catch (Exception x) {
                this.getLogger().log(Level.SEVERE, "An Error occured while initializing SlimefunItems for Slimefun " + SlimefunPlugin.getVersion(), x);
            }
            this.getLogger().log(Level.INFO, "Loading Researches...");
            ResearchSetup.setupResearches();
            this.settings.researchesEnabled = SlimefunPlugin.getResearchCfg().getBoolean("enable-researching");
            MiscSetup.setupMisc();
            WikiSetup.addWikiPages(this);
            this.textureService.setup(this.registry.getAllSlimefunItems());
            this.getLogger().log(Level.INFO, "Loading World Generators...");
            new OilResource().register();
            new NetherIceResource().register();
            new UraniumResource().register();
            new SaltResource().register();
            this.gitHubService.connect(this.config.getBoolean("options.print-out-github-data-retrieving"));
            new SlimefunBootsListener(this);
            new SlimefunItemListener(this);
            new BlockPhysicsListener(this);
            new MultiBlockListener(this);
            new GearListener(this);
            new AutonomousToolsListener(this);
            new DamageListener(this);
            new BlockListener(this);
            new EnhancedFurnaceListener(this);
            new TeleporterListener(this);
            new AndroidKillingListener(this);
            new NetworkListener(this);
            new ItemPickupListener(this);
            new DeathpointListener(this);
            new ExplosionsListener(this);
            new DebugFishListener(this);
            new VanillaMachinesListener(this);
            this.bowListener = new SlimefunBowListener(this);
            this.ancientAltarListener = new AncientAltarListener();
            if (this.config.getBoolean("items.talismans")) {
                new TalismanListener(this);
            }
            if (this.config.getBoolean("items.coolers")) {
                new CoolerListener(this);
            }
            if (this.config.getBoolean("items.soulbound")) {
                new SoulboundListener(this);
            }
            if (this.config.getBoolean("items.backpacks")) {
                this.backpackListener = new BackpackListener(this);
            }
            new SlimefunGuideListener(this, this.config.getBoolean("options.give-guide-on-first-join"));
            new WorldListener(this);
            new PlayerProfileListener(this);
            Slimefun.runSync(() -> {
                this.recipeSnapshot = new RecipeSnapshot((Plugin)this);
                this.protections = new ProtectionManager(this.getServer());
                MiscSetup.loadItems(this.settings);
                for (World world : Bukkit.getWorlds()) {
                    new BlockStorage(world);
                }
                if (SlimefunItem.getByID("ANCIENT_ALTAR") != null) {
                    this.ancientAltarListener.load(this);
                }
                if (SlimefunItem.getByID("GRAPPLING_HOOK") != null) {
                    new GrapplingHookListener(this);
                }
                if (SlimefunItem.getByID("IGNITION_CHAMBER") != null) {
                    new IgnitionChamberListener(this);
                }
            }, 0L);
            SlimefunCommand command = new SlimefunCommand(this);
            this.getCommand("slimefun").setExecutor((CommandExecutor)command);
            this.getCommand("slimefun").setTabCompleter((TabCompleter)new SlimefunTabCompleter(command));
            if (this.config.getBoolean("options.enable-armor-effects")) {
                this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new ArmorTask(), 0L, (long)this.config.getInt("options.armor-update-interval") * 20L);
            }
            this.ticker = new TickerTask();
            this.autoSavingService.start((Plugin)this, this.config.getInt("options.auto-save-delay-in-minutes"));
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    this.ticker.run();
                }
                catch (Exception x) {
                    this.getLogger().log(Level.SEVERE, "An Exception was caught while ticking the Block Tickers Task for Slimefun v" + SlimefunPlugin.getVersion(), x);
                    this.ticker.abortTick();
                }
            }, 100L, (long)this.config.getInt("URID.custom-ticker-delay"));
            this.gitHubService.start((Plugin)this);
            this.getLogger().log(Level.INFO, "Finished!");
            this.hooks = new SlimefunHooks(this);
            this.utilities.oreWasherOutputs = new ItemStack[]{SlimefunItems.IRON_DUST, SlimefunItems.GOLD_DUST, SlimefunItems.ALUMINUM_DUST, SlimefunItems.COPPER_DUST, SlimefunItems.ZINC_DUST, SlimefunItems.TIN_DUST, SlimefunItems.LEAD_DUST, SlimefunItems.SILVER_DUST, SlimefunItems.MAGNESIUM_DUST};
            CSCoreLib.getLib().filterLog("([A-Za-z0-9_]{3,16}) issued server command: /sf elevator (.{0,})");
        } else {
            this.getLogger().log(Level.INFO, "#################### - INFO - ####################");
            this.getLogger().log(Level.INFO, " ");
            this.getLogger().log(Level.INFO, "Slimefun could not be loaded (yet).");
            this.getLogger().log(Level.INFO, "It appears that you have not installed CS-CoreLib.");
            this.getLogger().log(Level.INFO, "Please download and install CS-CoreLib manually:");
            this.getLogger().log(Level.INFO, "https://thebusybiscuit.github.io/builds/TheBusyBiscuit/CS-CoreLib/master/");
            this.getCommand("slimefun").setExecutor((sender, cmd, label, args) -> {
                sender.sendMessage("You have forgotten to install CS-CoreLib! Slimefun is disabled.");
                sender.sendMessage("https://thebusybiscuit.github.io/builds/TheBusyBiscuit/CS-CoreLib/master/");
                return true;
            });
        }
    }

    private boolean isVersionUnsupported() {
        String currentVersion = ReflectionUtils.getVersion();
        if (currentVersion.startsWith("v")) {
            boolean compatibleVersion = false;
            StringBuilder versions = new StringBuilder();
            int i = 0;
            for (String version : this.supported) {
                if (currentVersion.startsWith(version)) {
                    compatibleVersion = true;
                }
                String s = version.substring(1).replaceFirst("_", ".").replace("_", ".X");
                if (i == 0) {
                    versions.append(s);
                } else if (i == this.supported.length - 1) {
                    versions.append(" or ").append(s);
                } else {
                    versions.append(", ").append(s);
                }
                ++i;
            }
            if (!compatibleVersion) {
                this.getLogger().log(Level.SEVERE, "### Slimefun was not installed correctly!");
                this.getLogger().log(Level.SEVERE, "###");
                this.getLogger().log(Level.SEVERE, "### You are using the wrong Version of Minecraft!");
                this.getLogger().log(Level.SEVERE, "###");
                this.getLogger().log(Level.SEVERE, "### You are using Minecraft " + ReflectionUtils.getVersion());
                this.getLogger().log(Level.SEVERE, "### but Slimefun v" + this.getDescription().getVersion() + " requires you to be using");
                this.getLogger().log(Level.SEVERE, "### Minecraft {0}", versions);
                this.getLogger().log(Level.SEVERE, "###");
                this.getLogger().log(Level.SEVERE, "### Please use an older Version of Slimefun and disable auto-updating");
                this.getLogger().log(Level.SEVERE, "### or consider updating your Server Software.");
                return true;
            }
        }
        return false;
    }

    public void onDisable() {
        if (instance == null) {
            return;
        }
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.ticker != null) {
            this.ticker.halt();
            this.ticker.run();
        }
        PlayerProfile.iterator().forEachRemaining(profile -> {
            if (profile.isDirty()) {
                profile.save();
            }
        });
        for (World world : Bukkit.getWorlds()) {
            try {
                BlockStorage storage = BlockStorage.getStorage(world);
                if (storage != null) {
                    storage.save(true);
                    continue;
                }
                this.getLogger().log(Level.SEVERE, "Could not save Slimefun Blocks for World \"" + world.getName() + "\"");
            }
            catch (Exception x) {
                this.getLogger().log(Level.SEVERE, "An Error occured while saving Slimefun-Blocks in World '" + world.getName() + "' for Slimefun " + SlimefunPlugin.getVersion(), x);
            }
        }
        for (UniversalBlockMenu menu : this.registry.getUniversalInventories().values()) {
            menu.save();
        }
        this.backupService.run();
        AContainer.processing = null;
        AContainer.progress = null;
        AGenerator.processing = null;
        AGenerator.progress = null;
        AReactor.processing = null;
        AReactor.progress = null;
        instance = null;
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.closeInventory();
        }
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static Config getCfg() {
        return SlimefunPlugin.instance.config;
    }

    public static Config getResearchCfg() {
        return SlimefunPlugin.instance.researches;
    }

    public static Config getItemCfg() {
        return SlimefunPlugin.instance.items;
    }

    public static Config getWhitelist() {
        return SlimefunPlugin.instance.whitelist;
    }

    public static GPSNetwork getGPSNetwork() {
        return SlimefunPlugin.instance.gps;
    }

    public static SlimefunHooks getHooks() {
        return SlimefunPlugin.instance.hooks;
    }

    public static Utilities getUtilities() {
        return SlimefunPlugin.instance.utilities;
    }

    public static ConfigCache getSettings() {
        return SlimefunPlugin.instance.settings;
    }

    public static TickerTask getTicker() {
        return SlimefunPlugin.instance.ticker;
    }

    public static boolean isActive() {
        return instance != null;
    }

    public static String getVersion() {
        return instance.getDescription().getVersion();
    }

    public static ProtectionManager getProtectionManager() {
        return SlimefunPlugin.instance.protections;
    }

    public static LocalizationService getLocal() {
        return SlimefunPlugin.instance.local;
    }

    public static RecipeSnapshot getMinecraftRecipes() {
        return SlimefunPlugin.instance.recipeSnapshot;
    }

    public static CustomItemDataService getItemDataService() {
        return SlimefunPlugin.instance.itemDataService;
    }

    public static CustomTextureService getItemTextureService() {
        return SlimefunPlugin.instance.textureService;
    }

    public static BlockDataService getBlockDataService() {
        return SlimefunPlugin.instance.blockDataService;
    }

    public static UpdaterService getUpdater() {
        return SlimefunPlugin.instance.updaterService;
    }

    public static GitHubService getGitHubService() {
        return SlimefunPlugin.instance.gitHubService;
    }

    public static SlimefunRegistry getRegistry() {
        return SlimefunPlugin.instance.registry;
    }

    public static NetworkManager getNetworkManager() {
        return SlimefunPlugin.instance.networkManager;
    }

    public static AncientAltarListener getAncientAltarListener() {
        return SlimefunPlugin.instance.ancientAltarListener;
    }

    public static BackpackListener getBackpackListener() {
        return SlimefunPlugin.instance.backpackListener;
    }

    public static SlimefunBowListener getBowListener() {
        return SlimefunPlugin.instance.bowListener;
    }

    public static Set<Plugin> getInstalledAddons() {
        return Arrays.stream(instance.getServer().getPluginManager().getPlugins()).filter(Plugin::isEnabled).filter(plugin -> plugin.getDescription().getDepend().contains(instance.getName()) || plugin.getDescription().getSoftDepend().contains(instance.getName())).collect(Collectors.toSet());
    }
}

