/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.SlimefunBranch;
import java.io.File;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.Updater;
import org.bukkit.plugin.Plugin;

public class UpdaterService {
    private final Updater updater;
    private final SlimefunBranch branch;

    public UpdaterService(Plugin plugin, File file) {
        String version = plugin.getDescription().getVersion();
        if (version.equals("UNOFFICIAL")) {
            plugin.getLogger().log(Level.WARNING, "##################################################");
            plugin.getLogger().log(Level.WARNING, "It looks like you are using an unofficially modified build of Slimefun!");
            plugin.getLogger().log(Level.WARNING, "Auto-Updates have been disabled, this build is not considered safe.");
            plugin.getLogger().log(Level.WARNING, "Do not report bugs encountered in this Version of Slimefun.");
            plugin.getLogger().log(Level.WARNING, "##################################################");
            this.updater = null;
            this.branch = SlimefunBranch.UNOFFICIAL;
        } else if (version.startsWith("DEV - ")) {
            this.updater = new GitHubBuildsUpdater(plugin, file, "TheBusyBiscuit/Slimefun4/master");
            this.branch = SlimefunBranch.DEVELOPMENT;
        } else if (version.startsWith("RC - ")) {
            this.updater = new GitHubBuildsUpdater(plugin, file, "TheBusyBiscuit/Slimefun4/stable", "RC - ");
            this.branch = SlimefunBranch.STABLE;
        } else {
            this.updater = null;
            this.branch = SlimefunBranch.UNKNOWN;
        }
    }

    public SlimefunBranch getBranch() {
        return this.branch;
    }

    public void start() {
        if (this.updater != null) {
            this.updater.start();
        }
    }
}

