/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.GPS;

import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.GPS.GPSNetwork;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class GPSTeleportation {
    private final Set<UUID> teleporterUsers = new HashSet<UUID>();
    private final int[] teleporterBorder = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private final int[] teleporterInventory = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private final GPSNetwork network;

    public GPSTeleportation(GPSNetwork gpsNetwork) {
        this.network = gpsNetwork;
    }

    public void openTeleporterGUI(Player p, UUID uuid, Block b, int complexity) {
        if (this.teleporterUsers.contains(p.getUniqueId())) {
            return;
        }
        p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        this.teleporterUsers.add(p.getUniqueId());
        ChestMenu menu = new ChestMenu("&3Teleporter");
        menu.addMenuCloseHandler(pl -> this.teleporterUsers.remove(pl.getUniqueId()));
        for (int slot : this.teleporterBorder) {
            menu.addItem(slot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addItem(4, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzljODg4MWU0MjkxNWE5ZDI5YmI2MWExNmZiMjZkMDU5OTEzMjA0ZDI2NWRmNWI0MzliM2Q3OTJhY2Q1NiJ9fX0="), "&7Waypoint Overview &e(Select a Destination)", new String[0]));
        menu.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
        Location source = new Location(b.getWorld(), (double)b.getX() + 0.5, (double)b.getY() + 2.0, (double)b.getZ() + 0.5);
        int index = 0;
        for (Map.Entry<String, Location> entry : this.network.getWaypoints(uuid).entrySet()) {
            if (index >= this.teleporterInventory.length) break;
            int slot = this.teleporterInventory[index];
            Location l = entry.getValue();
            ItemStack globe = this.network.getIcon(entry);
            menu.addItem(slot, (ItemStack)new CustomItem(globe, entry.getKey(), "&8\u21e8 &7World: &r" + l.getWorld().getName(), "&8\u21e8 &7X: &r" + l.getX(), "&8\u21e8 &7Y: &r" + l.getY(), "&8\u21e8 &7Z: &r" + l.getZ(), "&8\u21e8 &7Estimated Teleportation Time: &r" + 50 / this.getSpeed(this.network.getNetworkComplexity(uuid), source, l) + "s", "", "&8\u21e8 &cClick to select"));
            menu.addMenuClickHandler(slot, (pl, slotn, item, action) -> {
                pl.closeInventory();
                this.start(pl.getUniqueId(), complexity, source, l, false);
                return false;
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public void start(UUID uuid, int complexity, Location source, Location destination, boolean resistance) {
        this.teleporterUsers.add(uuid);
        this.updateProgress(uuid, this.getSpeed(complexity, source, destination), 1, source, destination, resistance);
    }

    public int getSpeed(int complexity, Location source, Location destination) {
        int speed = complexity / 200;
        if (speed > 50) {
            speed = 50;
        }
        return (speed -= this.distance(source, destination) / 200) < 1 ? 1 : speed;
    }

    private int distance(Location source, Location destination) {
        if (source.getWorld().getName().equals(destination.getWorld().getName())) {
            int distance = (int)source.distance(destination);
            return distance > 8000 ? 8000 : distance;
        }
        return 8000;
    }

    private boolean isValid(Player p, Location source) {
        return p != null && p.getLocation().distanceSquared(source) < 2.0;
    }

    private void cancel(UUID uuid, Player p) {
        this.teleporterUsers.remove(uuid);
        if (p != null) {
            p.sendTitle(ChatColors.color(SlimefunPlugin.getLocal().getMessage(p, "machines.TELEPORTER.cancelled")), ChatColors.color("&c&k40&r&c%"), 20, 60, 20);
        }
    }

    private void updateProgress(UUID uuid, int speed, int progress, Location source, Location destination, boolean resistance) {
        Player p = Bukkit.getPlayer((UUID)uuid);
        if (this.isValid(p, source)) {
            if (progress > 99) {
                p.sendTitle(ChatColors.color(SlimefunPlugin.getLocal().getMessage(p, "machines.TELEPORTER.teleported")), ChatColors.color("&b100%"), 20, 60, 20);
                p.teleport(destination);
                if (resistance) {
                    p.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 600, 20));
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "machines.TELEPORTER.invulnerability");
                }
                destination.getWorld().spawnParticle(Particle.PORTAL, new Location(destination.getWorld(), destination.getX(), destination.getY() + 1.0, destination.getZ()), progress * 2, (double)0.2f, (double)0.8f, (double)0.2f);
                destination.getWorld().playSound(destination, Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
                this.teleporterUsers.remove(uuid);
            } else {
                p.sendTitle(ChatColors.color(SlimefunPlugin.getLocal().getMessage(p, "machines.TELEPORTER.teleporting")), ChatColors.color("&b" + progress + "%"), 0, 60, 0);
                source.getWorld().spawnParticle(Particle.PORTAL, source, progress * 2, (double)0.2f, (double)0.8f, (double)0.2f);
                source.getWorld().playSound(source, Sound.BLOCK_BEACON_AMBIENT, 1.0f, 0.6f);
                Slimefun.runSync(() -> this.updateProgress(uuid, speed, progress + speed, source, destination, resistance), 10L);
            }
        } else {
            this.cancel(uuid, p);
        }
    }
}

