/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.core.services.localization.SlimefunLocalization;
import io.github.thebusybiscuit.slimefun4.core.services.localization.SupportedLanguage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class LocalizationService
extends SlimefunLocalization {
    private static final String LANGUAGE_PATH = "language";
    private final Map<String, Language> languages = new LinkedHashMap<String, Language>();
    private final SlimefunPlugin plugin;
    private final NamespacedKey languageKey;
    private final Language defaultLanguage;

    public LocalizationService(SlimefunPlugin plugin, String serverDefaultLanguage) {
        super(plugin);
        this.plugin = plugin;
        this.languageKey = new NamespacedKey((Plugin)plugin, LANGUAGE_PATH);
        this.defaultLanguage = new Language(serverDefaultLanguage, "11b3188fd44902f72602bd7c2141f5a70673a411adb3d81862c69e536166b");
        this.defaultLanguage.setMessages(this.getConfig().getConfiguration());
        for (SupportedLanguage lang : SupportedLanguage.values()) {
            this.addLanguage(lang.getId(), lang.getTexture());
        }
        String language = this.getConfig().getString(LANGUAGE_PATH);
        if (language == null) {
            language = serverDefaultLanguage;
        }
        if (this.hasLanguage(serverDefaultLanguage)) {
            this.setLanguage(serverDefaultLanguage, !serverDefaultLanguage.equals(language));
        } else {
            this.setLanguage("en", false);
            plugin.getLogger().log(Level.WARNING, "Could not recognize the given language: \"{0}\"", serverDefaultLanguage);
        }
        Slimefun.getLogger().log(Level.INFO, "Available languages: {0}", String.join((CharSequence)", ", this.languages.keySet()));
        this.setPrefix("&aSlimefun 4 &7> ");
        this.save();
    }

    public NamespacedKey getKey() {
        return this.languageKey;
    }

    @Override
    public Language getLanguage(String id) {
        return this.languages.get(id);
    }

    @Override
    public Collection<Language> getLanguages() {
        return this.languages.values();
    }

    @Override
    public boolean hasLanguage(String language) {
        return this.containsResource("messages_" + language) || this.containsResource("researches_" + language);
    }

    private boolean containsResource(String file) {
        return ((Object)((Object)this.plugin)).getClass().getResource("/languages/" + file + ".yml") != null;
    }

    public boolean isLanguageLoaded(String id) {
        return this.languages.containsKey(id);
    }

    @Override
    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public Language getLanguage(Player p) {
        Language lang;
        Optional<String> language = PersistentDataAPI.getOptionalString((PersistentDataHolder)p, this.languageKey);
        if (language.isPresent() && (lang = this.languages.get(language.get())) != null) {
            return lang;
        }
        return this.getDefaultLanguage();
    }

    private void setLanguage(String language, boolean reset) {
        if (reset) {
            this.getConfig().clear();
        }
        Slimefun.getLogger().log(Level.INFO, "Loaded language \"{0}\"", language);
        this.getConfig().setValue(LANGUAGE_PATH, language);
        String path = "/languages/messages_" + language + ".yml";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this.plugin)).getClass().getResourceAsStream(path), StandardCharsets.UTF_8));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            this.getConfig().getConfiguration().setDefaults((Configuration)config);
        }
        catch (IOException e) {
            Slimefun.getLogger().log(Level.SEVERE, "Failed to load language file: \"" + path + "\"", e);
        }
        this.save();
    }

    private void addLanguage(String id, String hash) {
        if (this.hasLanguage(id)) {
            FileConfiguration messages = this.streamConfigFile("messages_" + id + ".yml", this.getConfig().getConfiguration());
            FileConfiguration researches = this.streamConfigFile("researches_" + id + ".yml", null);
            Language language = new Language(id, hash);
            language.setMessages(messages);
            language.setResearches(researches);
            this.languages.put(id, language);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileConfiguration streamConfigFile(String file, FileConfiguration defaults) {
        String path = "/languages/" + file;
        if (((Object)((Object)this.plugin)).getClass().getResourceAsStream(path) == null) {
            return new YamlConfiguration();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this.plugin)).getClass().getResourceAsStream(path), StandardCharsets.UTF_8));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            if (defaults != null) {
                config.setDefaults((Configuration)defaults);
            }
            YamlConfiguration yamlConfiguration = config;
            return yamlConfiguration;
        }
        catch (IOException e) {
            Slimefun.getLogger().log(Level.SEVERE, "Failed to load language file into memory: \"" + path + "\"", e);
            return null;
        }
    }
}

