/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.materials;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.RecipeChoice;

public class MaterialCollection
implements Iterable<Material> {
    private final Material[] asArray;

    public MaterialCollection(Collection<Material> materials) {
        this(materials.stream());
    }

    public MaterialCollection(Material ... materials) {
        this(Arrays.stream(materials));
    }

    public MaterialCollection(Tag<Material> tag) {
        this(tag.getValues());
    }

    public MaterialCollection(@NonNull Stream<Material> stream) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        this.asArray = (Material[])stream.distinct().filter(Objects::nonNull).toArray(Material[]::new);
    }

    public MaterialCollection merge(@NonNull MaterialCollection collection) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        return new MaterialCollection(Stream.concat(this.stream(), collection.stream()));
    }

    public Stream<Material> stream() {
        return Arrays.stream(this.asArray);
    }

    public int size() {
        return this.asArray.length;
    }

    public boolean isEmpty() {
        return this.asArray.length == 0;
    }

    public Material get(int index) {
        return this.asArray[index];
    }

    public boolean contains(Material type) {
        if (type == null) {
            return false;
        }
        for (Material m : this.asArray) {
            if (m != type) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(@NonNull Collection<Material> materials) {
        if (materials == null) {
            throw new NullPointerException("materials is marked non-null but is null");
        }
        return materials.stream().allMatch(this::contains);
    }

    public boolean containsAll(@NonNull MaterialCollection materials) {
        if (materials == null) {
            throw new NullPointerException("materials is marked non-null but is null");
        }
        return materials.stream().allMatch(this::contains);
    }

    public boolean containsAll(Material ... materials) {
        if (materials == null) {
            throw new NullPointerException("materials is marked non-null but is null");
        }
        return Arrays.stream(materials).allMatch(this::contains);
    }

    public RecipeChoice getAsRecipeChoice() {
        return new RecipeChoice.MaterialChoice(this.asArray);
    }

    @Override
    public Iterator<Material> iterator() {
        return this.stream().iterator();
    }

    public Material[] getAsArray() {
        return this.asArray;
    }
}

