/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.setup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.stream.Stream;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItemSerializer;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.Alloy;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ReplacingAlloy;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunMachine;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.electric.AutomatedCraftingChamber;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunRecipes;
import me.mrCookieSlime.Slimefun.utils.ConfigCache;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public final class MiscSetup {
    private MiscSetup() {
    }

    public static void setupMisc() {
        SlimefunItem talisman = SlimefunItem.getByID("COMMON_TALISMAN");
        if (talisman != null && ((Boolean)Slimefun.getItemValue(talisman.getID(), "recipe-requires-nether-stars")).booleanValue()) {
            talisman.setRecipe(new ItemStack[]{SlimefunItems.MAGIC_LUMP_2, SlimefunItems.GOLD_8K, SlimefunItems.MAGIC_LUMP_2, null, new ItemStack(Material.NETHER_STAR), null, SlimefunItems.MAGIC_LUMP_2, SlimefunItems.GOLD_8K, SlimefunItems.MAGIC_LUMP_2});
        }
        SlimefunItem.setRadioactive(SlimefunItems.URANIUM);
        SlimefunItem.setRadioactive(SlimefunItems.SMALL_URANIUM);
        SlimefunItem.setRadioactive(SlimefunItems.BLISTERING_INGOT);
        SlimefunItem.setRadioactive(SlimefunItems.BLISTERING_INGOT_2);
        SlimefunItem.setRadioactive(SlimefunItems.BLISTERING_INGOT_3);
        SlimefunItem.setRadioactive(SlimefunItems.NETHER_ICE);
        SlimefunItem.setRadioactive(SlimefunItems.ENRICHED_NETHER_ICE);
    }

    public static void loadItems(ConfigCache settings) {
        SlimefunItem crusher;
        Iterator<SlimefunItem> iterator = SlimefunPlugin.getRegistry().getEnabledSlimefunItems().iterator();
        while (iterator.hasNext()) {
            SlimefunItem item = iterator.next();
            if (item == null) {
                Slimefun.getLogger().log(Level.WARNING, "Removed bugged Item ('NULL?')");
                iterator.remove();
                continue;
            }
            if (item.getItem() != null) continue;
            Slimefun.getLogger().log(Level.WARNING, "Removed bugged Item ('" + item.getID() + "')");
            iterator.remove();
        }
        ArrayList<SlimefunItem> pre = new ArrayList<SlimefunItem>();
        ArrayList<SlimefunItem> init = new ArrayList<SlimefunItem>();
        ArrayList<SlimefunItem> post = new ArrayList<SlimefunItem>();
        for (SlimefunItem item : SlimefunPlugin.getRegistry().getEnabledSlimefunItems()) {
            if (item instanceof Alloy || item instanceof ReplacingAlloy) {
                pre.add(item);
                continue;
            }
            if (item instanceof SlimefunMachine) {
                init.add(item);
                continue;
            }
            post.add(item);
        }
        for (SlimefunItem item : pre) {
            item.load();
        }
        for (SlimefunItem item : init) {
            item.load();
        }
        for (SlimefunItem item : post) {
            item.load();
        }
        AutomatedCraftingChamber crafter = (AutomatedCraftingChamber)SlimefunItem.getByID("AUTOMATED_CRAFTING_CHAMBER");
        if (crafter != null) {
            SlimefunMachine machine = (SlimefunMachine)SlimefunItem.getByID("ENHANCED_CRAFTING_TABLE");
            for (ItemStack[] inputs : RecipeType.getRecipeInputList(machine)) {
                StringBuilder builder = new StringBuilder();
                int i = 0;
                for (ItemStack item : inputs) {
                    if (i > 0) {
                        builder.append(" </slot> ");
                    }
                    builder.append(CustomItemSerializer.serialize((ItemStack)item, (CustomItemSerializer.ItemFlag[])new CustomItemSerializer.ItemFlag[]{CustomItemSerializer.ItemFlag.MATERIAL, CustomItemSerializer.ItemFlag.ITEMMETA_DISPLAY_NAME, CustomItemSerializer.ItemFlag.ITEMMETA_LORE}));
                    ++i;
                }
                SlimefunPlugin.getRegistry().getAutomatedCraftingChamberRecipes().put(builder.toString(), RecipeType.getRecipeOutputList(machine, inputs));
            }
        }
        ArrayList<ItemStack[]> grinderRecipes = new ArrayList<ItemStack[]>();
        SlimefunItem grinder = SlimefunItem.getByID("GRIND_STONE");
        if (grinder != null) {
            ItemStack[] input = null;
            for (ItemStack[] recipe2 : ((SlimefunMachine)grinder).getRecipes()) {
                if (input == null) {
                    input = recipe2;
                    continue;
                }
                if (input[0] != null && recipe2[0] != null) {
                    grinderRecipes.add(new ItemStack[]{input[0], recipe2[0]});
                }
                input = null;
            }
        }
        if ((crusher = SlimefunItem.getByID("ORE_CRUSHER")) != null) {
            ItemStack[] input = null;
            for (ItemStack[] recipe3 : ((SlimefunMachine)crusher).getRecipes()) {
                if (input == null) {
                    input = recipe3;
                    continue;
                }
                if (input[0] != null && recipe3[0] != null) {
                    grinderRecipes.add(new ItemStack[]{input[0], recipe3[0]});
                }
                input = null;
            }
        }
        Stream stream = grinderRecipes.stream();
        if (!settings.legacyOreGrinder) {
            stream = stream.sorted((a, b) -> Integer.compare(b[0].getAmount(), a[0].getAmount()));
        }
        stream.forEach(recipe -> SlimefunRecipes.registerMachineRecipe("ELECTRIC_ORE_GRINDER", 4, new ItemStack[]{recipe[0]}, new ItemStack[]{recipe[1]}));
        SlimefunItem smeltery = SlimefunItem.getByID("SMELTERY");
        if (smeltery != null) {
            ItemStack[] input = null;
            for (ItemStack[] recipe4 : ((SlimefunMachine)smeltery).getRecipes()) {
                if (input == null) {
                    input = recipe4;
                    continue;
                }
                if (input[0] != null && recipe4[0] != null) {
                    ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
                    boolean dust = false;
                    for (ItemStack item : input) {
                        if (item == null) continue;
                        inputs.add(item);
                        if (SlimefunManager.isItemSimilar(item, SlimefunItems.ALUMINUM_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimilar(item, SlimefunItems.COPPER_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimilar(item, SlimefunItems.GOLD_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimilar(item, SlimefunItems.IRON_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimilar(item, SlimefunItems.LEAD_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimilar(item, SlimefunItems.MAGNESIUM_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimilar(item, SlimefunItems.SILVER_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimilar(item, SlimefunItems.TIN_DUST, true)) {
                            dust = true;
                        }
                        if (!SlimefunManager.isItemSimilar(item, SlimefunItems.ZINC_DUST, true)) continue;
                        dust = true;
                    }
                    if (!dust || inputs.size() != 1) {
                        SlimefunRecipes.registerMachineRecipe("ELECTRIC_SMELTERY", 12, inputs.toArray(new ItemStack[inputs.size()]), new ItemStack[]{recipe4[0]});
                    }
                }
                input = null;
            }
        }
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        int total = SlimefunPlugin.getRegistry().getEnabledSlimefunItems().size();
        int vanilla = SlimefunPlugin.getRegistry().countVanillaItems();
        sender.sendMessage("");
        sender.sendMessage(ChatColor.GREEN + "######################### - Slimefun v" + SlimefunPlugin.getVersion() + " - #########################");
        sender.sendMessage("");
        sender.sendMessage(ChatColor.GREEN + "Successfully loaded " + total + " Items (" + SlimefunPlugin.getRegistry().getResearches().size() + " Researches)");
        sender.sendMessage(ChatColor.GREEN + "( " + vanilla + " Items from Slimefun, " + (total - vanilla) + " Items from " + SlimefunPlugin.getInstalledAddons().size() + " Addons )");
        sender.sendMessage("");
        sender.sendMessage(ChatColor.GREEN + "Slimefun is an Open-Source project that is maintained by community developers!");
        sender.sendMessage("");
        sender.sendMessage(ChatColor.GREEN + " -- Source Code:   https://github.com/TheBusyBiscuit/Slimefun4");
        sender.sendMessage(ChatColor.GREEN + " -- Wiki:          https://github.com/TheBusyBiscuit/Slimefun4/wiki");
        sender.sendMessage(ChatColor.GREEN + " -- Bug Reports:   https://github.com/TheBusyBiscuit/Slimefun4/issues");
        sender.sendMessage(ChatColor.GREEN + " -- Discord:       https://discord.gg/fsD4Bkh");
        sender.sendMessage("");
        SlimefunPlugin.getItemCfg().save();
        SlimefunPlugin.getResearchCfg().save();
        SlimefunPlugin.getWhitelist().save();
    }

    public static void setupItemSettings() {
        for (World world : Bukkit.getWorlds()) {
            SlimefunPlugin.getWhitelist().setDefaultValue(world.getName() + ".enabled-items.SLIMEFUN_GUIDE", true);
        }
        Slimefun.setItemVariable("ORE_CRUSHER", "double-ores", true);
        for (Enchantment enchantment : Enchantment.values()) {
            for (int i = 1; i <= enchantment.getMaxLevel(); ++i) {
                Slimefun.setItemVariable("MAGICIAN_TALISMAN", "allow-enchantments." + enchantment.getKey().getKey() + ".level." + i, true);
            }
        }
    }
}

