/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.network;

import io.github.thebusybiscuit.slimefun4.api.network.Network;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Location;

public final class NetworkManager {
    private final int maxNodes;
    private final List<Network> networks = new LinkedList<Network>();

    public NetworkManager(int capacity) {
        this.maxNodes = capacity;
    }

    public int getMaxSize() {
        return this.maxNodes;
    }

    public List<Network> getNetworkList() {
        return this.networks;
    }

    public <T extends Network> T getNetworkFromLocation(Location l, Class<T> type) {
        for (Network network : this.networks) {
            if (!type.isInstance(network) || !network.connectsTo(l)) continue;
            return (T)((Network)type.cast(network));
        }
        return null;
    }

    public <T extends Network> List<T> getNetworksFromLocation(Location l, Class<T> type) {
        ArrayList<T> list = new ArrayList<T>();
        for (Network network : this.networks) {
            if (!type.isInstance(network) || !network.connectsTo(l)) continue;
            list.add(type.cast(network));
        }
        return list;
    }

    public void registerNetwork(Network n) {
        this.networks.add(n);
    }

    public void unregisterNetwork(Network n) {
        this.networks.remove(n);
    }

    public void handleAllNetworkLocationUpdate(Location l) {
        for (Network n : this.getNetworksFromLocation(l, Network.class)) {
            n.handleLocationUpdate(l);
        }
    }
}

