/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.multiblocks;

import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunMachine;
import me.mrCookieSlime.Slimefun.Objects.handlers.MultiBlockInteractionHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class MultiBlockMachine
extends SlimefunMachine {
    private static final BlockFace[] outputFaces = new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};

    public MultiBlockMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger) {
        super(category, item, id, recipe, machineRecipes, trigger);
    }

    public MultiBlockMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger, String[] keys, Object[] values) {
        super(category, item, id, recipe, machineRecipes, trigger, keys, values);
    }

    @Override
    public void register() {
        this.register(true, this.getInteractionHandler());
    }

    protected MultiBlockInteractionHandler getInteractionHandler() {
        return (p, mb, b) -> {
            if (mb == this.getMultiBlock()) {
                if (!this.isDisabled() && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES) && Slimefun.hasUnlocked(p, this, true)) {
                    this.onInteract(p, b);
                }
                return true;
            }
            return false;
        };
    }

    public abstract void onInteract(Player var1, Block var2);

    protected Inventory findOutputInventory(ItemStack adding, Block dispBlock, Inventory dispInv) {
        return this.findOutputInventory(adding, dispBlock, dispInv, dispInv);
    }

    protected Inventory findOutputInventory(ItemStack product, Block dispBlock, Inventory dispInv, Inventory placeCheckerInv) {
        Inventory outputInv = this.findOutputChest(dispBlock, product);
        if (outputInv == null && InvUtils.fits(placeCheckerInv, product, new int[0])) {
            return dispInv;
        }
        return outputInv;
    }

    protected Inventory findOutputChest(Block b, ItemStack output) {
        for (BlockFace face : outputFaces) {
            Inventory inv;
            String id;
            Block potentialOutput = b.getRelative(face);
            if (potentialOutput.getType() != Material.CHEST || (id = BlockStorage.checkID(potentialOutput)) == null || !id.equals("OUTPUT_CHEST") || !InvUtils.fits(inv = ((Chest)potentialOutput.getState()).getInventory(), output, new int[0])) continue;
            return inv;
        }
        return null;
    }
}

