/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.GPS;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.CSCoreLibPlugin.general.Particles.MC_1_8.ParticleEffect;
import me.mrCookieSlime.CSCoreLibPlugin.general.World.TitleBuilder;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TeleportationSequence {
    public static Set<UUID> players = new HashSet<UUID>();

    public static void start(UUID uuid, int complexity, Location source, Location destination, boolean resistance) {
        players.add(uuid);
        TeleportationSequence.updateProgress(uuid, TeleportationSequence.getSpeed(complexity, source, destination), 1, source, destination, resistance);
    }

    public static int getSpeed(int complexity, Location source, Location destination) {
        int speed = complexity / 200;
        if (speed > 50) {
            speed = 50;
        }
        return (speed -= TeleportationSequence.distance(source, destination) / 200) < 1 ? 1 : speed;
    }

    private static int distance(Location source, Location destination) {
        if (source.getWorld().getName().equals(destination.getWorld().getName())) {
            int distance = (int)source.distance(destination);
            return distance > 8000 ? 8000 : distance;
        }
        return 8000;
    }

    private static boolean isValid(Player p, Location source) {
        if (p == null) {
            return false;
        }
        return !(p.getLocation().distance(source) > 1.4);
    }

    private static void cancel(UUID uuid, Player p) {
        players.remove(uuid);
        if (p != null) {
            try {
                TitleBuilder title = (TitleBuilder)new TitleBuilder(20, 60, 20).addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&4Teleportation cancelled"));
                TitleBuilder subtitle = (TitleBuilder)new TitleBuilder(20, 60, 20).addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&40%"));
                title.send(TitleBuilder.TitleType.TITLE, new Player[]{p});
                subtitle.send(TitleBuilder.TitleType.SUBTITLE, new Player[]{p});
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private static void updateProgress(final UUID uuid, final int speed, final int progress, final Location source, final Location destination, final boolean resistance) {
        block6: {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (TeleportationSequence.isValid(p, source)) {
                try {
                    if (progress > 99) {
                        TitleBuilder title = (TitleBuilder)new TitleBuilder(20, 60, 20).addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3Teleported!"));
                        TitleBuilder subtitle = (TitleBuilder)new TitleBuilder(20, 60, 20).addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b100%"));
                        title.send(TitleBuilder.TitleType.TITLE, new Player[]{p});
                        subtitle.send(TitleBuilder.TitleType.SUBTITLE, new Player[]{p});
                        p.teleport(destination);
                        if (resistance) {
                            p.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 600, 20));
                            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b&lYou have been given 30 Seconds of Invulnerability!"));
                        }
                        ParticleEffect.PORTAL.display(new Location(destination.getWorld(), destination.getX(), destination.getY() + 1.0, destination.getZ()), 0.2f, 0.8f, 0.2f, 1.0f, progress * 2);
                        destination.getWorld().playSound(destination, Sound.ENTITY_BLAZE_DEATH, 2.0f, 1.4f);
                        players.remove(uuid);
                        break block6;
                    }
                    TitleBuilder title = (TitleBuilder)new TitleBuilder(0, 60, 0).addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3Teleporting..."));
                    TitleBuilder subtitle = (TitleBuilder)new TitleBuilder(0, 60, 0).addText(ChatColor.translateAlternateColorCodes((char)'&', (String)("&b" + progress + "%")));
                    title.send(TitleBuilder.TitleType.TITLE, new Player[]{p});
                    subtitle.send(TitleBuilder.TitleType.SUBTITLE, new Player[]{p});
                    ParticleEffect.PORTAL.display(source, 0.2f, 0.8f, 0.2f, 1.0f, progress * 2);
                    source.getWorld().playSound(source, Sound.UI_BUTTON_CLICK, 1.7f, 0.6f);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

                        @Override
                        public void run() {
                            TeleportationSequence.updateProgress(uuid, speed, progress + speed, source, destination, resistance);
                        }
                    }, 10L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                TeleportationSequence.cancel(uuid, p);
            }
        }
    }
}

