/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import java.util.HashMap;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MetricsService
extends Metrics {
    public MetricsService(SlimefunPlugin plugin) {
        super((Plugin)plugin);
        this.addCustomChart(new Metrics.SimplePie("auto_updates", () -> SlimefunPlugin.getCfg().getBoolean("options.auto-update") ? "enabled" : "disabled"));
        this.addCustomChart(new Metrics.SimplePie("resourcepack", () -> {
            String version = SlimefunPlugin.getItemTextureService().getVersion();
            if (version != null && version.startsWith("v")) {
                return version + " (Official)";
            }
            if (SlimefunPlugin.getItemTextureService().isActive()) {
                return "Custom / Modified";
            }
            return "None";
        }));
        this.addCustomChart(new Metrics.SimplePie("branch", () -> {
            if (plugin.getDescription().getVersion().startsWith("DEV - ")) {
                return "master";
            }
            if (plugin.getDescription().getVersion().startsWith("RC - ")) {
                return "stable";
            }
            return "Unknown";
        }));
        this.addCustomChart(new Metrics.SimplePie("language", () -> {
            Language language = SlimefunPlugin.getLocal().getDefaultLanguage();
            return language.getID();
        }));
        this.addCustomChart(new Metrics.AdvancedPie("player_languages", () -> {
            HashMap<String, Integer> languages = new HashMap<String, Integer>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                Language lang = SlimefunPlugin.getLocal().getLanguage(p);
                languages.merge(lang.getID(), 1, Integer::sum);
            }
            return languages;
        }));
    }
}

