/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SeasonalCategory;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Category {
    private final ItemStack item;
    private final List<SlimefunItem> items;
    private final int tier;

    public Category(ItemStack item) {
        this(item, 3);
    }

    public Category(ItemStack item, int tier) {
        this.item = item;
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        this.item.setItemMeta(meta);
        this.items = new ArrayList<SlimefunItem>();
        this.tier = tier;
    }

    @Deprecated
    public static List<Category> list() {
        return SlimefunPlugin.getRegistry().getEnabledCategories();
    }

    public void register() {
        if (this instanceof SeasonalCategory) {
            if (((SeasonalCategory)this).isUnlocked()) {
                SlimefunPlugin.getRegistry().getEnabledCategories().add(this);
                Collections.sort(SlimefunPlugin.getRegistry().getEnabledCategories(), Comparator.comparingInt(Category::getTier));
            }
        } else {
            SlimefunPlugin.getRegistry().getEnabledCategories().add(this);
            Collections.sort(SlimefunPlugin.getRegistry().getEnabledCategories(), Comparator.comparingInt(Category::getTier));
        }
    }

    public void add(SlimefunItem item) {
        this.items.add(item);
    }

    public ItemStack getItem() {
        return this.item.clone();
    }

    public ItemStack getItem(Player p) {
        return new CustomItem(this.item, meta -> meta.setLore(Arrays.asList("", ChatColor.GREEN + "> " + SlimefunPlugin.getLocal().getMessage(p, "guide.tooltips.open-category"))));
    }

    public List<SlimefunItem> getItems() {
        return this.items;
    }

    public int getTier() {
        return this.tier;
    }

    public String toString() {
        return "Slimefun Category {" + this.item.getItemMeta().getDisplayName() + ",tier=" + this.tier + "}";
    }
}

