/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide;

import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideLayout;
import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunGuide;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public final class GuideSettings {
    public static final NamespacedKey FIREWORKS_KEY = new NamespacedKey((Plugin)SlimefunPlugin.instance, "research_fireworks");
    private static final int[] BACKGROUND_SLOTS = new int[]{1, 3, 5, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 48, 50, 52, 53};

    private GuideSettings() {
    }

    public static void openSettings(Player p, ItemStack guide) {
        ChestMenu menu = new ChestMenu(SlimefunPlugin.getLocal().getMessage(p, "guide.title.settings"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f));
        for (int slot : BACKGROUND_SLOTS) {
            menu.addItem(slot, ChestMenuUtils.getBackground());
            menu.addMenuClickHandler(slot, ChestMenuUtils.getEmptyClickHandler());
        }
        GuideSettings.addMenubar(menu, guide);
        GuideSettings.addConfigurableOptions(p, menu, guide);
        menu.open(new Player[]{p});
    }

    private static void addMenubar(ChestMenu menu, ItemStack guide) {
        menu.addItem(0, (ItemStack)new CustomItem(GuideSettings.getItem(SlimefunGuideLayout.CHEST), "&e\u21e6 Back", "", "&7Go back to your Slimefun Guide"), (pl, slot, item, action) -> {
            SlimefunGuide.openGuide(pl, guide);
            return false;
        });
        menu.addItem(2, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTk1MmQyYjNmMzUxYTZiMDQ4N2NjNTlkYjMxYmY1ZjI2NDExMzNlNWJhMDAwNmIxODU3NmU5OTZhMDI5M2U1MiJ9fX0="), "&cCredits", "", "&7Contributors: &e" + SlimefunPlugin.getGitHubService().getContributors().size(), "", "&7Slimefun is an open-source project", "&7and maintained by a large community.", "&7Here you can find them all", "", "&7\u21e8 &eClick to see all of them"), (pl, slot, action, item) -> {
            GuideSettings.openCredits(pl, 0);
            return false;
        });
        menu.addItem(4, (ItemStack)new CustomItem(Material.WRITABLE_BOOK, "&aSlimefun Version", "&7&oThis is very important when reporting bugs!", "", "&7Minecraft Version: &a" + Bukkit.getBukkitVersion(), "&7Slimefun Version: &a" + SlimefunPlugin.getVersion(), "&7CS-CoreLib Version: &a" + CSCoreLib.getLib().getDescription().getVersion()), ChestMenuUtils.getEmptyClickHandler());
        menu.addItem(6, (ItemStack)new CustomItem(Material.COMPARATOR, "&eSource Code", "", "&7Bytes of Code: &6" + NumberUtils.formatBigNumber(SlimefunPlugin.getGitHubService().getCodeSize()), "&7Last Activity: &a" + NumberUtils.timeDelta(SlimefunPlugin.getGitHubService().getLastUpdate()) + " ago", "&7Forks: &e" + SlimefunPlugin.getGitHubService().getForks(), "&7Stars: &e" + SlimefunPlugin.getGitHubService().getStars(), "", "&7&oSlimefun 4 is a community project,", "&7&othe source code is available on GitHub", "&7&oand if you want to keep this Plugin alive,", "&7&othen please consider contributing to it", "", "&7\u21e8 &eClick to go to GitHub"), (pl, slot, item, action) -> {
            pl.closeInventory();
            ChatUtils.sendURL((CommandSender)pl, "https://github.com/TheBusyBiscuit/Slimefun4");
            return false;
        });
        menu.addItem(8, (ItemStack)new CustomItem(Material.KNOWLEDGE_BOOK, "&3Slimefun Wiki", "", "&7Do you need help with an Item or machine?", "&7You cannot figure out what to do?", "&7Check out our community-maintained Wiki", "&7and become one of our Editors!", "", "&7\u21e8 &eClick to go to the official Slimefun Wiki"), (pl, slot, item, action) -> {
            pl.closeInventory();
            ChatUtils.sendURL((CommandSender)pl, "https://github.com/TheBusyBiscuit/Slimefun4/wiki");
            return false;
        });
        menu.addItem(47, (ItemStack)new CustomItem(Material.BOOKSHELF, "&3Slimefun Addons", "", "&7Slimefun is huge. But its addons are what makes", "&7this plugin truly shine. Go check them out, some", "&7of them may be exactly what you were missing out on!", "", "&7Installed on this Server: &b" + Slimefun.getInstalledAddons().size(), "", "&7\u21e8 &eClick to see all available Addons for Slimefun4"), (pl, slot, item, action) -> {
            pl.closeInventory();
            ChatUtils.sendURL((CommandSender)pl, "https://github.com/TheBusyBiscuit/Slimefun4/wiki/Addons");
            return false;
        });
        menu.addItem(49, (ItemStack)new CustomItem(Material.REDSTONE_TORCH, "&4Report a bug", "", "&7Open Issues: &a" + SlimefunPlugin.getGitHubService().getIssues(), "&7Pending Pull Requests: &a" + SlimefunPlugin.getGitHubService().getPullRequests(), "", "&7\u21e8 &eClick to go to the Slimefun4 Bug Tracker"), (pl, slot, item, action) -> {
            pl.closeInventory();
            ChatUtils.sendURL((CommandSender)pl, "https://github.com/TheBusyBiscuit/Slimefun4/issues");
            return false;
        });
        menu.addItem(51, (ItemStack)new CustomItem(Material.TOTEM_OF_UNDYING, "&cSoon", "", "&7Something will be added here later..."), (pl, slot, item, action) -> false);
    }

    private static void addConfigurableOptions(Player p, ChestMenu menu, ItemStack guide) {
        Language language;
        int i = 19;
        if (SlimefunManager.isItemSimilar(guide, GuideSettings.getItem(SlimefunGuideLayout.CHEST), true)) {
            if (p.hasPermission("slimefun.cheat.items")) {
                menu.addItem(i, (ItemStack)new CustomItem(Material.CHEST, "&7Guide Layout: &eChest GUI", "", "&aChest GUI", "&7Book GUI", "&7Cheat Sheet", "", "&7\u21e8 &eClick to change your layout"));
                menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(GuideSettings.getItem(SlimefunGuideLayout.BOOK));
                    GuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            } else {
                menu.addItem(i, (ItemStack)new CustomItem(Material.CHEST, "&7Guide Layout: &eChest GUI", "", "&aChest GUI", "&7Book GUI", "", "&7\u21e8 &eClick to change your layout"));
                menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(GuideSettings.getItem(SlimefunGuideLayout.BOOK));
                    GuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            }
            ++i;
        } else if (SlimefunManager.isItemSimilar(guide, GuideSettings.getItem(SlimefunGuideLayout.BOOK), true)) {
            if (p.hasPermission("slimefun.cheat.items")) {
                menu.addItem(i, (ItemStack)new CustomItem(Material.BOOK, "&7Guide Layout: &eBook GUI", "", "&7Chest GUI", "&aBook GUI", "&7Cheat Sheet", "", "&7\u21e8 &eClick to change your layout"));
                menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(GuideSettings.getItem(SlimefunGuideLayout.CHEAT_SHEET));
                    GuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            } else {
                menu.addItem(i, (ItemStack)new CustomItem(Material.BOOK, "&7Guide Layout: &eBook GUI", "", "&7Chest GUI", "&aBook GUI", "", "&7\u21e8 &eClick to change your layout"));
                menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(GuideSettings.getItem(SlimefunGuideLayout.CHEST));
                    GuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            }
            ++i;
        } else if (SlimefunManager.isItemSimilar(guide, GuideSettings.getItem(SlimefunGuideLayout.CHEAT_SHEET), true)) {
            menu.addItem(i, (ItemStack)new CustomItem(Material.COMMAND_BLOCK, "&7Guide Layout: &eCheat Sheet", "", "&7Chest GUI", "&7Book GUI", "&aCheat Sheet", "", "&7\u21e8 &eClick to change your layout"));
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                pl.getInventory().setItemInMainHand(GuideSettings.getItem(SlimefunGuideLayout.CHEST));
                GuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                return false;
            });
            ++i;
        }
        if (SlimefunPlugin.getSettings().researchFireworksEnabled) {
            if (!PersistentDataAPI.hasByte((PersistentDataHolder)p, FIREWORKS_KEY) || PersistentDataAPI.getByte((PersistentDataHolder)p, FIREWORKS_KEY) == 1) {
                menu.addItem(i, (ItemStack)new CustomItem(Material.FIREWORK_ROCKET, "&bFireworks: &aYes", "", "&7When researching items, you will", "&7be presented with a big firework.", "", "&7\u21e8 &eClick to disable your fireworks"), (pl, slot, item, action) -> {
                    PersistentDataAPI.setByte((PersistentDataHolder)pl, FIREWORKS_KEY, (byte)0);
                    GuideSettings.openSettings(pl, guide);
                    return false;
                });
            } else {
                menu.addItem(i, (ItemStack)new CustomItem(Material.FIREWORK_ROCKET, "&bFireworks: &4No", "", "&7When researching items, you will", "&7not be presented with a big firework.", "", "&7\u21e8 &eClick to enable your fireworks"), (pl, slot, item, action) -> {
                    PersistentDataAPI.setByte((PersistentDataHolder)pl, FIREWORKS_KEY, (byte)1);
                    GuideSettings.openSettings(pl, guide);
                    return false;
                });
            }
            ++i;
        }
        String languageName = (language = SlimefunPlugin.getLocal().getLanguage(p)).isDefault() ? SlimefunPlugin.getLocal().getMessage(p, "languages.default") + ChatColor.DARK_GRAY + " (" + language.getName(p) + ")" : SlimefunPlugin.getLocal().getMessage(p, "languages." + language.getID());
        menu.addItem(i, (ItemStack)new CustomItem(language.getItem(), "&7Selected Language: &a" + languageName, "", "&7You now have the option to change", "&7the language in which Slimefun", "&7will send you messages.", "&7Note that this only translates", "&7messages, not items.", "", "&7\u21e8 &eClick to change your language"), (pl, slot, item, action) -> {
            GuideSettings.openLanguages(pl);
            return false;
        });
    }

    private static void openLanguages(Player p) {
        ChestMenu menu = new ChestMenu(SlimefunPlugin.getLocal().getMessage(p, "guide.title.languages"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f));
        for (int i2 = 0; i2 < 9; ++i2) {
            if (i2 == 1) {
                menu.addItem(1, (ItemStack)new CustomItem(ChestMenuUtils.getBackButton(), "&e\u21e6 Back", "", "&7Go back to the Settings Panel"), (pl, slot, item, action) -> {
                    GuideSettings.openSettings(pl, p.getInventory().getItemInMainHand());
                    return false;
                });
                continue;
            }
            if (i2 == 7) {
                menu.addItem(7, (ItemStack)new CustomItem(SkullItem.fromHash("3edd20be93520949e6ce789dc4f43efaeb28c717ee6bfcbbe02780142f716"), SlimefunPlugin.getLocal().getMessage(p, "guide.languages.translations.name"), "", "&7\u21e8 &e" + SlimefunPlugin.getLocal().getMessage(p, "guide.languages.translations.lore")), (pl, slot, item, action) -> {
                    ChatUtils.sendURL((CommandSender)pl, "https://github.com/TheBusyBiscuit/Slimefun4/wiki/Translating-Slimefun");
                    return false;
                });
                continue;
            }
            menu.addItem(i2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        Language defaultLanguage = SlimefunPlugin.getLocal().getDefaultLanguage();
        menu.addItem(9, (ItemStack)new CustomItem(defaultLanguage.getItem(), ChatColor.GRAY + SlimefunPlugin.getLocal().getMessage(p, "languages.default") + ChatColor.DARK_GRAY + " (" + defaultLanguage.getName(p) + ")", "", "&7\u21e8 &e" + SlimefunPlugin.getLocal().getMessage(p, "guide.languages.select-default")), (pl, i, item, action) -> {
            PersistentDataAPI.remove((PersistentDataHolder)pl, SlimefunPlugin.getLocal().getKey());
            String name = SlimefunPlugin.getLocal().getMessage(p, "languages.default");
            SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "guide.languages.updated", msg -> msg.replace("%lang%", name));
            GuideSettings.openSettings(pl, p.getInventory().getItemInMainHand());
            return false;
        });
        int slot2 = 10;
        for (Language language : SlimefunPlugin.getLocal().getLanguages()) {
            menu.addItem(slot2, (ItemStack)new CustomItem(language.getItem(), ChatColor.GREEN + language.getName(p), "", "&7\u21e8 &e" + SlimefunPlugin.getLocal().getMessage(p, "guide.languages.select")), (pl, i, item, action) -> {
                PersistentDataAPI.setString((PersistentDataHolder)pl, SlimefunPlugin.getLocal().getKey(), language.getID());
                String name = language.getName(pl);
                SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "guide.languages.updated", msg -> msg.replace("%lang%", name));
                GuideSettings.openSettings(pl, p.getInventory().getItemInMainHand());
                return false;
            });
            ++slot2;
        }
        menu.open(new Player[]{p});
    }

    private static void openCredits(Player p, int page) {
        int i;
        ChestMenu menu = new ChestMenu(SlimefunPlugin.getLocal().getMessage(p, "guide.title.credits"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f));
        for (i = 0; i < 9; ++i) {
            if (i != 1) {
                menu.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
                continue;
            }
            menu.addItem(1, (ItemStack)new CustomItem(ChestMenuUtils.getBackButton(), "&e\u21e6 Back", "", "&7Go back to the Settings Panel"));
            menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
                GuideSettings.openSettings(pl, p.getInventory().getItemInMainHand());
                return false;
            });
        }
        for (i = 45; i < 54; ++i) {
            if (i == 46 || i == 52) continue;
            menu.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        ArrayList contributors = new ArrayList(SlimefunPlugin.getGitHubService().getContributors().values());
        contributors.sort(Comparator.comparingInt(Contributor::index));
        int pages = (contributors.size() - 1) / 36 + 1;
        for (int i2 = page * 36; i2 < contributors.size() && i2 < (page + 1) * 36; ++i2) {
            Contributor contributor = (Contributor)contributors.get(i2);
            ItemStack skull = SkullItem.fromBase64(contributor.getTexture());
            SkullMeta meta = (SkullMeta)skull.getItemMeta();
            meta.setDisplayName(contributor.getDisplayName());
            LinkedList<String> lore = new LinkedList<String>();
            lore.add("");
            for (Map.Entry<String, Integer> entry : contributor.getContributions()) {
                String info = entry.getKey();
                if (!info.startsWith("&")) {
                    String[] segments = info.split(",");
                    info = SlimefunPlugin.getLocal().getMessage(p, "guide.credits.roles." + segments[0]);
                    if (segments.length == 2) {
                        info = info + " &7(" + SlimefunPlugin.getLocal().getMessage(p, "languages." + segments[1]) + ")";
                    }
                }
                if (entry.getValue() > 0) {
                    String commits = SlimefunPlugin.getLocal().getMessage(p, "guide.credits." + (entry.getValue() > 1 ? "commits" : "commit"));
                    info = info + " &7(" + entry.getValue() + " " + commits + ")";
                }
                lore.add(ChatColors.color(info));
            }
            if (contributor.getProfile() != null) {
                lore.add("");
                lore.add(ChatColors.color("&7\u21e8 &e") + SlimefunPlugin.getLocal().getMessage(p, "guide.credits.profile-link"));
            }
            meta.setLore(lore);
            skull.setItemMeta((ItemMeta)meta);
            menu.addItem(i2 - page * 36 + 9, skull);
            menu.addMenuClickHandler(i2 - page * 36 + 9, (pl, slot, item, action) -> {
                if (contributor.getProfile() != null) {
                    pl.closeInventory();
                    ChatUtils.sendURL((CommandSender)pl, contributor.getProfile());
                }
                return false;
            });
        }
        menu.addItem(46, ChestMenuUtils.getPreviousButton(p, page + 1, pages));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            if (page > 0) {
                GuideSettings.openCredits(pl, page - 1);
            }
            return false;
        });
        menu.addItem(52, ChestMenuUtils.getNextButton(p, page + 1, pages));
        menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
            if (page + 1 < pages) {
                GuideSettings.openCredits(pl, page + 1);
            }
            return false;
        });
        menu.open(new Player[]{p});
    }

    private static ItemStack getItem(SlimefunGuideLayout layout) {
        return SlimefunGuide.getItem(layout);
    }
}

