/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide;

import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideLayout;
import java.util.LinkedList;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.GuideHandler;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public interface ISlimefunGuide {
    public SlimefunGuideLayout getLayout();

    public ItemStack getItem();

    public void openMainMenu(PlayerProfile var1, boolean var2, int var3);

    public void openCategory(PlayerProfile var1, Category var2, boolean var3, int var4);

    public void openSearch(PlayerProfile var1, String var2, boolean var3, boolean var4);

    public void displayItem(PlayerProfile var1, ItemStack var2, boolean var3);

    public void displayItem(PlayerProfile var1, SlimefunItem var2, boolean var3);

    default public String shorten(String string, String string2) {
        if (ChatColor.stripColor((String)(string + string2)).length() > 19) {
            return (string + ChatColor.stripColor((String)string2)).substring(0, 18) + "...";
        }
        return string + ChatColor.stripColor((String)string2);
    }

    default public Object getLastEntry(PlayerProfile profile, boolean remove) {
        LinkedList<Object> history = profile.getGuideHistory();
        if (remove && !history.isEmpty()) {
            history.removeLast();
        }
        return history.isEmpty() ? null : history.getLast();
    }

    default public void handleHistory(PlayerProfile profile, Object last, boolean survival) {
        if (last == null) {
            this.openMainMenu(profile, survival, 1);
        } else if (last instanceof Category) {
            this.openCategory(profile, (Category)last, survival, 1);
        } else if (last instanceof SlimefunItem) {
            this.displayItem(profile, (SlimefunItem)last, false);
        } else if (last instanceof GuideHandler) {
            ((GuideHandler)last).run(profile.getPlayer(), survival, this.getLayout() == SlimefunGuideLayout.BOOK);
        } else if (last instanceof String) {
            this.openSearch(profile, (String)last, survival, false);
        } else {
            this.displayItem(profile, (ItemStack)last, false);
        }
    }
}

