/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem;

import io.github.thebusybiscuit.slimefun4.api.items.Placeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ChargableItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ChargedItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.DamagableChargableItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ItemState;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunBackpack;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunMachine;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.VanillaItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.ancient_altar.AltarRecipe;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.energy.EnergyNet;
import me.mrCookieSlime.Slimefun.api.energy.EnergyNetComponent;
import me.mrCookieSlime.Slimefun.api.energy.EnergyTicker;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.OptionalMap;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SlimefunItem
implements Placeable {
    private String id;
    private ItemState state;
    private ItemStack item;
    private Category category;
    private ItemStack[] recipe;
    private RecipeType recipeType;
    protected ItemStack recipeOutput;
    private Research research;
    protected boolean enchantable = true;
    protected boolean disenchantable = true;
    protected boolean hidden = false;
    protected boolean useableInWorkbench = false;
    private boolean addon = false;
    private String permission = "";
    private List<String> noPermissionTooltip;
    private final OptionalMap<Class<? extends ItemHandler>, ItemHandler> itemhandlers = new OptionalMap(HashMap::new);
    private boolean ticking = false;
    private BlockTicker blockTicker;
    private EnergyTicker energyTicker;
    private String[] keys;
    private Object[] values;
    private String wiki = null;

    public SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe) {
        this(category, item, id, recipeType, recipe, null);
    }

    public SlimefunItem(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(category, item, recipeType, recipe, null);
    }

    public SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        this(category, item, id, recipeType, recipe, recipeOutput, null, null);
    }

    public SlimefunItem(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        this(category, item, recipeType, recipe, recipeOutput, null, null);
    }

    public SlimefunItem(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, String[] keys, Object[] values) {
        this(category, item, recipeType, recipe, null, keys, values);
    }

    public SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, String[] keys, Object[] values) {
        this(category, item, id, recipeType, recipe, null, keys, values);
    }

    public SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, boolean hidden) {
        this(category, item, id, recipeType, recipe);
        this.hidden = hidden;
    }

    public SlimefunItem(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput, String[] keys, Object[] values) {
        this(category, item, item.getItemID(), recipeType, recipe, recipeOutput, keys, values);
    }

    public SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput, String[] keys, Object[] values) {
        this.category = category;
        this.item = item;
        this.id = id;
        this.recipeType = recipeType;
        this.recipe = recipe;
        this.recipeOutput = recipeOutput;
        this.keys = keys;
        this.values = values;
    }

    public String getID() {
        return this.id;
    }

    public ItemState getState() {
        return this.state;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Category getCategory() {
        return this.category;
    }

    public ItemStack[] getRecipe() {
        return this.recipe;
    }

    public RecipeType getRecipeType() {
        return this.recipeType;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public Research getResearch() {
        return this.research;
    }

    public boolean isEnchantable() {
        return this.enchantable;
    }

    public boolean isDisenchantable() {
        return this.disenchantable;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Deprecated
    public boolean isReplacing() {
        return this.useableInWorkbench;
    }

    public boolean isAddonItem() {
        return this.addon;
    }

    public String getPermission() {
        return this.permission;
    }

    public List<String> getNoPermissionTooltip() {
        return this.noPermissionTooltip;
    }

    public BlockTicker getBlockTicker() {
        return this.blockTicker;
    }

    public EnergyTicker getEnergyTicker() {
        return this.energyTicker;
    }

    public String[] listKeys() {
        return this.keys;
    }

    public Object[] listValues() {
        return this.values;
    }

    public boolean isDisabled() {
        return this.state != ItemState.ENABLED;
    }

    public void register() {
        this.register(false);
    }

    public void register(boolean slimefun) {
        this.addon = !slimefun;
        try {
            this.preRegister();
            if (SlimefunPlugin.getUtilities().itemIDs.containsKey(this.id)) {
                throw new IllegalArgumentException("ID \"" + this.id + "\" already exists");
            }
            if (this.recipe.length < 9) {
                this.recipe = new ItemStack[]{null, null, null, null, null, null, null, null, null};
            }
            SlimefunPlugin.getUtilities().allItems.add(this);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".enabled", true);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".can-be-used-in-workbenches", this.useableInWorkbench);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".hide-in-guide", this.hidden);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".allow-enchanting", this.enchantable);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".allow-disenchanting", this.disenchantable);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".required-permission", this.permission);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".no-permission-tooltip", new String[]{"&4&lLOCKED", "", "&rYou do not have Permission", "&rto access this Item"});
            if (this.keys != null && this.values != null) {
                for (int i = 0; i < this.keys.length; ++i) {
                    SlimefunPlugin.getItemCfg().setDefaultValue(this.id + '.' + this.keys[i], this.values[i]);
                }
            }
            for (World world : Bukkit.getWorlds()) {
                SlimefunPlugin.getWhitelist().setDefaultValue(world.getName() + ".enabled", true);
                SlimefunPlugin.getWhitelist().setDefaultValue(world.getName() + ".enabled-items." + this.id, true);
            }
            if (this.ticking && !SlimefunPlugin.getCfg().getBoolean("URID.enable-tickers")) {
                this.state = ItemState.DISABLED;
                return;
            }
            if (SlimefunPlugin.getItemCfg().getBoolean(this.id + ".enabled")) {
                if (!Category.list().contains(this.category)) {
                    this.category.register();
                }
                this.state = ItemState.ENABLED;
                this.useableInWorkbench = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".can-be-used-in-workbenches");
                this.hidden = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".hide-in-guide");
                this.enchantable = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".allow-enchanting");
                this.disenchantable = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".allow-disenchanting");
                this.permission = SlimefunPlugin.getItemCfg().getString(this.id + ".required-permission");
                this.noPermissionTooltip = SlimefunPlugin.getItemCfg().getStringList(this.id + ".no-permission-tooltip");
                SlimefunPlugin.getUtilities().enabledItems.add(this);
                if (slimefun) {
                    ++SlimefunPlugin.getUtilities().vanillaItems;
                }
                SlimefunPlugin.getUtilities().itemIDs.put(this.id, this);
                this.create();
                for (ItemHandler handler : this.itemhandlers.values()) {
                    if (this.areItemHandlersPrivate()) continue;
                    Set<ItemHandler> handlerset = SlimefunItem.getHandlers(handler.getIdentifier());
                    handlerset.add(handler);
                }
                if (SlimefunPlugin.getSettings().printOutLoading) {
                    Slimefun.getLogger().log(Level.INFO, "Loaded Item \"{0}\"", this.id);
                }
            } else {
                this.state = this instanceof VanillaItem ? ItemState.VANILLA : ItemState.DISABLED;
            }
            this.postRegister();
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.WARNING, "Registering the Item '" + this.id + "' for Slimefun " + SlimefunPlugin.getVersion() + " has failed", x);
        }
    }

    public static List<SlimefunItem> list() {
        return SlimefunPlugin.getUtilities().enabledItems;
    }

    public void bindToResearch(Research r) {
        if (r != null) {
            r.getAffectedItems().add(this);
        }
        this.research = r;
    }

    public void setRecipe(ItemStack[] recipe) {
        this.recipe = recipe;
    }

    public void setRecipeType(RecipeType type) {
        this.recipeType = type;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public void setRecipeOutput(ItemStack output) {
        this.recipeOutput = output;
    }

    @Deprecated
    public void setReplacing(boolean replacing) {
        this.useableInWorkbench = replacing;
    }

    public boolean isUseableInWorkbench() {
        return this.useableInWorkbench;
    }

    public static SlimefunItem getByID(String id) {
        return SlimefunPlugin.getUtilities().itemIDs.get(id);
    }

    public static SlimefunItem getByItem(ItemStack item) {
        Optional<String> itemID;
        if (item == null) {
            return null;
        }
        if (item instanceof SlimefunItemStack) {
            return SlimefunItem.getByID(((SlimefunItemStack)item).getItemID());
        }
        if (item.hasItemMeta() && (itemID = SlimefunPlugin.getItemDataService().getItemData(item)).isPresent()) {
            return SlimefunItem.getByID(itemID.get());
        }
        for (SlimefunItem sfi : SlimefunPlugin.getUtilities().enabledItems) {
            if (!sfi.isItem(item)) continue;
            SlimefunPlugin.getItemDataService().setItemData(item, sfi.getID());
            return sfi;
        }
        if (SlimefunManager.isItemSimilar(item, SlimefunItems.BROKEN_SPAWNER, false)) {
            return SlimefunItem.getByID("BROKEN_SPAWNER");
        }
        if (SlimefunManager.isItemSimilar(item, SlimefunItems.REPAIRED_SPAWNER, false)) {
            return SlimefunItem.getByID("REINFORCED_SPAWNER");
        }
        return null;
    }

    public boolean isItem(ItemStack item) {
        Optional<String> itemID;
        if (item == null) {
            return false;
        }
        if (item.hasItemMeta() && (itemID = SlimefunPlugin.getItemDataService().getItemData(item)).isPresent()) {
            return this.getID().equals(itemID.get());
        }
        if (this instanceof ChargableItem && SlimefunManager.isItemSimilar(item, this.item, false)) {
            return true;
        }
        if (this instanceof DamagableChargableItem && SlimefunManager.isItemSimilar(item, this.item, false)) {
            return true;
        }
        if (this instanceof ChargedItem && SlimefunManager.isItemSimilar(item, this.item, false)) {
            return true;
        }
        if (this instanceof SlimefunBackpack && SlimefunManager.isItemSimilar(item, this.item, false)) {
            return true;
        }
        return SlimefunManager.isItemSimilar(item, this.item, true);
    }

    public void load() {
        try {
            SlimefunItem machine;
            if (!this.hidden) {
                this.category.add(this);
            }
            ItemStack output = this.item.clone();
            if (this.recipeOutput != null) {
                output = this.recipeOutput.clone();
            }
            if (this.recipeType.toItem().isSimilar(RecipeType.MOB_DROP.toItem())) {
                String mob = ChatColor.stripColor((String)this.recipe[4].getItemMeta().getDisplayName()).toUpperCase().replace(' ', '_');
                try {
                    EntityType entity = EntityType.valueOf((String)mob);
                    List dropping = SlimefunPlugin.getUtilities().drops.getOrDefault(entity, new ArrayList());
                    dropping.add(output);
                    SlimefunPlugin.getUtilities().drops.put(entity, dropping);
                }
                catch (Exception x) {
                    Slimefun.getLogger().log(Level.WARNING, "An Exception occured when setting a Drop for the Mob: " + mob + " (" + x.getClass().getSimpleName() + ")");
                }
            } else if (this.recipeType.toItem().isSimilar(RecipeType.ANCIENT_ALTAR.toItem())) {
                new AltarRecipe(Arrays.asList(this.recipe), output);
            } else if (this.recipeType.getMachine() != null && (machine = SlimefunItem.getByID(this.recipeType.getMachine().getID())) instanceof SlimefunMachine) {
                ((SlimefunMachine)SlimefunItem.getByID(this.recipeType.getMachine().getID())).addRecipe(this.recipe, output);
            }
            this.install();
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.WARNING, "Item Setup failed: " + this.id + " (" + x.getClass().getSimpleName() + ")");
        }
    }

    public static ItemState getState(ItemStack item) {
        for (SlimefunItem i : SlimefunPlugin.getUtilities().allItems) {
            if (!i.isItem(item)) continue;
            return i.getState();
        }
        return ItemState.ENABLED;
    }

    public static boolean isDisabled(ItemStack item) {
        for (SlimefunItem i : SlimefunPlugin.getUtilities().allItems) {
            if (!i.isItem(item)) continue;
            return i.isDisabled();
        }
        return false;
    }

    @Deprecated
    public void install() {
    }

    @Deprecated
    public void create() {
    }

    public void addItemHandler(ItemHandler ... handlers) {
        for (ItemHandler handler : handlers) {
            this.itemhandlers.put(handler.getIdentifier(), handler);
            if (handler instanceof BlockTicker) {
                this.ticking = true;
                SlimefunPlugin.getUtilities().tickers.add(this.getID());
                this.blockTicker = (BlockTicker)handler;
                continue;
            }
            if (!(handler instanceof EnergyTicker)) continue;
            this.energyTicker = (EnergyTicker)handler;
            EnergyNet.registerComponent(this.getID(), EnergyNetComponent.SOURCE);
        }
    }

    public void register(boolean vanilla, ItemHandler ... handlers) {
        this.addItemHandler(handlers);
        this.register(vanilla);
    }

    public void register(ItemHandler ... handlers) {
        this.addItemHandler(handlers);
        this.register(false);
    }

    public void register(boolean vanilla, SlimefunBlockHandler handler) {
        SlimefunPlugin.getUtilities().blockHandlers.put(this.getID(), handler);
        this.register(vanilla);
    }

    public void register(SlimefunBlockHandler handler) {
        SlimefunPlugin.getUtilities().blockHandlers.put(this.getID(), handler);
        this.register(false);
    }

    public static Set<ItemHandler> getHandlers(Class<? extends ItemHandler> identifier) {
        return SlimefunPlugin.getUtilities().itemHandlers.computeIfAbsent(identifier, c -> new HashSet());
    }

    @Deprecated
    public static void setRadioactive(ItemStack item) {
        SlimefunPlugin.getUtilities().radioactiveItems.add(item);
    }

    public static ItemStack getItem(String id) {
        SlimefunItem item = SlimefunItem.getByID(id);
        return item != null ? item.getItem() : null;
    }

    public void registerChargeableBlock(int capacity) {
        this.registerChargeableBlock(false, capacity);
    }

    public void registerChargeableBlock(boolean slimefun, int capacity) {
        this.register(slimefun);
        ChargableBlock.registerChargableBlock(this.id, capacity, true);
        EnergyNet.registerComponent(this.id, EnergyNetComponent.CONSUMER);
    }

    public void registerUnrechargeableBlock(boolean slimefun, int capacity) {
        this.register(slimefun);
        ChargableBlock.registerChargableBlock(this.id, capacity, false);
    }

    public void registerBlockCapacitor(boolean slimefun, int capacity) {
        this.register(slimefun);
        ChargableBlock.registerCapacitor(this.id, capacity);
    }

    public void registerEnergyDistributor(boolean slimefun) {
        this.register(slimefun);
        EnergyNet.registerComponent(this.id, EnergyNetComponent.DISTRIBUTOR);
    }

    public void registerDistibutingCapacitor(boolean slimefun, int capacity) {
        this.register(slimefun);
        EnergyNet.registerComponent(this.id, EnergyNetComponent.DISTRIBUTOR);
        ChargableBlock.registerCapacitor(this.id, capacity);
    }

    public void preRegister() {
    }

    public void postRegister() {
    }

    protected void setItem(ItemStack stack) {
        this.item = stack;
    }

    public static boolean isTicking(String item) {
        return SlimefunPlugin.getUtilities().tickers.contains(item);
    }

    public static void registerBlockHandler(String id, SlimefunBlockHandler handler) {
        SlimefunPlugin.getUtilities().blockHandlers.put(id, handler);
    }

    public void registerChargeableBlock(boolean vanilla, int capacity, ItemHandler ... handlers) {
        this.addItemHandler(handlers);
        this.registerChargeableBlock(vanilla, capacity);
    }

    public void addWikipage(String page) {
        this.wiki = "https://github.com/TheBusyBiscuit/Slimefun4/wiki/" + page;
    }

    public boolean hasWiki() {
        return this.wiki != null;
    }

    public String getWiki() {
        return this.wiki;
    }

    public final String getItemName() {
        return ItemUtils.getItemName(this.item);
    }

    public Collection<ItemHandler> getHandlers() {
        return this.itemhandlers.values();
    }

    protected boolean areItemHandlersPrivate() {
        return false;
    }

    public <T extends ItemHandler> boolean callItemHandler(Class<T> c, Consumer<T> callable) {
        Optional<ItemHandler> handler = this.itemhandlers.get(c);
        if (handler.isPresent()) {
            callable.accept(c.cast(handler.get()));
            return true;
        }
        return false;
    }

    public boolean isTicking() {
        return this.ticking;
    }

    public String toString() {
        return "SlimefunItem: " + this.id + " (" + (Object)((Object)this.state) + ", vanilla=" + !this.addon + ")";
    }

    @Override
    public Collection<ItemStack> getDrops() {
        return Arrays.asList(this.item.clone());
    }

    @Override
    public Collection<ItemStack> getDrops(Player p) {
        return this.getDrops();
    }
}

