/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thebusybiscuit.slimefun4.core.services.github.ContributionsConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubTask;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.plugin.Plugin;

public class GitHubService {
    private final String repository;
    private final Set<GitHubConnector> connectors;
    private final ConcurrentMap<String, Contributor> contributors;
    private boolean logging = false;
    private int issues = 0;
    private int pullRequests = 0;
    private int forks = 0;
    private int stars = 0;
    private int codeBytes = 0;
    private Date lastUpdate = new Date();

    public GitHubService(String repository) {
        this.repository = repository;
        this.connectors = new HashSet<GitHubConnector>();
        this.contributors = new ConcurrentHashMap<String, Contributor>();
    }

    public void start(Plugin plugin) {
        plugin.getServer().getScheduler().runTaskTimerAsynchronously(plugin, (Runnable)new GitHubTask(this), 80L, 72000L);
    }

    private void addDefaultContributors() {
        Contributor thebusybiscuit = new Contributor("TheBusyBiscuit", "https://github.com/TheBusyBiscuit");
        thebusybiscuit.setContribution("&4Original Creator", 0);
        this.contributors.put(thebusybiscuit.getName(), thebusybiscuit);
        Contributor fuffles = new Contributor("Fuffles_");
        fuffles.setContribution("&dSkull Texture Artist", 0);
        this.contributors.put(fuffles.getName(), fuffles);
    }

    public void connect(boolean logging) {
        this.logging = logging;
        this.addDefaultContributors();
        this.connectors.add(new ContributionsConnector(this, "code", this.repository, "developer"));
        this.connectors.add(new ContributionsConnector(this, "wiki", "TheBusyBiscuit/Slimefun4-wiki", "wiki"));
        this.connectors.add(new ContributionsConnector(this, "resourcepack", "TheBusyBiscuit/Slimefun4-Resourcepack", "resourcepack"));
        this.connectors.add(new GitHubConnector(this){

            @Override
            public void onSuccess(JsonElement element) {
                JsonObject object = element.getAsJsonObject();
                GitHubService.this.forks = object.get("forks").getAsInt();
                GitHubService.this.stars = object.get("stargazers_count").getAsInt();
                GitHubService.this.lastUpdate = NumberUtils.parseGitHubDate(object.get("pushed_at").getAsString());
            }

            @Override
            public String getRepository() {
                return GitHubService.this.repository;
            }

            @Override
            public String getFileName() {
                return "repo";
            }

            @Override
            public String getURLSuffix() {
                return "";
            }
        });
        this.connectors.add(new GitHubConnector(this){

            @Override
            public void onSuccess(JsonElement element) {
                JsonArray array = element.getAsJsonArray();
                int issueCount = 0;
                int prCount = 0;
                for (JsonElement elem : array) {
                    JsonObject obj = elem.getAsJsonObject();
                    if (obj.has("pull_request")) {
                        ++prCount;
                        continue;
                    }
                    ++issueCount;
                }
                GitHubService.this.issues = issueCount;
                GitHubService.this.pullRequests = prCount;
            }

            @Override
            public String getRepository() {
                return GitHubService.this.repository;
            }

            @Override
            public String getFileName() {
                return "issues";
            }

            @Override
            public String getURLSuffix() {
                return "/issues";
            }
        });
        this.connectors.add(new GitHubConnector(this){

            @Override
            public void onSuccess(JsonElement element) {
                JsonObject object = element.getAsJsonObject();
                GitHubService.this.codeBytes = object.get("Java").getAsInt();
            }

            @Override
            public String getRepository() {
                return GitHubService.this.repository;
            }

            @Override
            public String getFileName() {
                return "languages";
            }

            @Override
            public String getURLSuffix() {
                return "/languages";
            }
        });
    }

    public Set<GitHubConnector> getConnectors() {
        return this.connectors;
    }

    public ConcurrentMap<String, Contributor> getContributors() {
        return this.contributors;
    }

    public int getForks() {
        return this.forks;
    }

    public int getStars() {
        return this.stars;
    }

    public int getIssues() {
        return this.issues;
    }

    public int getPullRequests() {
        return this.pullRequests;
    }

    public int getCodeSize() {
        return this.codeBytes;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean isLoggingEnabled() {
        return this.logging;
    }
}

