/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.ancient_altar;

import io.github.thebusybiscuit.slimefun4.implementation.listeners.AncientAltarListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RitualAnimation
implements Runnable {
    private final List<Block> altars;
    private final Block altar;
    private final Location dropLocation;
    private final ItemStack output;
    private final List<Block> pedestals;
    private final List<ItemStack> items;
    private final Collection<Location> particleLocations = new LinkedList<Location>();
    private final Map<Item, Location> itemLock = new HashMap<Item, Location>();
    private boolean running;
    private int stage;

    public RitualAnimation(List<Block> altars, Block altar, Location drop, ItemStack output, List<Block> pedestals, List<ItemStack> items) {
        this.dropLocation = drop;
        this.altar = altar;
        this.altars = altars;
        this.output = output;
        this.pedestals = pedestals;
        this.items = items;
        this.running = true;
        this.stage = 0;
        for (Block pedestal : this.pedestals) {
            Item item = AncientAltarListener.findItem(pedestal);
            this.itemLock.put(item, item.getLocation().clone());
        }
    }

    @Override
    public void run() {
        this.idle();
        if (!this.checkLockedItems()) {
            this.abort();
            return;
        }
        if (this.stage == 36) {
            this.finish();
            return;
        }
        if (this.stage > 0 && this.stage % 4 == 0) {
            this.checkPedestal(this.pedestals.get(this.stage / 4 - 1));
        }
        ++this.stage;
        Slimefun.runSync(this, 8L);
    }

    private boolean checkLockedItems() {
        for (Map.Entry<Item, Location> entry : this.itemLock.entrySet()) {
            if (!(entry.getKey().getLocation().distanceSquared(entry.getValue()) > 0.1)) continue;
            return false;
        }
        return true;
    }

    private void idle() {
        this.dropLocation.getWorld().spawnParticle(Particle.SPELL_WITCH, this.dropLocation, 16, (double)1.2f, 0.0, (double)1.2f);
        this.dropLocation.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, this.dropLocation, 8, (double)0.2f, 0.0, (double)0.2f);
        for (Location loc : this.particleLocations) {
            this.dropLocation.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, loc, 16, (double)0.3f, (double)0.2f, (double)0.3f);
            this.dropLocation.getWorld().spawnParticle(Particle.CRIT_MAGIC, loc, 8, (double)0.3f, (double)0.2f, (double)0.3f);
        }
    }

    private void checkPedestal(Block pedestal) {
        Item item = AncientAltarListener.findItem(pedestal);
        if (item == null || this.itemLock.remove(item) == null) {
            this.abort();
        } else {
            this.particleLocations.add(pedestal.getLocation().add(0.5, 1.5, 0.5));
            this.items.add(AncientAltarListener.fixItemStack(item.getItemStack(), item.getCustomName()));
            pedestal.getWorld().playSound(pedestal.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 2.0f);
            this.dropLocation.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, pedestal.getLocation().add(0.5, 1.5, 0.5), 16, (double)0.3f, (double)0.2f, (double)0.3f);
            this.dropLocation.getWorld().spawnParticle(Particle.CRIT_MAGIC, pedestal.getLocation().add(0.5, 1.5, 0.5), 8, (double)0.3f, (double)0.2f, (double)0.3f);
            this.itemLock.remove(item);
            item.remove();
            pedestal.removeMetadata("item_placed", (Plugin)SlimefunPlugin.instance);
        }
    }

    private void abort() {
        this.running = false;
        AncientAltarListener listener = SlimefunPlugin.getAncientAltarListener();
        this.pedestals.forEach(b -> listener.getAltarsInUse().remove(b.getLocation()));
        listener.getAltarsInUse().remove(this.altar.getLocation());
        this.dropLocation.getWorld().playSound(this.dropLocation, Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, 1.0f, 1.0f);
        this.itemLock.clear();
        this.altars.remove(this.altar);
    }

    private void finish() {
        if (this.running) {
            this.dropLocation.getWorld().playSound(this.dropLocation, Sound.ENTITY_ZOMBIE_VILLAGER_CURE, 1.0f, 1.0f);
            this.dropLocation.getWorld().playEffect(this.dropLocation, Effect.STEP_SOUND, (Object)Material.EMERALD_BLOCK);
            this.dropLocation.getWorld().dropItemNaturally(this.dropLocation.add(0.0, -0.5, 0.0), this.output);
            AncientAltarListener listener = SlimefunPlugin.getAncientAltarListener();
            this.pedestals.forEach(b -> listener.getAltarsInUse().remove(b.getLocation()));
            listener.getAltarsInUse().remove(this.altar.getLocation());
            this.altars.remove(this.altar);
        } else {
            this.dropLocation.getWorld().playSound(this.dropLocation, Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, 1.0f, 1.0f);
        }
    }
}

