/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.mrCookieSlime.Slimefun.cscorelib2.data.ComputedOptional;
import org.bukkit.ChatColor;

public class Contributor {
    private static final String PLACEHOLDER_HEAD = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDZiYTYzMzQ0ZjQ5ZGQxYzRmNTQ4OGU5MjZiZjNkOWUyYjI5OTE2YTZjNTBkNjEwYmI0MGE1MjczZGM4YzgyIn19fQ==";
    private final String ghName;
    private final String mcName;
    private final String profileLink;
    private final ConcurrentMap<String, Integer> contributions = new ConcurrentHashMap<String, Integer>();
    private final ComputedOptional<String> headTexture = ComputedOptional.createNew();

    public Contributor(String name, String profile) {
        this.ghName = profile.substring(profile.lastIndexOf(47) + 1);
        this.mcName = name;
        this.profileLink = profile;
    }

    public Contributor(String name) {
        this.ghName = name;
        this.mcName = name;
        this.profileLink = null;
    }

    public void setContribution(String role, int commits) {
        this.contributions.put(role, commits);
    }

    public String getName() {
        return this.ghName;
    }

    public String getMinecraftName() {
        return this.mcName;
    }

    public String getProfile() {
        return this.profileLink;
    }

    public List<Map.Entry<String, Integer>> getContributions() {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.contributions.entrySet());
        list.sort(Comparator.comparingInt(entry -> -((Integer)entry.getValue()).intValue()));
        return list;
    }

    public String getTexture() {
        if (!this.headTexture.isComputed() || !this.headTexture.isPresent()) {
            return PLACEHOLDER_HEAD;
        }
        return this.headTexture.get();
    }

    public boolean hasTexture() {
        return this.headTexture.isComputed();
    }

    public void setTexture(String skin) {
        this.headTexture.compute(skin);
    }

    public int getTotalContributions() {
        return this.contributions.values().stream().mapToInt(Integer::intValue).sum();
    }

    public int index() {
        return -this.getTotalContributions();
    }

    public String getDisplayName() {
        return ChatColor.GRAY + this.ghName + (!this.ghName.equals(this.mcName) ? ChatColor.DARK_GRAY + " (MC: " + this.mcName + ")" : "");
    }
}

