/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import io.github.thebusybiscuit.slimefun4.api.blocks.SlimefunBlock;
import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.api.items.ItemRestriction;
import io.github.thebusybiscuit.slimefun4.core.SlimefunWorld;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.mrCookieSlime.Slimefun.GEO.OreGenResource;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public interface SlimefunAPI {
    public void addItemRestriction(ItemRestriction var1);

    public Set<ItemRestriction> getItemRestrictions();

    default public boolean isAllowedToUse(Player p, ItemStack item, boolean sendWarnings) {
        PlayerProfile profile = PlayerProfile.get((OfflinePlayer)p);
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        for (ItemRestriction restriction : this.getItemRestrictions()) {
            if (restriction.isAllowed(profile, p, sfItem, item)) continue;
            if (sendWarnings) {
                restriction.warnPlayer(profile, p, sfItem, item);
            }
            return false;
        }
        return true;
    }

    public Set<Category> getCategories();

    default public Set<SlimefunItem> getItems() {
        return this.getCategories().stream().flatMap(cat -> cat.getItems().stream()).collect(Collectors.toSet());
    }

    public Optional<SlimefunItem> getSlimefunItem(ItemStack var1);

    public Optional<SlimefunBlock> getBlock(Block var1);

    public SlimefunWorld getWorld(World var1);

    public PlayerProfile getPlayer(OfflinePlayer var1);

    public void registerGEOResource(GEOResource var1);

    public Collection<OreGenResource> getGEOResources();
}

