/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.data;

import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.data.OptionalState;

public final class ComputedOptional<T> {
    private OptionalState state;
    private T value;

    private ComputedOptional(OptionalState state) {
        this.state = state;
    }

    private ComputedOptional(T value) {
        this.state = OptionalState.COMPUTED;
        this.value = value;
    }

    public static <T> ComputedOptional<T> empty() {
        return new ComputedOptional<T>(OptionalState.EMPTY);
    }

    public static <T> ComputedOptional<T> createNew() {
        return new ComputedOptional<T>(OptionalState.NOT_COMPUTED);
    }

    public static <T> ComputedOptional<T> of(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new ComputedOptional<T>(value);
    }

    public static <T> ComputedOptional<T> ofNullable(T value) {
        if (value == null) {
            return ComputedOptional.empty();
        }
        return new ComputedOptional<T>(value);
    }

    public boolean isEmpty() {
        return this.state == OptionalState.EMPTY;
    }

    public boolean isComputed() {
        return this.state != OptionalState.NOT_COMPUTED;
    }

    public boolean isPresent() {
        return this.state == OptionalState.COMPUTED;
    }

    public void ifPresent(Consumer<T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public void compute(T value) {
        if (this.isComputed()) {
            throw new IllegalStateException("This Optional has already been computed.");
        }
        if (value == null) {
            this.state = OptionalState.EMPTY;
        } else {
            this.state = OptionalState.COMPUTED;
            this.value = value;
        }
    }

    public void compute(@NonNull Supplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        this.compute(supplier.get());
    }

    public T get() {
        if (!this.isPresent()) {
            throw new IllegalAccessError("This Optional has no value! Check .isPresent() first!");
        }
        return this.value;
    }

    public T getOrElse(T value) {
        if (!this.isComputed()) {
            throw new IllegalStateException("This Optional has not yet been computed!");
        }
        return this.isPresent() ? this.value : value;
    }
}

