/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.core.services.localization.SlimefunLocalization;
import io.github.thebusybiscuit.slimefun4.core.services.localization.SupportedLanguage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class LocalizationService
extends SlimefunLocalization {
    private static final String LANGUAGE_PATH = "language";
    private final Map<String, Language> languages = new LinkedHashMap<String, Language>();
    private final SlimefunPlugin plugin;
    private final NamespacedKey languageKey;
    private final Language defaultLanguage;

    public LocalizationService(SlimefunPlugin plugin, String serverDefaultLanguage) {
        super(plugin);
        this.plugin = plugin;
        this.languageKey = new NamespacedKey((Plugin)plugin, LANGUAGE_PATH);
        this.defaultLanguage = new Language(serverDefaultLanguage, this.getConfig().getConfiguration(), "11b3188fd44902f72602bd7c2141f5a70673a411adb3d81862c69e536166b");
        for (SupportedLanguage lang : SupportedLanguage.values()) {
            this.addLanguage(lang.getId(), lang.getTexture());
        }
        String language = this.getConfig().getString(LANGUAGE_PATH);
        if (language == null) {
            language = serverDefaultLanguage;
        }
        if (this.hasLanguage(serverDefaultLanguage)) {
            this.setLanguage(serverDefaultLanguage, !serverDefaultLanguage.equals(language));
        } else {
            this.setLanguage("en", false);
            plugin.getLogger().log(Level.WARNING, "Could not recognize the given language: \"{0}\"", serverDefaultLanguage);
        }
        this.setPrefix("&aSlimefun 4 &7> ");
        this.save();
    }

    public NamespacedKey getKey() {
        return this.languageKey;
    }

    @Override
    public Language getLanguage(String id) {
        return this.languages.get(id);
    }

    @Override
    public Collection<Language> getLanguages() {
        return this.languages.values();
    }

    @Override
    public boolean hasLanguage(String language) {
        return ((Object)((Object)this.plugin)).getClass().getResource("/languages/messages_" + language + ".yml") != null;
    }

    @Override
    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public Language getLanguage(Player p) {
        Optional<String> language = PersistentDataAPI.getOptionalString((PersistentDataHolder)p, this.languageKey);
        if (language.isPresent()) {
            return this.languages.get(language.get());
        }
        return this.getDefaultLanguage();
    }

    private void setLanguage(String language, boolean reset) {
        if (reset) {
            this.getConfig().clear();
        }
        Slimefun.getLogger().log(Level.INFO, "Loading language \"{0}\"", language);
        this.getConfig().setValue(LANGUAGE_PATH, language);
        String path = "/languages/messages_" + language + ".yml";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this.plugin)).getClass().getResourceAsStream(path)));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            this.getConfig().getConfiguration().setDefaults((Configuration)config);
        }
        catch (IOException e) {
            Slimefun.getLogger().log(Level.SEVERE, "Failed to load language file: \"" + path + "\"", e);
        }
        this.save();
    }

    private void addLanguage(String id, String hash) {
        FileConfiguration cfg;
        if (!this.hasLanguage(id)) {
            cfg = this.getConfig().getConfiguration();
        } else {
            String path = "/languages/messages_" + id + ".yml";
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this.plugin)).getClass().getResourceAsStream(path)));){
                cfg = YamlConfiguration.loadConfiguration((Reader)reader);
                cfg.setDefaults((Configuration)this.getConfig().getConfiguration());
            }
            catch (IOException e) {
                Slimefun.getLogger().log(Level.SEVERE, "Failed to load language file into memory: \"" + path + "\"", e);
                cfg = this.getConfig().getConfiguration();
            }
        }
        this.languages.put(id, new Language(id, cfg, hash));
    }
}

