/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines;

import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.holograms.HologramProjectorHologram;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemInteractionHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class HologramProjector
extends SimpleSlimefunItem<ItemInteractionHandler> {
    public HologramProjector(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        super(category, item, recipeType, recipe, recipeOutput);
        SlimefunItem.registerBlockHandler(this.getID(), new SlimefunBlockHandler(){

            @Override
            public void onPlace(Player p, Block b, SlimefunItem item) {
                BlockStorage.addBlockInfo(b, "text", "Edit me via the Projector");
                BlockStorage.addBlockInfo(b, "offset", "0.5");
                BlockStorage.addBlockInfo(b, "owner", p.getUniqueId().toString());
                HologramProjectorHologram.getArmorStand(b, true);
            }

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                HologramProjectorHologram.remove(b);
                return true;
            }
        });
    }

    @Override
    protected boolean areItemHandlersPrivate() {
        return false;
    }

    @Override
    public ItemInteractionHandler getItemHandler() {
        return (e, p, item) -> {
            if (e.getClickedBlock() == null) {
                return false;
            }
            String id = BlockStorage.checkID(e.getClickedBlock());
            if (id != null && id.equals(this.getID())) {
                e.setCancelled(true);
                if (BlockStorage.getLocationInfo(e.getClickedBlock().getLocation(), "owner").equals(p.getUniqueId().toString())) {
                    this.openEditor(p, e.getClickedBlock());
                }
                return true;
            }
            return false;
        };
    }

    private void openEditor(Player p, Block projector) {
        ChestMenu menu = new ChestMenu("Hologram Settings");
        menu.addItem(0, (ItemStack)new CustomItem(Material.NAME_TAG, "&7Text &e(Click to edit)", "", "&r" + ChatColors.color(BlockStorage.getLocationInfo(projector.getLocation(), "text"))));
        menu.addMenuClickHandler(0, (pl, slot, item, action) -> {
            pl.closeInventory();
            SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "machines.HOLOGRAM_PROJECTOR.enter-text", true);
            ChatUtils.awaitInput(pl, message -> {
                ArmorStand hologram = HologramProjectorHologram.getArmorStand(projector, true);
                hologram.setCustomName(ChatColors.color(message));
                BlockStorage.addBlockInfo(projector, "text", hologram.getCustomName());
                this.openEditor(pl, projector);
            });
            return false;
        });
        menu.addItem(1, (ItemStack)new CustomItem(new ItemStack(Material.CLOCK), "&7Offset: &e" + DoubleHandler.fixDouble(Double.valueOf(BlockStorage.getLocationInfo(projector.getLocation(), "offset")) + 1.0), "", "&rLeft Click: &7+0.1", "&rRight Click: &7-0.1"));
        menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
            double offset = DoubleHandler.fixDouble(Double.valueOf(BlockStorage.getLocationInfo(projector.getLocation(), "offset")) + (double)(action.isRightClicked() ? -0.1f : 0.1f));
            ArmorStand hologram = HologramProjectorHologram.getArmorStand(projector, true);
            Location l = new Location(projector.getWorld(), (double)projector.getX() + 0.5, (double)projector.getY() + offset, (double)projector.getZ() + 0.5);
            hologram.teleport(l);
            BlockStorage.addBlockInfo(projector, "offset", String.valueOf(offset));
            this.openEditor(pl, projector);
            return false;
        });
        menu.open(new Player[]{p});
    }
}

