/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.commands;

import io.github.thebusybiscuit.slimefun4.core.commands.SubCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.CheatCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.GiveCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.GuideCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.HelpCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.OpenGuideCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.ResearchCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.SearchCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.StatsCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.TeleporterCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.TimingsCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.VersionsCommand;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.electric.gps.ElevatorPlate;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SlimefunCommand
implements CommandExecutor,
Listener {
    private final List<SubCommand> commands = new LinkedList<SubCommand>();

    public SlimefunCommand(SlimefunPlugin plugin) {
        this.commands.add(new HelpCommand(plugin, this));
        this.commands.add(new VersionsCommand(plugin, this));
        this.commands.add(new CheatCommand(plugin, this));
        this.commands.add(new GuideCommand(plugin, this));
        this.commands.add(new GiveCommand(plugin, this));
        this.commands.add(new ResearchCommand(plugin, this));
        this.commands.add(new StatsCommand(plugin, this));
        this.commands.add(new TimingsCommand(plugin, this));
        this.commands.add(new TeleporterCommand(plugin, this));
        this.commands.add(new OpenGuideCommand(plugin, this));
        this.commands.add(new SearchCommand(plugin, this));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("debug_fish")) {
                if (sender instanceof Player && sender.isOp()) {
                    ((Player)sender).getInventory().addItem(new ItemStack[]{SlimefunItems.DEBUG_FISH});
                } else {
                    SlimefunPlugin.getLocal().sendMessage(sender, "messages.no-permission", true);
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("elevator")) {
                if (sender instanceof Player && args.length == 4) {
                    Player p = (Player)sender;
                    int x = Integer.parseInt(args[1]);
                    int y = Integer.parseInt(args[2]);
                    int z = Integer.parseInt(args[3]);
                    if (BlockStorage.getLocationInfo(p.getWorld().getBlockAt(x, y, z).getLocation(), "floor") != null) {
                        ((ElevatorPlate)SlimefunItem.getByID("ELEVATOR_PLATE")).getUsers().add(p.getUniqueId());
                        float yaw = p.getEyeLocation().getYaw() + 180.0f;
                        if (yaw > 180.0f) {
                            yaw = -180.0f + (yaw - 180.0f);
                        }
                        p.teleport(new Location(p.getWorld(), (double)x + 0.5, (double)y + 0.4, (double)z + 0.5, yaw, p.getEyeLocation().getPitch()));
                        String floor = BlockStorage.getLocationInfo(p.getWorld().getBlockAt(x, y, z).getLocation(), "floor");
                        p.sendTitle(ChatColor.RESET + ChatColors.color(floor), " ", 20, 60, 20);
                    }
                }
                return true;
            }
            for (SubCommand command : this.commands) {
                if (!args[0].equalsIgnoreCase(command.getName())) continue;
                command.onExecute(sender, args);
                return true;
            }
        }
        this.sendHelp(sender);
        return true;
    }

    public void sendHelp(CommandSender sender) {
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&aSlimefun &2v" + Slimefun.getVersion()));
        sender.sendMessage("");
        for (SubCommand cmd : this.commands) {
            sender.sendMessage(ChatColors.color("&3/sf " + cmd.getName() + " &b") + cmd.getDescription(sender));
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent e) {
        if (e.getMessage().equalsIgnoreCase("/help slimefun")) {
            this.sendHelp((CommandSender)e.getPlayer());
            e.setCancelled(true);
        }
    }

    public List<String> getTabArguments() {
        return this.commands.stream().map(SubCommand::getName).collect(Collectors.toList());
    }
}

