/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.item_transport;

import io.github.thebusybiscuit.slimefun4.utils.holograms.SimpleHologram;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.CargoManager;
import me.mrCookieSlime.Slimefun.api.item_transport.ChestTerminalSorter;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemRequest;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemSlot;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.api.item_transport.StoredItem;
import me.mrCookieSlime.Slimefun.api.network.Network;
import me.mrCookieSlime.Slimefun.api.network.NetworkComponent;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CargoNet
extends Network {
    public static boolean extraChannels = false;
    private static final int RANGE = 5;
    private static final int[] slots = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    public static final int[] terminal_slots = new int[]{0, 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 24, 27, 28, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42};
    public static final int TERMINAL_OUT_SLOT = 17;
    private static final ChestTerminalSorter sorter = new ChestTerminalSorter();
    private static final ItemStack terminal_noitem_item = new CustomItem(new ItemStack(Material.BARRIER), "&4No Item cached", new String[0]);
    private static final ChestMenu.MenuClickHandler terminal_noitem_handler = (p, slot, item, action) -> false;
    private Set<Location> inputNodes = new HashSet<Location>();
    private Set<Location> outputNodes = new HashSet<Location>();
    private final Set<Location> terminals = new HashSet<Location>();
    private final Set<Location> imports = new HashSet<Location>();
    private final Set<Location> exports = new HashSet<Location>();

    public static CargoNet getNetworkFromLocation(Location l) {
        return CargoNet.getNetworkFromLocation(l, CargoNet.class);
    }

    public static CargoNet getNetworkFromLocationOrCreate(Location l) {
        CargoNet cargoNetwork = CargoNet.getNetworkFromLocation(l);
        if (cargoNetwork == null) {
            cargoNetwork = new CargoNet(l);
            CargoNet.registerNetwork(cargoNetwork);
        }
        return cargoNetwork;
    }

    @Deprecated
    public static boolean isConnected(Block b) {
        return CargoNet.getNetworkFromLocation(b.getLocation()) != null;
    }

    protected CargoNet(Location l) {
        super(l);
    }

    @Override
    public int getRange() {
        return 5;
    }

    @Override
    public NetworkComponent classifyLocation(Location l) {
        String id = BlockStorage.checkID(l);
        if (id == null) {
            return null;
        }
        switch (id) {
            case "CARGO_MANAGER": {
                return NetworkComponent.REGULATOR;
            }
            case "CARGO_NODE": {
                return NetworkComponent.CONNECTOR;
            }
            case "CARGO_NODE_INPUT": 
            case "CARGO_NODE_OUTPUT": 
            case "CARGO_NODE_OUTPUT_ADVANCED": 
            case "CT_IMPORT_BUS": 
            case "CT_EXPORT_BUS": 
            case "CHEST_TERMINAL": {
                return NetworkComponent.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void locationClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        if (from == NetworkComponent.TERMINUS) {
            this.inputNodes.remove(l);
            this.outputNodes.remove(l);
            this.terminals.remove(l);
            this.imports.remove(l);
            this.exports.remove(l);
        }
        if (to == NetworkComponent.TERMINUS) {
            switch (BlockStorage.checkID(l)) {
                case "CARGO_NODE_INPUT": {
                    this.inputNodes.add(l);
                    break;
                }
                case "CARGO_NODE_OUTPUT": 
                case "CARGO_NODE_OUTPUT_ADVANCED": {
                    this.outputNodes.add(l);
                    break;
                }
                case "CHEST_TERMINAL": {
                    this.terminals.add(l);
                    break;
                }
                case "CT_IMPORT_BUS": {
                    this.imports.add(l);
                    break;
                }
                case "CT_EXPORT_BUS": {
                    this.exports.add(l);
                    break;
                }
            }
        }
    }

    public void tick(Block b) {
        if (!this.regulator.equals((Object)b.getLocation())) {
            SimpleHologram.update(b, "&4Multiple Cargo Regulators connected");
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            SimpleHologram.update(b, "&cNo Cargo Nodes found");
        } else {
            SimpleHologram.update(b, "&7Status: &a&lONLINE");
            HashMap<Integer, List> output = new HashMap<Integer, List>();
            LinkedList<Location> list = new LinkedList<Location>();
            int lastFrequency = -1;
            for (Location outputNode : this.outputNodes) {
                int frequency = CargoNet.getFrequency(outputNode);
                if (frequency != lastFrequency && lastFrequency != -1) {
                    output.merge(lastFrequency, list, (prev, next) -> {
                        prev.addAll(next);
                        return prev;
                    });
                    list = new LinkedList();
                }
                list.add(outputNode);
                lastFrequency = frequency;
            }
            if (!list.isEmpty()) {
                output.merge(lastFrequency, list, (prev, next) -> {
                    prev.addAll(next);
                    return prev;
                });
            }
            HashSet<Location> providers = new HashSet<Location>();
            HashSet destinations = new HashSet();
            List output16 = (List)output.get(16);
            if (output16 != null) {
                destinations.addAll(output16);
            }
            for (Location inputNode : this.inputNodes) {
                int frequency = CargoNet.getFrequency(inputNode);
                if (frequency != 16) continue;
                providers.add(inputNode);
            }
            Slimefun.runSync(() -> {
                Block target;
                if (BlockStorage.getLocationInfo(b.getLocation(), "visualizer") == null) {
                    this.display();
                }
                if (extraChannels) {
                    BlockMenu menu;
                    for (Location bus : this.imports) {
                        menu = BlockStorage.getInventory(bus);
                        if (menu.getItemInSlot(17) == null) {
                            target = CargoNet.getAttachedBlock(bus.getBlock());
                            ItemSlot stack = CargoManager.withdraw(bus.getBlock(), target, -1);
                            if (stack != null) {
                                menu.replaceExistingItem(17, stack.getItem());
                            }
                        }
                        if (menu.getItemInSlot(17) == null) continue;
                        SlimefunPlugin.getUtilities().itemRequests.add(new ItemRequest(bus, 17, menu.getItemInSlot(17), ItemTransportFlow.INSERT));
                    }
                    for (Location bus : this.exports) {
                        menu = BlockStorage.getInventory(bus);
                        if (menu.getItemInSlot(17) != null) {
                            target = CargoNet.getAttachedBlock(bus.getBlock());
                            menu.replaceExistingItem(17, CargoManager.insert(bus.getBlock(), target, menu.getItemInSlot(17), -1));
                        }
                        if (menu.getItemInSlot(17) != null) continue;
                        ArrayList<CustomItem> items = new ArrayList<CustomItem>();
                        for (int slot : slots) {
                            ItemStack template = menu.getItemInSlot(slot);
                            if (template == null) continue;
                            items.add(new CustomItem(template, 1));
                        }
                        if (items.isEmpty()) continue;
                        int index = Integer.parseInt(BlockStorage.getLocationInfo(bus, "index"));
                        if (++index > items.size() - 1) {
                            index = 0;
                        }
                        BlockStorage.addBlockInfo(bus, "index", String.valueOf(index));
                        SlimefunPlugin.getUtilities().itemRequests.add(new ItemRequest(bus, 17, (ItemStack)items.get(index), ItemTransportFlow.WITHDRAW));
                    }
                    for (Location terminal : this.terminals) {
                        menu = BlockStorage.getInventory(terminal);
                        ItemStack sendingItem = menu.getItemInSlot(17);
                        if (sendingItem == null) continue;
                        SlimefunPlugin.getUtilities().itemRequests.add(new ItemRequest(terminal, 17, sendingItem, ItemTransportFlow.INSERT));
                    }
                    Iterator<Object> iterator = SlimefunPlugin.getUtilities().itemRequests.iterator();
                    while (iterator.hasNext()) {
                        ItemRequest request = (ItemRequest)iterator.next();
                        if (!this.terminals.contains(request.getTerminal()) && !this.imports.contains(request.getTerminal()) && !this.exports.contains(request.getTerminal())) continue;
                        menu = BlockStorage.getInventory(request.getTerminal());
                        switch (request.getDirection()) {
                            case INSERT: {
                                ItemStack requestedItem = request.getItem();
                                for (Location l : destinations) {
                                    Block target2 = CargoNet.getAttachedBlock(l.getBlock());
                                    requestedItem = CargoManager.insert(l.getBlock(), target2, requestedItem, -1);
                                    if (requestedItem != null) continue;
                                    menu.replaceExistingItem(request.getSlot(), null);
                                    break;
                                }
                                if (requestedItem != null) {
                                    menu.replaceExistingItem(request.getSlot(), requestedItem);
                                }
                                iterator.remove();
                                break;
                            }
                            case WITHDRAW: {
                                int slot = request.getSlot();
                                ItemStack prevStack = menu.getItemInSlot(slot);
                                if (!(prevStack == null || prevStack.getAmount() + request.getItem().getAmount() <= prevStack.getMaxStackSize() && SlimefunManager.isItemSimilar(prevStack, new CustomItem(request.getItem(), 1), true))) {
                                    iterator.remove();
                                    break;
                                }
                                Object stack = null;
                                ItemStack requested = request.getItem();
                                for (Location l : providers) {
                                    Block target3 = CargoNet.getAttachedBlock(l.getBlock());
                                    ItemStack is2 = CargoManager.withdraw(l.getBlock(), target3, requested);
                                    if (is2 == null) continue;
                                    stack = stack == null ? is2 : new CustomItem((ItemStack)stack, stack.getAmount() + is2.getAmount());
                                    if (is2.getAmount() == requested.getAmount()) break;
                                    requested = new CustomItem(requested, requested.getAmount() - is2.getAmount());
                                }
                                if (stack != null) {
                                    ItemStack prev = menu.getItemInSlot(slot);
                                    if (prev == null) {
                                        menu.replaceExistingItem(slot, (ItemStack)stack);
                                    } else {
                                        menu.replaceExistingItem(slot, new CustomItem((ItemStack)stack, stack.getAmount() + prev.getAmount()));
                                    }
                                }
                                iterator.remove();
                                break;
                            }
                        }
                    }
                }
                for (Location input : this.inputNodes) {
                    List outputs;
                    ItemSlot slot;
                    int frequency = CargoNet.getFrequency(input);
                    if (frequency < 0 || frequency > 15) continue;
                    Block inputTarget = CargoNet.getAttachedBlock(input.getBlock());
                    ItemStack stack = null;
                    int previousSlot = -1;
                    Config cfg = BlockStorage.getLocationInfo(input);
                    boolean roundrobin = "true".equals(cfg.getString("round-robin"));
                    if (inputTarget != null && (slot = CargoManager.withdraw(input.getBlock(), inputTarget, Integer.parseInt(cfg.getString("index")))) != null) {
                        stack = slot.getItem();
                        previousSlot = slot.getSlot();
                    }
                    if (stack != null && (outputs = (List)output.get(frequency)) != null) {
                        Location out;
                        Block target4;
                        ArrayList<Location> outputlist = new ArrayList<Location>(outputs);
                        if (roundrobin) {
                            int cIndex = SlimefunPlugin.getUtilities().roundRobin.getOrDefault(input, 0);
                            if (cIndex < outputlist.size()) {
                                for (int i = 0; i < cIndex; ++i) {
                                    Location temp = (Location)outputlist.get(0);
                                    outputlist.remove(temp);
                                    outputlist.add(temp);
                                }
                                ++cIndex;
                            } else {
                                cIndex = 1;
                            }
                            SlimefunPlugin.getUtilities().roundRobin.put(input, cIndex);
                        }
                        Iterator cIndex = outputlist.iterator();
                        while (cIndex.hasNext() && ((target4 = CargoNet.getAttachedBlock((out = (Location)cIndex.next()).getBlock())) == null || (stack = CargoManager.insert(out.getBlock(), target4, stack, -1)) != null)) {
                        }
                    }
                    if (stack == null || previousSlot <= -1) continue;
                    DirtyChestMenu menu = CargoManager.getChestMenu(inputTarget);
                    if (menu != null) {
                        menu.replaceExistingItem(previousSlot, stack);
                        continue;
                    }
                    BlockState state = inputTarget.getState();
                    if (!(state instanceof InventoryHolder)) continue;
                    Inventory inv = ((InventoryHolder)state).getInventory();
                    inv.setItem(previousSlot, stack);
                }
                if (extraChannels) {
                    ArrayList<StoredItem> items = new ArrayList<StoredItem>();
                    for (Location l : providers) {
                        target = CargoNet.getAttachedBlock(l.getBlock());
                        UniversalBlockMenu menu = BlockStorage.getUniversalInventory(target);
                        if (menu != null) {
                            for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                                ItemStack is3 = menu.getItemInSlot(slot);
                                this.filter(is3, items, l);
                            }
                            continue;
                        }
                        if (BlockStorage.hasInventory(target)) {
                            BlockMenu blockMenu = BlockStorage.getInventory(target);
                            Config cfg = BlockStorage.getLocationInfo(target.getLocation());
                            if (cfg.getString("id").startsWith("BARREL_") && cfg.getString("storedItems") != null) {
                                int stored = Integer.parseInt(cfg.getString("storedItems"));
                                int[] slot = blockMenu.getPreset().getSlotsAccessedByItemTransport(blockMenu, ItemTransportFlow.WITHDRAW, null);
                                int is3 = slot.length;
                                for (int inv = 0; inv < is3; ++inv) {
                                    int slot2 = slot[inv];
                                    ItemStack is4 = blockMenu.getItemInSlot(slot2);
                                    if (is4 == null || !CargoManager.matchesFilter(l.getBlock(), is4, -1)) continue;
                                    boolean add = true;
                                    for (StoredItem item : items) {
                                        if (!SlimefunManager.isItemSimilar(is4, item.getItem(), true)) continue;
                                        add = false;
                                        item.add(is4.getAmount() + stored);
                                    }
                                    if (!add) continue;
                                    items.add(new StoredItem(new CustomItem(is4, 1), is4.getAmount() + stored));
                                }
                                continue;
                            }
                            this.handleWithdraw(blockMenu, items, l);
                            continue;
                        }
                        BlockState state = target.getState();
                        if (!(state instanceof InventoryHolder)) continue;
                        Inventory inv = ((InventoryHolder)state).getInventory();
                        for (ItemStack is5 : inv.getContents()) {
                            this.filter(is5, items, l);
                        }
                    }
                    Collections.sort(items, sorter);
                    for (Location l : this.terminals) {
                        BlockMenu menu = BlockStorage.getInventory(l);
                        int page = Integer.parseInt(BlockStorage.getLocationInfo(l, "page"));
                        if (!items.isEmpty() && items.size() < (page - 1) * terminal_slots.length + 1) {
                            page = 1;
                            BlockStorage.addBlockInfo(l, "page", String.valueOf(1));
                        }
                        for (int i = 0; i < terminal_slots.length; ++i) {
                            int slot = terminal_slots[i];
                            if (items.size() > i + terminal_slots.length * (page - 1)) {
                                StoredItem item = (StoredItem)items.get(i + terminal_slots.length * (page - 1));
                                ItemStack stack = item.getItem().clone();
                                ItemMeta im = stack.getItemMeta();
                                ArrayList<String> lore = new ArrayList<String>();
                                lore.add("");
                                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Stored Items: &r" + DoubleHandler.getFancyDouble(item.getAmount()))));
                                if (stack.getMaxStackSize() > 1) {
                                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7<Left Click: Request 1 | Right Click: Request " + (item.getAmount() > stack.getMaxStackSize() ? stack.getMaxStackSize() : item.getAmount()) + ">")));
                                } else {
                                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7<Left Click: Request 1>"));
                                }
                                lore.add("");
                                if (im.hasLore()) {
                                    lore.addAll(im.getLore());
                                }
                                im.setLore(lore);
                                stack.setItemMeta(im);
                                menu.replaceExistingItem(slot, stack);
                                menu.addMenuClickHandler(slot, (p, sl, is, action) -> {
                                    int amount = item.getAmount() > item.getItem().getMaxStackSize() ? item.getItem().getMaxStackSize() : item.getAmount();
                                    SlimefunPlugin.getUtilities().itemRequests.add(new ItemRequest(l, 44, new CustomItem(item.getItem(), action.isRightClicked() ? amount : 1), ItemTransportFlow.WITHDRAW));
                                    return false;
                                });
                                continue;
                            }
                            menu.replaceExistingItem(slot, terminal_noitem_item);
                            menu.addMenuClickHandler(slot, terminal_noitem_handler);
                        }
                    }
                }
            });
        }
    }

    private static Block getAttachedBlock(Block block) {
        if (block.getBlockData() instanceof Directional) {
            return block.getRelative(((Directional)block.getBlockData()).getFacing().getOppositeFace());
        }
        return null;
    }

    private static int getFrequency(Location l) {
        int freq = 0;
        try {
            String str = BlockStorage.getLocationInfo(l).getString("frequency");
            if (str != null) {
                freq = Integer.parseInt(str);
            }
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, "An Error occured while parsing a Cargo Node Frequency", x);
        }
        return freq;
    }

    private void handleWithdraw(BlockMenu menu, List<StoredItem> items, Location l) {
        for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
            this.filter(menu.getItemInSlot(slot), items, l);
        }
    }

    private void filter(ItemStack is, List<StoredItem> items, Location l) {
        if (is != null && CargoManager.matchesFilter(l.getBlock(), is, -1)) {
            boolean add = true;
            for (StoredItem item : items) {
                if (!SlimefunManager.isItemSimilar(is, item.getItem(), true)) continue;
                add = false;
                item.add(is.getAmount());
            }
            if (add) {
                items.add(new StoredItem(new CustomItem(is, 1), is.getAmount()));
            }
        }
    }
}

