/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.GitHubService;
import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.cscorelib2.players.MinecraftAccount;

public class GitHubTask
implements Runnable {
    private final GitHubService gitHubService;

    public GitHubTask(GitHubService github) {
        this.gitHubService = github;
    }

    @Override
    public void run() {
        this.gitHubService.getConnectors().forEach(GitHubConnector::pullFile);
        HashMap<String, String> skins = new HashMap<String, String>();
        for (Contributor contributor : this.gitHubService.getContributors().values()) {
            if (contributor.hasTexture()) continue;
            try {
                if (skins.containsKey(contributor.getMinecraftName())) {
                    contributor.setTexture(Optional.of(skins.get(contributor.getMinecraftName())));
                    continue;
                }
                contributor.setTexture(this.grabTexture(skins, contributor.getMinecraftName()));
            }
            catch (IllegalArgumentException x) {
                contributor.setTexture(Optional.empty());
            }
            catch (MinecraftAccount.TooManyRequestsException x) {
                break;
            }
        }
    }

    private Optional<String> grabTexture(Map<String, String> skins, String username) throws MinecraftAccount.TooManyRequestsException {
        Optional<UUID> uuid = MinecraftAccount.getUUID(username);
        if (uuid.isPresent()) {
            Optional<String> skin = MinecraftAccount.getSkin(uuid.get());
            skins.put(username, skin.orElse(""));
            return skin;
        }
        return Optional.empty();
    }
}

