/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SeasonalCategory;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Category {
    private final ItemStack item;
    private final List<SlimefunItem> items;
    private final int tier;

    public Category(ItemStack item) {
        this(item, 3);
    }

    public Category(ItemStack item, int tier) {
        this.item = item;
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        this.item.setItemMeta(meta);
        this.items = new ArrayList<SlimefunItem>();
        this.tier = tier;
    }

    public void register() {
        SlimefunPlugin.getUtilities().allCategories.add(this);
        Collections.sort(Category.list(), SlimefunPlugin.getUtilities().categorySorter);
        if (this instanceof SeasonalCategory) {
            if (((SeasonalCategory)this).isUnlocked()) {
                SlimefunPlugin.getUtilities().enabledCategories.add(this);
            }
        } else {
            SlimefunPlugin.getUtilities().enabledCategories.add(this);
        }
        Collections.sort(SlimefunPlugin.getUtilities().enabledCategories, SlimefunPlugin.getUtilities().categorySorter);
    }

    public static List<Category> list() {
        return SlimefunPlugin.getUtilities().allCategories;
    }

    public void add(SlimefunItem item) {
        this.items.add(item);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public List<SlimefunItem> getItems() {
        return this.items;
    }

    public int getTier() {
        return this.tier;
    }

    public String toString() {
        return "Slimefun Category {" + this.item.getItemMeta().getDisplayName() + ",tier=" + this.tier + "}";
    }
}

