/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.energy;

import java.util.HashSet;
import java.util.Set;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.energy.EnergyNetComponent;
import me.mrCookieSlime.Slimefun.api.network.Network;
import me.mrCookieSlime.Slimefun.api.network.NetworkComponent;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.holograms.EnergyHologram;
import me.mrCookieSlime.Slimefun.holograms.SimpleHologram;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class EnergyNet
extends Network {
    private static final int RANGE = 6;
    private Set<Location> input = new HashSet<Location>();
    private Set<Location> storage = new HashSet<Location>();
    private Set<Location> output = new HashSet<Location>();

    public static EnergyNetComponent getComponent(Block b) {
        return EnergyNet.getComponent(b.getLocation());
    }

    public static EnergyNetComponent getComponent(String id) {
        if (SlimefunPlugin.getUtilities().energyNetInput.contains(id)) {
            return EnergyNetComponent.SOURCE;
        }
        if (SlimefunPlugin.getUtilities().energyNetStorage.contains(id)) {
            return EnergyNetComponent.DISTRIBUTOR;
        }
        if (SlimefunPlugin.getUtilities().energyNetOutput.contains(id)) {
            return EnergyNetComponent.CONSUMER;
        }
        return EnergyNetComponent.NONE;
    }

    public static EnergyNetComponent getComponent(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return EnergyNetComponent.NONE;
        }
        String id = BlockStorage.checkID(l);
        if (SlimefunPlugin.getUtilities().energyNetInput.contains(id)) {
            return EnergyNetComponent.SOURCE;
        }
        if (SlimefunPlugin.getUtilities().energyNetStorage.contains(id)) {
            return EnergyNetComponent.DISTRIBUTOR;
        }
        if (SlimefunPlugin.getUtilities().energyNetOutput.contains(id)) {
            return EnergyNetComponent.CONSUMER;
        }
        return EnergyNetComponent.NONE;
    }

    public static void registerComponent(String id, EnergyNetComponent component) {
        switch (component) {
            case CONSUMER: {
                SlimefunPlugin.getUtilities().energyNetOutput.add(id);
                break;
            }
            case DISTRIBUTOR: {
                SlimefunPlugin.getUtilities().energyNetStorage.add(id);
                break;
            }
            case SOURCE: {
                SlimefunPlugin.getUtilities().energyNetInput.add(id);
                break;
            }
        }
    }

    public static EnergyNet getNetworkFromLocation(Location l) {
        return EnergyNet.getNetworkFromLocation(l, EnergyNet.class);
    }

    public static EnergyNet getNetworkFromLocationOrCreate(Location l) {
        EnergyNet energyNetwork = EnergyNet.getNetworkFromLocation(l);
        if (energyNetwork == null) {
            energyNetwork = new EnergyNet(l);
            EnergyNet.registerNetwork(energyNetwork);
        }
        return energyNetwork;
    }

    protected EnergyNet(Location l) {
        super(l);
    }

    @Override
    public int getRange() {
        return 6;
    }

    @Override
    public NetworkComponent classifyLocation(Location l) {
        if (this.regulator.equals((Object)l)) {
            return NetworkComponent.REGULATOR;
        }
        switch (EnergyNet.getComponent(l)) {
            case DISTRIBUTOR: {
                return NetworkComponent.CONNECTOR;
            }
            case CONSUMER: 
            case SOURCE: {
                return NetworkComponent.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void locationClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        if (from == NetworkComponent.TERMINUS) {
            this.input.remove(l);
            this.output.remove(l);
        }
        switch (EnergyNet.getComponent(l)) {
            case DISTRIBUTOR: {
                if (!ChargableBlock.isCapacitor(l)) break;
                this.storage.add(l);
                break;
            }
            case CONSUMER: {
                this.output.add(l);
                break;
            }
            case SOURCE: {
                this.input.add(l);
                break;
            }
        }
    }

    public void tick(Block b) {
        if (!this.regulator.equals((Object)b.getLocation())) {
            SimpleHologram.update(b, "&4Multiple Energy Regulators connected");
            return;
        }
        super.tick();
        double supply = 0.0;
        double demand = 0.0;
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            SimpleHologram.update(b, "&4No Energy Network found");
        } else {
            int capacity;
            HashSet<Location> exploded = new HashSet<Location>();
            for (Location source : this.input) {
                long timestamp = System.currentTimeMillis();
                SlimefunItem item = BlockStorage.check(source);
                double energy = item.getEnergyTicker().generateEnergy(source, item, BlockStorage.getLocationInfo(source));
                if (item.getEnergyTicker().explode(source)) {
                    exploded.add(source);
                    BlockStorage.clearBlockInfo(source);
                    Slimefun.runSync(() -> {
                        source.getBlock().setType(Material.LAVA);
                        source.getWorld().createExplosion(source, 0.0f, false);
                    });
                } else {
                    supply += energy;
                }
                SlimefunPlugin.getTicker().addBlockTimings(source, System.currentTimeMillis() - timestamp);
            }
            this.input.removeAll(exploded);
            for (Location battery : this.storage) {
                supply += (double)ChargableBlock.getCharge(battery);
            }
            int available = (int)DoubleHandler.fixDouble(supply);
            for (Location destination : this.output) {
                capacity = ChargableBlock.getMaxCharge(destination);
                int charge = ChargableBlock.getCharge(destination);
                if (charge >= capacity) continue;
                int rest = capacity - charge;
                demand += (double)rest;
                if (available <= 0) continue;
                if (available > rest) {
                    ChargableBlock.setUnsafeCharge(destination, capacity, false);
                    available -= rest;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(destination, charge + available, false);
                available = 0;
            }
            for (Location battery : this.storage) {
                if (available > 0) {
                    capacity = ChargableBlock.getMaxCharge(battery);
                    if (available > capacity) {
                        ChargableBlock.setUnsafeCharge(battery, capacity, true);
                        available -= capacity;
                        continue;
                    }
                    ChargableBlock.setUnsafeCharge(battery, available, true);
                    available = 0;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(battery, 0, true);
            }
            for (Location source : this.input) {
                if (!ChargableBlock.isChargable(source)) continue;
                if (available > 0) {
                    capacity = ChargableBlock.getMaxCharge(source);
                    if (available > capacity) {
                        ChargableBlock.setUnsafeCharge(source, capacity, false);
                        available -= capacity;
                        continue;
                    }
                    ChargableBlock.setUnsafeCharge(source, available, false);
                    available = 0;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(source, 0, false);
            }
            EnergyHologram.update(b, supply, demand);
        }
    }
}

