/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.chat.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.ChatComponentColor;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.ClickEvent;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.HoverEvent;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.Packets;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.ReflectionUtils;
import org.bukkit.entity.Player;

public class ChatComponent {
    private static Constructor<?> packetConstructor;
    private static Class<?> serializerClass;
    private static Method serializerMethod;
    private final JsonObject json;

    public ChatComponent(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.json = new JsonObject();
        this.json.addProperty("text", text);
    }

    public void setColor(@NonNull ChatComponentColor color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.json.addProperty("color", color.toString());
    }

    public void setBold(boolean bold) {
        this.json.addProperty("bold", Boolean.valueOf(bold));
    }

    public void setItalic(boolean italic) {
        this.json.addProperty("italic", Boolean.valueOf(italic));
    }

    public void setUnderlined(boolean underlined) {
        this.json.addProperty("underlined", Boolean.valueOf(underlined));
    }

    public void setStrikethrough(boolean strikethrough) {
        this.json.addProperty("strikethrough", Boolean.valueOf(strikethrough));
    }

    public void setObfuscated(boolean obfuscated) {
        this.json.addProperty("obfuscated", Boolean.valueOf(obfuscated));
    }

    public void setHoverEvent(@NonNull HoverEvent hoverEvent) {
        if (hoverEvent == null) {
            throw new NullPointerException("hoverEvent is marked non-null but is null");
        }
        this.json.add("hoverEvent", (JsonElement)hoverEvent.asJson());
    }

    public void setClickEvent(@NonNull ClickEvent clickEvent) {
        if (clickEvent == null) {
            throw new NullPointerException("clickEvent is marked non-null but is null");
        }
        this.json.add("clickEvent", (JsonElement)clickEvent.asJson());
    }

    public void append(@NonNull ChatComponent component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.json.add("extra", (JsonElement)component.asJson());
    }

    public JsonObject asJson() {
        return this.json;
    }

    private Object getPacket() {
        try {
            return packetConstructor.newInstance(serializerMethod.invoke(serializerClass, this.json));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void send(Player ... players) {
        if (players.length == 0) {
            return;
        }
        Object packet = this.getPacket();
        if (packet == null) {
            return;
        }
        for (Player p : players) {
            try {
                Packets.send(p, packet);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            packetConstructor = ReflectionUtils.getNMSClass("PacketPlayOutChat").getConstructor(ReflectionUtils.getNMSClass("IChatBaseComponent"));
            serializerClass = ReflectionUtils.getInnerNMSClass("IChatBaseComponent", "ChatSerializer");
            serializerMethod = ReflectionUtils.getMethod(serializerClass, "a", JsonElement.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            System.err.println("Perhaps you forgot to shade CS-CoreLib's \"reflection\" package?");
            e.printStackTrace();
        }
    }
}

